<TeXmacs|0.3.4.8>

<style|help>

<\body>
  <section|Typing Russian><label|kbd:russian>

  In order to type Russian text, you should select Russian as the language of
  your document. <apply|TeXmacs> starts with Russian menus, if it detects
  that the Russian locale is set. You can also enforce this behaviour by
  selecting Options <with|mode|math|\<rightarrow\>> language
  <with|mode|math|\<rightarrow\>> russian.

  If your X server uses the xkb extension, and is instructed to switch
  between the Latin and Russian keyboard modes, you need not do anything
  special. Just switch your keyboard to the Russian mode, and go ahead. All
  the software needed for this is included in modern Linux distributions, and
  the xkb extension is enabled by default in <with|font
  family|tt|XF86Config>. With the xkb extension, keysyms are 2-byte, and
  Russian letters are at 0x6??. The keyboard is configured by <with|font
  family|tt|setxkbmap>. When X starts, it issues this command with the
  system-wide <with|font family|tt|Xkbmap> file (usually living in <with|font
  family|tt|/etc/X11/xinit>), if it exists; and then with the user's
  <with|font family|tt|~/.Xkbmap>, if it exists. A typical <with|font
  family|tt|~/.Xkbmap> may look like

  <\verbatim>
    ru basic grp:shift_toggle
  </verbatim>

  This means that the keyboard mode is toggled by
  <key|l-shift>+<key|r-shift>. Other popular choices are
  <key|ctrl>+<key|shift> or <key|ctrl>+<key|alt>, see <with|font
  family|tt|/usr/X11R6/lib/X11/xkb/> for more details. This is the preferred
  keyboard setup for modern Linux systems, if you plan to use Russian often.

  In older Linux systems, the xkb extension is often disabled. Keysyms are
  1-byte, and are configured by <with|font family|tt|xmodmap>. When X starts,
  it issues this command with the system-wide <with|font family|tt|Xmodmap>
  (usually living in <with|font family|tt|/etc/X11/xinit>), if it exists; and
  then with the user's <with|font family|tt|~/.Xmodmap>, if it exists. You
  can configure the mode toggling key combination, and use a 1-byte Russian
  encoding (such as koi8-r) in the Russian mode. It is easier to download the
  package <with|font family|tt|xruskb>, and just run

  <\verbatim>
    xrus jcuken-koi8
  </verbatim>

  at the beginning of your X session. This sets the layout jcuken (see below)
  and the encoding koi8-r for your keyboard in the Russian mode. If you use
  such keyboard setup, you should select Options
  <with|mode|math|\<rightarrow\>> international keyboard
  <with|mode|math|\<rightarrow\>> russian <with|mode|math|\<rightarrow\>>
  koi8-r.

  It is also possible to use the Windows cp1251 encoding instead of koi8-r,
  though this is rarely done in UNIX. If you do use <with|font family|tt|xrus
  jcuken-cp1251>, select cp1251 instead of koi8-r.

  All the methods described above require some special actions to ``russify''
  the keyboard. This is not difficult, see Cyrillic-HOWTO (or, better, its
  updated version http://www.inp.nsk.su/ <with|font family|tt|><with|font
  family|tt|~baldin/Cyrillic-HOWTO-russian/Cyrillic-HOWTO-russian.html>).
  Also, all of the above methods globally affect all X applications: text
  editors (emacs, nedit, kedit...), xterms, <apply|TeXmacs> etc.

  If you need to type Russian only once, or very rarely, a proper keyboard
  setup may be more trouble than it's worth. For the benefit of such
  occasional users, <apply|TeXmacs> has methods of Russian input which
  require no preliminary work. Naturally, such methods affect only
  <apply|TeXmacs>, and no other application.

  The simplest way to type some Russian on the standard US-style keyboard
  with no software setup is to select Options <with|mode|math|\<rightarrow\>>
  international keyboard <with|mode|math|\<rightarrow\>> russian
  <with|mode|math|\<rightarrow\>> translit. Then, typing a Latin letter will
  produce ``the most similar'' Russian one. In order to get some Russian
  letters, you have to type 2- or 3-letter combinations:<vspace|0.5fn>

  <surround||<vspace|0.5fn>|<with|paragraph
  mode|center|<expand|block*|<tformat|<cwith|0|0|0|0|cell
  halign|l>|<cwith|1|1|3|3|cell row span|1>|<cwith|1|1|3|3|cell col
  span|2>|<cwith|1|1|0|0|cell vsep|0.2fn>|<cwith|1|1|1|1|cell
  background|yellow>|<cwith|1|1|3|3|cell background|yellow>|<cwith|0|0|2|2|ce\
  ll background|grey>|<cwith|0|0|5|5|cell
  background|grey>|<cwith|1|1|2|2|cell background|orange>|<cwith|1|1|5|5|cell
  background|orange>|<cwith|0|0|2|2|cell halign|c>|<cwith|0|0|5|5|cell
  halign|c>|<table|<row|<cell|Shorthand>|<cell|for>|<cell|Shorthand(s)>|<cell\
  |>|<cell|for>>|<row|<key|esc>-<key|">-<key|e>|<with|language|russian|font|c\
  yrillic|>|<key|esc>-<key|">-<key|E>||<with|language|russian|font|cyrillic|\
  >>|<row|<key|y>-<key|o>|<with|language|russian|font|cyrillic|>|<key|Y>-<k\
  ey|o>|<key|Y>-<key|O>|<with|language|russian|font|cyrillic|>>|<row|<key|z>\
  -<key|h>|<with|language|russian|font|cyrillic|>|<key|Z>-<key|h>|<key|Z>-<k\
  ey|H>|<with|language|russian|font|cyrillic|>>|<row|<key|j>-<key|*>|<with|l\
  anguage|russian|font|cyrillic|>|<key|J>-<key|*>||<with|language|russian|fo\
  nt|cyrillic|>>|<row|<key|c>-<key|h>|<with|language|russian|font|cyrillic|\
  >|<key|C>-<key|h>|<key|C>-<key|H>|<with|language|russian|font|cyrillic|>>|\
  <row|<key|s>-<key|h>|<with|language|russian|font|cyrillic|>|<key|S>-<key|h\
  >|<key|S>-<key|H>|<with|language|russian|font|cyrillic|>>|<row|<key|s>-<ke\
  y|c>-<key|h>|<with|language|russian|font|cyrillic|>|<key|S>-<key|c>-<key|h\
  >|<key|S>-<key|C>-<key|H>|<with|language|russian|font|cyrillic|>>|<row|<ke\
  y|e>-<key|*>|<with|language|russian|font|cyrillic|>|<key|E>-<key|*>||<with\
  |language|russian|font|cyrillic|>>|<row|<key|y>-<key|u>|<with|language|rus\
  sian|font|cyrillic|>|<key|Y>-<key|u>|<key|Y>-<key|U>|<with|language|russia\
  n|font|cyrillic|>>|<row|<key|y>-<key|a>|<with|language|russian|font|cyrill\
  ic|>|<key|Y>-<key|a>|<key|Y>-<key|A>|<with|language|russian|font|cyrillic|\
  >>>>>>>

  If you want to get, e.g., ``<with|language|russian|font|cyrillic|>'', and
  not ``<with|language|russian|font|cyrillic|>'', you have to type
  <key|s>-<key|/>-<key|h>. Of course, the choice of ``optimal'' mapping of
  Latin letters to Russian ones in not unique. You can investigate the
  mapping supplied with <apply|TeXmacs> and, if you don't like something,
  override it in your
  <with|font family|tt|~/.TeXmacs/progs/my-init-texmacs.scm>.

  If you select jcuken instead of translit, you get the ``official'' Russian
  typewriter layout. It is so called because the keys ``qwerty'' produce
  ``<with|language|russian|<with|font|cyrillic|>''. This input method
  is most useful> when you have a Russian-made keyboard, which has additional
  Russian letters written on the key caps in red, in the jcuken layout (a
  similar effect can be achieved by attaching transparent stickers with red
  Russian letters to caps of a US-style keyboard). It is also useful if you
  are an experienced Russian typist, and your fingers remember this layout.

  Those who have no Russian letters indicated at the key caps often prefer
  the yawerty layout, where the keys ``qwerty'' produce
  ``<with|language|russian|font|cyrillic|''. Each Latin letter is
  mapped into a ``similar'' Russian one; some additional Russian letters are
  produced by ><key|shift>-digits. <apply|TeXmacs> comes with a slightly
  modified yawerty layout, because it does not redefine the keys <key|$>,
  <key|>, <key|<with|mode|math|\<backslash\>>>, which are important for
  <apply|TeXmacs>, are not redefined. The corresponding Russian letters are
  produced by some <key|shift>-digit combinations instead.

  \;
</body>

<\initial>
  <\collection>
    <associate|shrinking factor|4>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|kbd:russian|<uninit>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate>
      toc
    <|associate>
      Typing Russian<htab|5mm>?
    </associate>
  </collection>
</auxiliary>
