
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : macaulay2.scm
;; DESCRIPTION : Special support for Macaulay 2
;; COPYRIGHT   : (C) 1999  Joris van der Hoeven
;;
;; This software falls under the GNU general public license and comes WITHOUT
;; ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for details.
;; If you don't have this file, write to the Free Software Foundation, Inc.,
;; 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Specific conversion routines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (macaulay2-input-var-row r)
  (if (not (null? r))
      (begin
	(display ", ")
	(cas-input (car r))
	(macaulay2-input-var-row (cdr r)))))

(define (macaulay2-input-row r)
  (display "{")
  (cas-input (car r))
  (macaulay2-input-var-row (cdr r))
  (display "}"))

(define (macaulay2-input-var-rows t)
  (if (not (null? t))
      (begin
	(display ", ")
	(macaulay2-input-row (car t))
	(macaulay2-input-var-rows (cdr t)))))

(define (macaulay2-input-rows t)
  (display "matrix({")
  (macaulay2-input-row (car t))
  (macaulay2-input-var-rows (cdr t))
  (display "})"))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Initialization
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(connection-declare "Macaulay2" "M2 --texmacs")
(connection-format "Macaulay2" "verbatim" "generic")
(set! session-menu (menu-merge session-menu
  '(("Macaulay 2" (make-session "Macaulay2" "default")))))
(define (in-macaulay2?) (equal? (get-env "prog language") "Macaulay2"))

(set! cas-input-current-cas "Macaulay2")
(cas-input-set! 'rows macaulay2-input-rows)
(display "")
