
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : htmlout.scm
;; DESCRIPTION : generation of Html from scheme expressions
;; COPYRIGHT   : (C) 2002  Joris van der Hoeven
;;
;; This software falls under the GNU general public license and comes WITHOUT
;; ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for details.
;; If you don't have this file, write to the Free Software Foundation, Inc.,
;; 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Data
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define htmlout-initialized #f)
(define htmlout-lang-big (make-hash-table 100))

(define htmlout-lang-big-def
  '(html body div p table tr ul ol li dl dt dd blockquote))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Initialization
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (htmlout-initialize)
  (if (not htmlout-initialized)
      (begin
	(set! htmlout-initialized #t)
	(fill-set htmlout-lang-big htmlout-lang-big-def))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Outputting main flow
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (htmlout-big? op)
  (hash-ref htmlout-lang-big op))

(define (htmlout-indent s plus)
  (if (htmlout-big? s)
      (begin
	(output-indent plus)
	(output-lf))
      (if (not (equal? s 'pre))
	  (output-text " "))))

(define (htmlout-open s)
  (output-text "<" s ">")
  (htmlout-indent s 2))

(define (htmlout-tag x)
  (output-text " " (car x) "=\"" (cadr x) "\""))

(define (htmlout-open-tags s l)
  (output-text "<" s)
  (exec-unary htmlout-tag l)
  (output-text ">")
  (htmlout-indent s 2))

(define (htmlout-close s)
  (htmlout-indent s -2)
  (output-text "</" s ">"))

(define (htmlout-args l big)
  (if (not (null? l))
      (begin
	(htmlout (car l))
	(if (and big (not (null? (cdr l)))) (output-lf))
	(htmlout-args (cdr l) big))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Main output routines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (htmlout x)
  (cond ((string? x) (output-text x))
	((null? x) (noop))
	((func? x '!concat)
	 (exec-unary htmlout (cdr x)))
	((null? (cdr x))
	 (output-text "<" (car x) ">"))
	((not (func? (cadr x) '@))
	 (htmlout-open (car x))
	 (htmlout-args (cdr x) (htmlout-big? (car x)))
	 (htmlout-close (car x)))
	(else
	 (htmlout-open-tags (car x) (cdadr x))
	 (htmlout-args (cddr x) (htmlout-big? (car x)))
	 (htmlout-close (car x)))))

(define (htmlout-produce x)
  (htmlout-initialize)
  (htmlout x)
  (output-produce))
