
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : tmpre.scm
;; DESCRIPTION : preprocessing of TeXmacs tree before conversions
;; COPYRIGHT   : (C) 2002  Joris van der Hoeven
;;
;; This software falls under the GNU general public license and comes WITHOUT
;; ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for details.
;; If you don't have this file, write to the Free Software Foundation, Inc.,
;; 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Data
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define tmpre-initialized #f)
(define tmpre-inline-env (make-hash-table 100))
(define tmpre-sectional (make-hash-table 100))
(define tmpre-theorem-env (make-hash-table 100))

(define tmpre-inline-env-def
  '(verbatim code center indent description itemize itemize-minus
    itemize-dot itemize-arrow enumerate enumerate-numeric
    enumerate-roman enumerate-Roman enumerate-alpha enumerate-Alpha
    equation equation* eqnarray* leqnarray*))

(define tmpre-sectional-def
  '(chapter appendix section subsection subsubsection paragraph subparagraph))

(define tmpre-theorem-env-def
  '(theorem proposition lemma corollary axiom definition conjecture
    remark note example exercise warning convention))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Initialization
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (tmpre-initialize)
  (if (not tmpre-initialized)
      (begin
	(set! tmpre-initialized #t)
	(fill-set tmpre-inline-env tmpre-inline-env-def)
	(fill-set tmpre-sectional tmpre-sectional-def)
	(fill-set tmpre-theorem-env tmpre-theorem-env-def))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Preprocessing
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (tmpre-non-isolated? l)
  (not (and (list? l)
	    (= (length l) 2)
	    (not (func? l 'paragraph))
	    (hash-ref tmpre-sectional (car l)))))

(define (tmpre-glueable? l)
  (or (func? l 'assign 2)
      (and (list? l)
	   (= (length l) 2)
	   (hash-ref tmpre-inline-env (car l)))))

(define (tmpre-paragraph x l)
  (cond ((func? (car l) 'paragraph)
	 (cons (cons* 'paragraph x (cdar l)) (cdr l)))
	(else (cons (list 'paragraph x (car l)) (cdr l)))))

(define (tmpre-document l)
  (if (null? l) l
      (let ((h (tmpre (car l)))
	    (r (tmpre-document (cdr l))))
	(cond ((null? (cdr l)) (list h))
	      ((and (tmpre-non-isolated? (car l)) (tmpre-glueable? (cadr l)))
	       (tmpre-paragraph h r))
	      ((and (tmpre-glueable? (car l)) (tmpre-non-isolated? (cadr l)))
	       (tmpre-paragraph h r))
	      (else (cons h r))))))

(define (tmpre-empty? x)
  (cond ((equal? x "") #t)
	((not (list? x)) #f)
	((func? x 'label 1) #t)
	((func? x 'concat) (eval (cons and (map-unary tmpre-empty? (cdr x)))))
	(else #f)))

(define (tmpre-var-document l)
  (if (and (tmpre-empty? (car l)) (tmpre-glueable? (cadr l)))
      (cons (list 'concat (tmpre (car l)) (list 'tmdummy))
	    (tmpre-document (cdr l)))
      (tmpre-document l)))

(define (tmpre l)
  (cond ((not (list? l)) l)
	((and (= (length l) 2)
	      (hash-ref tmpre-theorem-env (car l))
	      (func? (cadr l) 'document)
	      (>= (length (cadr l)) 3))
	 (list (car l) (cons 'document (tmpre-var-document (cdadr l)))))
	((and (func? l 'document 1)
	      (or (func? (cadr l) 'tformat) (func? (cadr l) 'table)))
	 (tmpre (cadr l)))
	((func? l 'document) (cons 'document (tmpre-document (cdr l))))
	(else (cons (car l) (map-unary tmpre (cdr l))))))

(define (tmpre-produce l)
  (tmpre-initialize)
  (tmpre l))
