
/******************************************************************************
* MODULE     : gg_alloc.gen.h
* DESCRIPTION: see gg_malloc.cc
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#ifndef _GG_MALLOC
#define _GG_MALLOC
#include <iostream.h>
#include <stdlib.h>

#define bool int
#define FALSE 0
#define TRUE 1
typedef int SI;
typedef void* pointer;

#if defined (__alpha) ||                   \
    defined (__mips64__) ||                \
    defined (__ia64__) ||                  \
    defined (__sparc) || defined (sparc)
#define WORD_LENGTH 8
#define WORD_LENGTH_INC 7
#define WORD_MASK 0xfffffffc
#define MAX_FAST 264     // WORD_LENGTH more than power of 2
#define BLOCK_SIZE 65536 // should be >>> MAX_FAST
#else
#define WORD_LENGTH 4
#define WORD_LENGTH_INC 3
#define WORD_MASK 0xfffffffc
#define MAX_FAST 260     // WORD_LENGTH more than power of 2
#define BLOCK_SIZE 65536 // should be >>> MAX_FAST
#endif

extern char*  alloc_table[MAX_FAST];
extern char*  alloc_mem;
extern size_t alloc_remains;
extern int    allocated;

#define alloc_ptr(i) (*((void **) (alloc_table+i)))
#define ind(ptr) (*((void **) ptr))

/*****************************************************************************/
// General purpose fast allocation routines
/*****************************************************************************/

extern void* enlarge_malloc (register size_t s);
extern void* fast_alloc (register size_t s);
extern void  fast_free (register void* ptr, register size_t s);
extern int   mem_used ();
extern void  mem_info ();
extern int   DEBUG;
extern int   info;

/*****************************************************************************/
// Fast allocation of blocks whose sizes are multiples of WORD_LENGTH
/*****************************************************************************/

inline void*
fast_alloc_mw (register size_t s)
{
  if (s<MAX_FAST) {
    register void *ptr= alloc_ptr(s);
    if (ptr==NULL) return enlarge_malloc (s);
    alloc_ptr(s)= ind(ptr);
    return ptr;
  }
  else return malloc (s);
}

inline void
fast_free_mw (register void* ptr, register size_t s)
{
  if (s<MAX_FAST) {
    ind(ptr)    = alloc_ptr(s);
    alloc_ptr(s)= ptr;
  }
  else free (ptr);
}

#endif
