
/******************************************************************************
* MODULE     : analyze.gen.h
* DESCRIPTION: Properties of characters and strings
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <string.gen.h>

#module analyze
#import string

bool is_alpha (char c);
bool is_iso_alpha (char c);
bool is_locase (char c);
bool is_upcase (char c);
bool is_digit (char c);
bool is_numeric (char c);
bool is_ponctuation (char c);
bool is_alpha (string s);
bool is_iso_alpha (string s);
bool is_numeric (string s);

string upcase_first (string s);
string locase_first (string s);
string upcase_all (string s);
string locase_all (string s);
string iso_to_koi8 (string s);
string koi8_to_iso (string s);
string il2_to_cork (string s);
string cork_to_il2 (string s);
string ispanish_to_spanish (string s);
string spanish_to_ispanish (string s);

string roman_nr (int nr);
string Roman_nr (int nr);
string alpha_nr (int nr);
string Alpha_nr (int nr);

string tm_encode (string s);
string tm_decode (string s);
string tm_correct (string s);

bool test (string s, int i, const char* test);
bool test (string s, int i, string test);
bool starts (string s, const char* test);
bool starts (string s, string test);
bool ends (string s, const char* test);
bool ends (string s, string test);
bool read (string s, int& i, const char* test);
bool read (string s, int& i, string test);
bool read_line (string s, int& i, string& result);
bool read_int (string s, int& i, int& result);
bool read_double (string s, int& i, double& result);
void skip_spaces (string s, int& i);
void skip_line (string s, int& i);
int  search_forwards (string s, string in);
int  search_forwards (string s, int pos, string in);
int  search_backwards (string s, string in);
int  search_backwards (string s, int pos, string in);

#endmodule // analyze
