
/******************************************************************************
* MODULE     : hashset.gen.cc
* DESCRIPTION: fixed size hashsets with reference counting
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <hashset.gen.h>

#module code_hashset (T)
#import hashset (T)

void
hashset_rep<T>::resize (int n2) {
  int i;
  int oldn= n;
  list<T>* olda= a;
  n= n2;
  a= new list<T>[n];
  for (i=0; i<oldn; i++) {
    list<T> l(olda[i]);
    while (!nil(l)) {
      list<T>& newl(a[hash(l->item)&(n-1)]);
      newl= list<T> (l->item, newl);
      l=l->next;
    }
  }
  delete[] olda;
}

static T*
search (list<T> l, T x) {
  while (!nil (l)) {
    if (l->item==x) return &(l->item);
    l= l->next;
  }
  return NULL;
}

bool
hashset_rep<T>::contains (T x) {
  return (search (a[hash(x)&(n-1)], x)==NULL? FALSE: TRUE);
}

void
hashset_rep<T>::insert (T x) {
  if (size==n*max) resize (n << 1);
  list<T>& l(a[hash(x)&(n-1)]);
  if (search (l, x) != NULL) return;
  l= list<T> (x, l);
  size ++;
}

void
hashset_rep<T>::remove (T x) {
  list<T>* lptr= &a[hash(x)&(n-1)];
  while (!nil (*lptr)) {
    if ((*lptr)->item==x) {
      *lptr=(*lptr)->next;
      size --;
      return;
    }
    lptr=&((*lptr)->next);
  }
}

bool
operator <= (hashset<T> h1, hashset<T> h2) {
  int i=0, j=0, n=h1->n;
  if (N(h1)>N(h2)) return FALSE;
  for (; i<n; i++) {
    list<T> l=h1->a[i];
    for (; !nil (l); l=l->next, j++)
      if (!h2->contains (l->item)) return FALSE;
  }
  return TRUE;
}

bool
operator < (hashset<T> h1, hashset<T> h2) {
  return (N(h1)<N(h2)) && (h1<=h2);
}

bool
operator == (hashset<T> h1, hashset<T> h2) {
  return (N(h1)==N(h2)) && (h1<=h2);
}

ostream&
operator << (ostream& out, hashset<T> h) {
  int i=0, j=0, n=h->n, size=h->size;
  out << "{ ";
  for (; i<n; i++) {
    list<T> l=h->a[i];
    for (; !nil (l); l=l->next, j++) {
      out << l->item;
      if (j!=size-1) out << ", ";
    }
  }
  out << " }";
  return out;
}

hashset<T>::operator tree () {
  int i=0, j=0, n=rep->n, size=rep->size;
  tree t (COLLECTION, size+1);
  for (; i<n; i++) {
    list<T> l=rep->a[i];
    for (; !nil (l); l=l->next, j++)
#ifdef no_tree_converter<T>
      t[j+1]= "?";
#else
      t[j+1]= (tree) l->item;
#endif
  }
  return t;
}

#endmodule // code_hashset (T)
