
/******************************************************************************
* MODULE     : convert.gen.h
* DESCRIPTION: various conversion routines
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <tree.gen.h>
#include <analyze.gen.h>
#include <vars.gen.h>

#module convert
#import tree
#import analyze
#import vars

string  tree_to_verbatim (tree t);
string  tree_to_tex (tree t, string mode);
string  tree_to_tex_document (tree t, tree style, string lan);
string  tree_to_latex (tree t, string mode);
string  tree_to_latex_document (tree t, tree style, string lan);
string  tree_to_html (tree t, string mode);
string  tree_to_html_document (tree t);

tree    verbatim_to_tree (string s);
tree    tex_to_tree (string s, string mode);
tree    tex_document_to_tree (string s, string& style);
tree    latex_to_tree (string s, string mode);
tree    latex_document_to_tree (string s, string& style);
tree    html_to_tree (string s, string mode);
tree    html_document_to_tree (string s, string& style);

string  var_tree_to_string (tree t);

tree    dl_compile_lisp (tree t);
tree    dl_eval_lisp (tree t);

#endmodule // convert
