
/******************************************************************************
* MODULE     : tm_scheme.gen.h
* DESCRIPTION: TeXmacs-lisp motor
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <server.gen.h>

#module tm_scheme
#import server

class tm_scheme_rep: virtual public server_rep {
protected:
  array<scheme_tree> cmds;     // commands which are still to be executed
  window dialogue_win;         // dialogue window
  widget dialogue_wid;         // dialogue widget

public:
  tm_scheme_rep ();
  ~tm_scheme_rep ();

  bool exec (string s);
  bool exec (scheme_tree p);
  bool exec_file (string dir, string name);
  void exec_delayed (scheme_tree p);
  void exec_pending_commands ();
  bool eval_any (scheme_tree p, string& ret);
  bool eval_bool (scheme_tree p, bool& ret);
  bool eval_scheme_tree (scheme_tree p, scheme_tree& ret);

  void dialogue_start (string name, widget wid, scheme_tree prg);
  void dialogue_inquire (scheme_tree& arg);
  void dialogue_end ();
  void choose_file (string title, string type, scheme_tree prg);
};

#endmodule // tm_scheme
