
/******************************************************************************
* MODULE     : event_codes.gen.h
* DESCRIPTION: Unique codes for each event and
*              modules for creating the corresponding events.
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#module event_codes

/*** basic events ***/
#define GET_SIZE_EVENT        0x00000000
#define GET_WIDGET_EVENT      0x00000001
#define SET_WIDGET_EVENT      0x00000002
#define SET_LANGUAGE_EVENT    0x00000003
#define ATTACH_WINDOW_EVENT   0x00000004
#define POSITION_EVENT        0x00000005
#define MOVE_EVENT            0x00000006
#define RESIZE_EVENT          0x00000007
#define DESTROY_EVENT         0x00000008
#define KEYPRESS_EVENT        0x00000009
#define KEYBOARD_FOCUS_EVENT  0x0000000a
#define MOUSE_EVENT           0x0000000b
#define ALARM_EVENT           0x0000000c
#define CLEAR_EVENT           0x0000000d
#define REPAINT_EVENT         0x0000000e
#define UPDATE_EVENT          0x0000000f
#define INVALIDATE_EVENT      0x00000010
#define KEYBOARD_GRAB_EVENT   0x00000011
#define MOUSE_GRAB_EVENT      0x00000012
#define REQUEST_ALARM_EVENT   0x00000013
#define FIND_CHILD_EVENT      0x00000014

/*** composite events ***/
#define CLEAN_EVENT           0x00000015
#define INSERT_EVENT          0x00000016
#define REMOVE_EVENT          0x00000017

/*** attribute events ***/
#define GET_INTEGER_EVENT     0x00000018
#define GET_DOUBLE_EVENT      0x00000019
#define GET_STRING_EVENT      0x0000001a
#define GET_COORD1_EVENT      0x0000001b
#define GET_COORD2_EVENT      0x0000001c
#define GET_COORD3_EVENT      0x0000001d
#define GET_COORD4_EVENT      0x0000001e
#define SET_INTEGER_EVENT     0x0000001f
#define SET_DOUBLE_EVENT      0x00000020
#define SET_STRING_EVENT      0x00000021
#define SET_COORD1_EVENT      0x00000022
#define SET_COORD2_EVENT      0x00000023
#define SET_COORD3_EVENT      0x00000024
#define SET_COORD4_EVENT      0x00000025

/*** scroll events ***/
#define SCROLL_EVENT          0x00000026

#endmodule // event_codes

#module event (T, R)
struct T {
  R* rep;
  T (T& ev);
  ~T ();
  T (event& ev);
  operator event ();
  R* operator -> ();
  T& operator = (T ev);
};
#endmodule // event (T, R)

#module code_event (T, R)
T::T (T& ev): rep (ev.rep) { rep->ref_count++; }
T::~T () { if ((--rep->ref_count)==0) delete rep; }
T::T (event& ev): rep ((R*) ev.rep) { rep->ref_count++; }
T::operator event () { return event (rep); }
R* T::operator -> () { return rep; }
T& T::operator = (T ev) {
  ev.rep->ref_count++;
  if ((--rep->ref_count)==0) delete rep;
  rep=ev.rep;
  return *this;
}
#endmodule // code_event (T, R)
