/*
 *  Copyright (C) 2000 by Marco G"otze.
 *
 *  This code is part of the ThoughtTracker source package, which is
 *  distributed under the terms of the GNU GPL2.
 */

#ifndef UTIL_H_INCLUDED
#define UTIL_H_INCLUDED

#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <string>

#include <gtk--/pixmap.h>
#include <gtk--/window.h>

#include "thoughttracker.h"
#include "util.h"

/* malloc()s <amount> bytes, or dies in the attempt */
void *smalloc(long amount);

/* free()s <ptr> if != NULL, and sets it to NULL */
void sfree(void *ptr);

/* quotes a string in a fashion suitable for ThoughtTracker config files, i.e.
   surrounding it with double quotes and escaping all contained ones; if
   strict is false, only do this if necessary, i.e. if <s> contains white
   space */
void cfg_quote(string &s, bool strict = false);

/* undoes cfg_quote's effect */
void cfg_unquote(string &s);

#endif /* UTIL_H_INCLUDED */

