/*
  mffm Time Code
  Time Code for multimedia systems

  Copyright (C) 2000, 2001 Matt R. Flax <flatmax@ieee.org>
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You have received a copy of the GNU Lesser General Public License
  along with this library.
*/
#include "masterCounterInterface.H"
#include "XPMDigits.H"

#define FIELDCOUNT 3

static void quit(GtkWidget *wid, gpointer data){
  gtk_main_quit();
}

void main(void){
  int argc=0;
  gtk_init( &argc, NULL );

  GtkInterface topWindow;
  XPMDigits temp(&topWindow);
  
  MasterCounterInterface<FieldInterface, FIELDCOUNT> *masterCnt=new MasterCounterInterface<FieldInterface, FIELDCOUNT>(0, 24, 60, 60);
  masterCnt->setMinCount(2*60);
  // Quit button
  Buttons buttons; buttons<<BUTTONLABELSTRUCT{"Quit", quit, NULL};

  HBox hBox;
  hBox<< buttons.grab(1);
  hBox<< masterCnt->getWidget();
  hBox.show();
  topWindow<< hBox.getWidget();

  //gtk_timeout_add(100 /* 100 ms */, updateCheck, &masterCnt);
  gtk_main();

  delete masterCnt;
  
  return 0;  
}
