#include "ThumbHSL.hpp"

#include "wx/wx.h"
#include "wx/gbsizer.h"

#define ICON_SIZE 100
#define THUMB_SIZE 80

using namespace indii::tint;
using namespace indii::tint::gui;

ThumbHSL::ThumbHSL(wxWindow *parent,
    ImageResource* res, ClusterModel* model, const unsigned int cluster) :
    wxPanel(parent), res(res), model(model), cluster(cluster) {
  watch(model);
  #ifdef __WXMAC__
  static const int PADDING = 2;
  #else
  static const int PADDING = 4;
  #endif

  wxGridBagSizer* sizer = new wxGridBagSizer();
  sizer->SetFlexibleDirection(wxHORIZONTAL);
  sizer->AddGrowableCol(1);

  slideH = new wxSlider(this, ID_SLIDE_H, 0, 0, 255);
  slideS = new wxSlider(this, ID_SLIDE_S, 0, 0, 255);
  slideL = new wxSlider(this, ID_SLIDE_L, 0, 0, 255);

  wxStaticText *labelH, *labelS, *labelL;
  labelH = new wxStaticText(this, -1, _("H"));
  labelS = new wxStaticText(this, -1, _("S"));
  labelL = new wxStaticText(this, -1, _("L"));

  sizer->Add(labelH, wxGBPosition(0,0), wxDefaultSpan,
      wxALIGN_CENTRE_VERTICAL|wxALL, PADDING);
  sizer->Add(labelS, wxGBPosition(1,0), wxDefaultSpan,
      wxALIGN_CENTRE_VERTICAL|wxALL, PADDING);
  sizer->Add(labelL, wxGBPosition(2,0), wxDefaultSpan,
      wxALIGN_CENTRE_VERTICAL|wxALL, PADDING);

  sizer->Add(slideH, wxGBPosition(0,1), wxDefaultSpan,
      wxALIGN_CENTRE_VERTICAL|wxALL|wxEXPAND, PADDING);
  sizer->Add(slideS, wxGBPosition(1,1), wxDefaultSpan,
      wxALIGN_CENTRE_VERTICAL|wxALL|wxEXPAND, PADDING);
  sizer->Add(slideL, wxGBPosition(2,1), wxDefaultSpan,
      wxALIGN_CENTRE_VERTICAL|wxALL|wxEXPAND, PADDING);

  SetSizerAndFit(sizer);
  unsigned naturalHeight = this->GetSize().GetHeight();
  SetMinSize(wxSize(200, naturalHeight));
  SetBestSize(wxSize(200, naturalHeight));
}

ThumbHSL::~ThumbHSL() {
  //
}

void ThumbHSL::notifyNumClustersChange() {
  if (cluster < model->getNumClusters()) {
    Refresh();
  }
}

void ThumbHSL::notifySaturationDecayChange() {
  if (cluster < model->getNumClusters()) {
    Refresh();
  }
}

void ThumbHSL::notifyCentroidDecayChange() {
  if (cluster < model->getNumClusters()) {
    Refresh();
  }
}

void ThumbHSL::notifySaturationSoftnessChange() {
  if (cluster < model->getNumClusters()) {
    Refresh();
  }
}

void ThumbHSL::notifyCentroidSoftnessChange() {
  if (cluster < model->getNumClusters()) {
    Refresh();
  }
}

void ThumbHSL::notifyClusterChange(const unsigned int i) {
  //
}

void ThumbHSL::OnSlideH(wxScrollEvent& evt) {
  model->setHue(cluster, slideH->GetValue()*6.0f/255.0f);
}

void ThumbHSL::OnSlideS(wxScrollEvent& evt) {
  model->setSat(cluster, slideS->GetValue()/255.0f);
}

void ThumbHSL::OnSlideL(wxScrollEvent& evt) {
  model->setLight(cluster, slideL->GetValue()/255.0f);
}

BEGIN_EVENT_TABLE(ThumbHSL, wxPanel)

EVT_COMMAND_SCROLL_THUMBRELEASE(ID_SLIDE_H, ThumbHSL::OnSlideH)
EVT_COMMAND_SCROLL_THUMBRELEASE(ID_SLIDE_S, ThumbHSL::OnSlideS)
EVT_COMMAND_SCROLL_THUMBRELEASE(ID_SLIDE_L, ThumbHSL::OnSlideL)

EVT_COMMAND_SCROLL_TOP(ID_SLIDE_H, ThumbHSL::OnSlideH)
EVT_COMMAND_SCROLL_TOP(ID_SLIDE_S, ThumbHSL::OnSlideS)
EVT_COMMAND_SCROLL_TOP(ID_SLIDE_L, ThumbHSL::OnSlideL)

EVT_COMMAND_SCROLL_BOTTOM(ID_SLIDE_H, ThumbHSL::OnSlideH)
EVT_COMMAND_SCROLL_BOTTOM(ID_SLIDE_S, ThumbHSL::OnSlideS)
EVT_COMMAND_SCROLL_BOTTOM(ID_SLIDE_L, ThumbHSL::OnSlideL)

EVT_COMMAND_SCROLL_PAGEUP(ID_SLIDE_H, ThumbHSL::OnSlideH)
EVT_COMMAND_SCROLL_PAGEUP(ID_SLIDE_S, ThumbHSL::OnSlideS)
EVT_COMMAND_SCROLL_PAGEUP(ID_SLIDE_L, ThumbHSL::OnSlideL)

EVT_COMMAND_SCROLL_PAGEDOWN(ID_SLIDE_H, ThumbHSL::OnSlideH)
EVT_COMMAND_SCROLL_PAGEDOWN(ID_SLIDE_S, ThumbHSL::OnSlideS)
EVT_COMMAND_SCROLL_PAGEDOWN(ID_SLIDE_L, ThumbHSL::OnSlideL)

EVT_COMMAND_SCROLL_LINEUP(ID_SLIDE_H, ThumbHSL::OnSlideH)
EVT_COMMAND_SCROLL_LINEUP(ID_SLIDE_S, ThumbHSL::OnSlideS)
EVT_COMMAND_SCROLL_LINEUP(ID_SLIDE_L, ThumbHSL::OnSlideL)

EVT_COMMAND_SCROLL_LINEDOWN(ID_SLIDE_H, ThumbHSL::OnSlideH)
EVT_COMMAND_SCROLL_LINEDOWN(ID_SLIDE_S, ThumbHSL::OnSlideS)
EVT_COMMAND_SCROLL_LINEDOWN(ID_SLIDE_L, ThumbHSL::OnSlideL)

EVT_COMMAND_SCROLL_THUMBTRACK(ID_SLIDE_H, ThumbHSL::OnSlideH)
EVT_COMMAND_SCROLL_THUMBTRACK(ID_SLIDE_S, ThumbHSL::OnSlideS)
EVT_COMMAND_SCROLL_THUMBTRACK(ID_SLIDE_L, ThumbHSL::OnSlideL)

END_EVENT_TABLE()

