#ifndef INDII_TINT_GUI_THUMBHSL_HPP
#define INDII_TINT_GUI_THUMBHSL_HPP

#include "../ImageResource.hpp"
#include "../ClusterModel.hpp"
#include "../ClusterModelObserver.hpp"

#include "wx/panel.h"
#include "wx/slider.h"

namespace indii {
  namespace tint {
    namespace gui {
/**
 * Thumbnail with Hue-Saturation-Luminance sliders.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * @version $Rev: 92 $
 * @date $Date: 2009-08-02 17:56:45 +0800 (Sun, 02 Aug 2009) $
 */
class ThumbHSL : public wxPanel, public ClusterModelObserver {
public:
  /**
   * Constructor.
   *
   * @param parent Parent window.
   * @param res Image resource manager. Caller retains ownership.
   * @param model Cluster model. Caller retains ownership.
   * @param cluster Cluster number to which this thumbnail pertains.
   */
  ThumbHSL(wxWindow *parent, ImageResource* res, ClusterModel* model,
      const unsigned int cluster);

  /**
   * Destructor.
   */
  ~ThumbHSL();

  /*
   * Handle model changes.
   */
  virtual void notifyNumClustersChange();
  virtual void notifySaturationDecayChange();
  virtual void notifyCentroidDecayChange();
  virtual void notifySaturationSoftnessChange();
  virtual void notifyCentroidSoftnessChange();
  virtual void notifyClusterChange(const unsigned int i);  

  /*
   * Slider control events.
   */
  void OnSlideH(wxScrollEvent& evt);
  void OnSlideS(wxScrollEvent& evt);
  void OnSlideL(wxScrollEvent& evt);

private:
  /**
   * Image resource manager.
   */
  ImageResource* res;

  /**
   * Cluster model.
   */
  ClusterModel* model;

  /**
   * Cluster number.
   */
  unsigned int cluster;

  /*
   * Sliders.
   */
  wxSlider *slideH, *slideS, *slideL;

  /*
   * Slider control ids.
   */
  enum ID {
    ID_SLIDE_H,
    ID_SLIDE_S,
    ID_SLIDE_L
  };

  DECLARE_EVENT_TABLE()

};

    }
  }
}

#endif

