#ifndef INDII_TINT_GUI_TINTSPLASH_HPP
#define INDII_TINT_GUI_TINTSPLASH_HPP

#include "../ImageResource.hpp"
#include "../ClusterModel.hpp"

#include "wx/frame.h"

namespace indii {
  namespace tint {
    namespace gui {
      class TintApp;      
/**
 * Splash window.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * @version $Rev: 107 $
 * @date $Date: 2009-09-12 15:46:17 +0800 (Sat, 12 Sep 2009) $
 */
class TintSplash : public wxFrame {
public:
  /**
   * Constructor.
   *
   * @param parent Parent.
   * @param 
   */
  TintSplash(wxWindow* parent = NULL, TintApp* app = NULL);

  /**
   * Destructor.
   */
  ~TintSplash();

  /**
   * Close event.
   */
  void OnSystemClose(wxCloseEvent& evt);

  /**
   * Close button event.
   */
  void OnButtonClose(wxCommandEvent& evt);
    
private:
  /*
   * Control ids.
   */
  enum ID {
    ID_BUT_REGISTER,
    ID_BUT_SPLASH
  };
  
  /**
   * Enclosing application.
   */
  TintApp* app;

  DECLARE_EVENT_TABLE()

};

    }
  }
}

#endif
