/**
 * Copyright (C) 2007-2012 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 363 $
 * $Date: 2012-01-22 18:45:43 +0800 (Sun, 22 Jan 2012) $
 */
#ifndef INDII_MODEL_OBSERVABLE_HPP
#define INDII_MODEL_OBSERVABLE_HPP

#include <set>

namespace indii {
  class Observer;

/**
 * Abstract observable object.
 */
class Observable {
public:
  /**
   * Destructor.
   */
  virtual ~Observable();

  /**
   * Registry type.
   */
  typedef std::set<Observer*> registry_t;

  /**
   * Register observer.
   */
  void subscribe(Observer* o);

  /**
   * Deregister observer.
   */
  void unsubscribe(Observer* o);

  /**
   * Notify all registered observers of change.
   */
  void notifyAll();

  /**
   * Notify change of greyscale parameters.
   */
  void notifyGreyscaleChange();

  /**
   * Notify all registered observers of destruction.
   */
  void notifyDestroy();
   
protected:
  /**
   * Registry of observers.
   */
  registry_t os;
};
}

#endif

