##############################################################################
#
# Copyright (c) 2004-2006 TINY SPRL. (http://tiny.be) All Rights Reserved.
#					Fabien Pinckaers <fp@tiny.Be>
#
# $Id: main.py 4044 2006-09-05 14:06:27Z ged $
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import time
import os
import gettext
import urlparse

import gobject
import gtk
from gtk import glade

import rpc

import service
import options
import common

from window import win_preference
import tools

def _login_ask():
	uid = 0
	win_gl = glade.XML(common.terp_path("terp.glade"),"win_login",gettext.textdomain())
	win = win_gl.get_widget('win_login')
	login = win_gl.get_widget('ent_login')
	passwd = win_gl.get_widget('ent_passwd')
	host = win_gl.get_widget('ent_host')
	port = win_gl.get_widget('ent_port')
	secure = win_gl.get_widget('ent_secure')

	port.set_text(options.options['login.port'])
	host.set_text(options.options['login.server'])
	login.set_text(options.options['login.login'])
	secure.set_active(options.options['login.secure'])
	
	# deselect the text in the host/server field since
	# the focus is on the password field
	host.select_region(0, 0)

	res = win.run()
	if res == gtk.RESPONSE_CANCEL:
		win.destroy()
		raise 'QueryCanceled'
	result = (login.get_text(), passwd.get_text(), host.get_text(), port.get_text(), secure.get_active())
	win.destroy()
	return result
	
class terp_main(service.Service):
	def __init__(self, name='gui.main', audience='gui.*'):
		service.Service.__init__(self, name, audience)
		self.exportMethod(self.win_add)

		self.glade = glade.XML(common.terp_path("terp.glade"),"win_main",gettext.textdomain())
		self.status_bar_main = self.glade.get_widget('hbox_status_main')
		self.toolbar = self.glade.get_widget('main_toolbar')
		self.sb_requests = self.glade.get_widget('sb_requests')
		self.sb_username = self.glade.get_widget('sb_user_name')
		self.sb_servername = self.glade.get_widget('sb_user_server')
		id = self.sb_servername.get_context_id('message')
		self.sb_servername.push(id, _('Press Ctrl+O to login'))
		self.secure_img = self.glade.get_widget('secure_img')
		self.secure_img.hide()

		window = self.glade.get_widget('win_main')
		window.connect("destroy", self.sig_quit)
		window.connect("delete_event", self.sig_delete)
		self.window = window
		self.window.set_icon(gtk.gdk.pixbuf_new_from_file(common.terp_path_pixmaps('tinyerp_icon.png')))

		self.notebook = gtk.Notebook()
		self.notebook.popup_enable()
		self.sig_id = self.notebook.connect_after('switch-page', self._sig_page_changt)
		vbox = self.glade.get_widget('vbox_main')
		vbox.pack_start(self.notebook, expand=True, fill=True)

		#
		# Code to add themes to the options->theme menu
		#
		submenu = gtk.Menu()
		menu = self.glade.get_widget('menu_theme')
		old = None
		for dname in os.listdir(common.terp_path('themes')):
			if dname.startswith('.'):
				continue
			fname = common.terp_path(os.path.join('themes', dname, 'gtkrc'))
			if os.path.isfile(fname):
				open_item = gtk.RadioMenuItem(old, dname)
				old = open_item
				submenu.append(open_item)
				if dname == options.options['client.theme']:
					open_item.set_active(True)
				open_item.connect('toggled', self.theme_select, dname)

		submenu.append(gtk.SeparatorMenuItem())
		open_item = gtk.RadioMenuItem(old, _('Default Theme'))
		submenu.append(open_item)
		if 'none'==options.options['client.theme']:
			open_item.set_active(True)
		open_item.connect('toggled', self.theme_select, 'none')
		submenu.show_all()
		menu.set_submenu(submenu)

		#
		# Default Notebook
		#

		self.notebook.show()
		self.pages = []
		self.current_page = 0
		self.last_page = 0

		dict = {
			'on_login_activate': self.sig_login,
			'on_logout_activate': self.sig_logout,
			'on_win_next_activate': self.sig_win_next,
			'on_win_prev_activate': self.sig_win_prev,
			'on_plugin_execute_activate': self.sig_plugin_execute,
			'on_quit_activate': self.sig_close,
			'on_win_new_activate': self.sig_win_new,
			'on_win_close_activate': self.sig_win_close,
			'on_support_activate': common.support,
			'on_preference_activate': self.sig_user_preferences,
			'on_read_requests_activate': self.sig_request_open,
			'on_send_request_activate': self.sig_request_new,
			'on_request_wait_activate': self.sig_request_wait,
			'on_opt_save_activate': lambda x: options.options.save(),
			'on_menubar_icons_activate': lambda x: self.sig_menubar('icons'),
			'on_menubar_text_activate': lambda x: self.sig_menubar('text'),
			'on_menubar_both_activate': lambda x: self.sig_menubar('both'),
			'on_mode_normal_activate': lambda x: self.sig_mode_change(False),
			'on_mode_pda_activate': lambda x: self.sig_mode_change(True),
			'on_help_index_activate': self.sig_help_index,
			'on_help_contextual_activate': self.sig_help_context,
			'on_help_tips_activate': self.sig_tips,
			'on_help_licence_activate': self.sig_licence,
			'on_about_activate': self.sig_about,
			'on_shortcuts_activate' : self.sig_shortcuts,
		}
		for signal in dict:
			self.glade.signal_connect(signal, dict[signal])

		self.buttons = {}
		for button in ('but_new', 'but_save', 'but_remove', 'but_search', 'but_previous', 'but_next', 'but_action', 'but_open', 'but_print', 'but_close', 'but_reload', 'but_switch','but_attach'):
			self.glade.signal_connect('on_'+button+'_clicked', self._sig_child_call, button)
			self.buttons[button]=self.glade.get_widget(button)

		menus = {
			'form_del': 'but_remove',
			'form_new': 'but_new',
			'form_copy': 'but_copy',
			'form_reload': 'but_reload',
			'form_log': 'but_log',
			'form_open': 'but_open',
			'form_search': 'but_search',
			'form_previous': 'but_previous',
			'form_next': 'but_next',
			'form_save': 'but_save',
			'goto_id': 'but_goto_id',
			'form_print': 'but_print',
			'form_print_html': 'but_print_html',
			'form_save_as': 'but_save_as',
			'form_import': 'but_import',
			'form_filter': 'but_filter',
			'form_repeat': 'but_print_repeat'
		}
		for menu in menus:
			self.glade.signal_connect('on_'+menu+'_activate', self._sig_child_call, menus[menu])

		spool = service.LocalService('spool')
		spool.subscribe('gui.window', self.win_add)

		self.sb_set()

		def fnc_menuitem(menuitem, opt_name):
			options.options[opt_name] = menuitem.get_active()
		dict = {
			'on_opt_print_preview_activate': (fnc_menuitem, 'printer.preview', 'opt_print_preview'),
		}
		self.sig_menubar(options.options['client.toolbar'] or 'both')
		self.sig_mode()
		for signal in dict:
			self.glade.signal_connect(signal, dict[signal][0], dict[signal][1])
			self.glade.get_widget(dict[signal][2]).set_active(int(bool(options.options[dict[signal][1]])))

		# Adding a timer the check to requests
		gobject.timeout_add(5 * 60 * 1000, self.request_set)

	def theme_select(self, widget, theme):
		options.options['client.theme'] = theme
		common.theme_set()
		self.window.show_all()
		return True

	def sig_mode_change(self, pda_mode=False):
		options.options['client.modepda'] = pda_mode
		return self.sig_mode()

	def sig_mode(self):
		pda_mode = options.options['client.modepda']
		#
		# Put here specific code for PDA (or not)
		#
		if pda_mode:
			self.status_bar_main.hide()
		else:
			self.status_bar_main.show()
		return pda_mode

	def sig_menubar(self, option):
		options.options['client.toolbar'] = option
		if option=='both':
			self.toolbar.set_style(gtk.TOOLBAR_BOTH)
		elif option=='text':
			self.toolbar.set_style(gtk.TOOLBAR_TEXT)
		elif option=='icons':
			self.toolbar.set_style(gtk.TOOLBAR_ICONS)

	def sig_win_next(self, args):
		pn = self.notebook.get_current_page()
		if pn == len(self.pages)-1:
			pn = -1
		self.notebook.set_current_page(pn+1)

	def sig_win_prev(self, args):
		pn = self.notebook.get_current_page()
		self.notebook.set_current_page(pn-1)

	def sig_user_preferences(self, *args):
		actions = rpc.session.rpc_exec_auth('/object', 'execute', 'ir.values', 'get', 'meta', False, [('res.users',False)], True, rpc.session.context, True)

		win = win_preference.win_preference('res.users', rpc.session.uid, actions)
		if win.run():
			rpc.session.context_reload()
		return True

	def sig_win_close(self, *args):
		self._sig_child_call(args[0], 'but_close')

	def sig_request_new(self, args=None):
		obj = service.LocalService('gui.window')
		obj.create(None, 'res.request', False, [('act_from','=',rpc.session.uid)], 'form', mode='form,tree')

	def sig_request_open(self, args=None):
		ids,ids2 = self.request_set()
		obj = service.LocalService('gui.window')
		obj.create(False, 'res.request', ids, [('act_to','=',rpc.session.uid)], 'form', mode='tree,form')

	def sig_request_wait(self, args=None):
		ids,ids2 = self.request_set()
		obj = service.LocalService('gui.window')
		obj.create(False, 'res.request', ids, [('act_from','=',rpc.session.uid), ('state','=','waiting')], 'form', mode='tree,form')

	def request_set(self):
		try:
			uid = rpc.session.uid
			ids,ids2 = rpc.session.rpc_exec_auth_wo('/object', 'execute', 'res.request', 'request_get')
			if len(ids):
				message = _('%s request(s)') % len(ids)
			else:
				message = _('No request')
			if len(ids2):
				message += _(' - %s pending request(s)') % len(ids2)
			id = self.sb_requests.get_context_id('message')
			self.sb_requests.push(id, message)
			return (ids,ids2)
		except:
			return ([],[])

	def sig_login(self, widget=None):
		if rpc.session.logged():
			pass
		else:
			try:
				try:
					res = _login_ask()
				except 'QueryCanceled':
					return False
				log_response = rpc.session.login(*res)
				if log_response==1:
					options.options['login.server'] = res[2]
					options.options['login.login'] = res[0]
					options.options['login.port'] = res[3]
					options.options['login.secure'] = res[4]
					options.options.save()
					self.sig_win_new()
					if res[4]:
						self.secure_img.show()
					self.request_set()
				elif log_response==-1:
					common.message(_('Connection error !\nUnable to connect to the server !'))
				elif log_response==-2:
					common.message(_('Connection error !\nBad username or password !'))
			except rpc.rpc_exception, e:
				(e1,e2) = e
				rpc.session.logout()
				common.error(_('Connection Error !'),e1,e2)
		return True

	def sig_logout(self, widget):
		while self._win_del():
			pass
		id = self.sb_requests.get_context_id('message')
		self.sb_requests.push(id, '')
		id = self.sb_username.get_context_id('message')
		self.sb_username.push(id, _('Not logged !'))
		id = self.sb_servername.get_context_id('message')
		self.sb_servername.push(id, _('Press Ctrl+O to login'))
		self.secure_img.hide()
		rpc.session.logout()
		
	def sig_help_index(self, widget):
		tools.launch_browser('http://tinyerp.org/docs/index.php/UserManual/HomePage.html')

	def sig_help_context(self, widget):
		model = self._wid_get().model
		tools.launch_browser('http://tinyerp.org/docs/context_index.php?model=%s' % model)

	def sig_tips(self, *args):
		common.tipoftheday()
		
	def sig_licence(self, widget):
		dialog = glade.XML(common.terp_path("terp.glade"), "win_licence", gettext.textdomain())
		dialog.signal_connect("on_but_ok_pressed", lambda obj: dialog.get_widget('win_licence').destroy())

	def sig_about(self, widget):
		about = glade.XML(common.terp_path("terp.glade"), "win_about", gettext.textdomain())
		buffer = about.get_widget('textview2').get_buffer()
		about_txt = buffer.get_text(buffer.get_start_iter(), buffer.get_end_iter())
		buffer.set_text(about_txt % tinyerp_version)
		about.signal_connect("on_but_ok_pressed", lambda obj: about.get_widget('win_about').destroy())

	def sig_shortcuts(self, widget):
		shortcuts_win = glade.XML(common.terp_path('terp.glade'), 'shortcuts_dia', gettext.textdomain())
		shortcuts_win.signal_connect("on_but_ok_pressed", lambda obj: shortcuts_win.get_widget('shortcuts_dia').destroy())

	def sig_win_new(self, widget=None):
		act_id = rpc.session.rpc_exec_auth('/object', 'execute', 'res.users', 'read', [rpc.session.uid], ['action_id','name'], rpc.session.context)
		id = self.sb_username.get_context_id('message')
		self.sb_username.push(id, act_id[0]['name'] or '')
		id = self.sb_servername.get_context_id('message')
		self.sb_servername.push(id, urlparse.urlsplit(rpc.session._url)[1])
		if not act_id[0]['action_id']:
			common.warning('You can not log into the system !\nAsk the administrator to verify\nyou have an action defined for your user.','Access Denied !')
			rpc.session.logout()
			return False
		act_id = act_id[0]['action_id'][0]
		obj = service.LocalService('action.main')
		win = obj.execute(act_id, {'window':self.window}, 'ir.actions.act_window')

	def sig_plugin_execute(self, widget):
		import plugins
		pn = self.notebook.get_current_page()
		datas = {'model': self.pages[pn].model, 'ids':self.pages[pn].ids_get(), 'id' : self.pages[pn].id_get()}
		plugins.execute(datas)

	def sig_req_read(self, widget):
		while self._win_del():
			pass
		rpc.session.logout()

	def sig_quit(self, widget):
		gtk.main_quit()

	def sig_close(self, widget):
		if common.sur(_("Do you really want to quit ?")):
			gtk.main_quit()

	def sig_delete(self, widget, event, data=None):
		return not common.sur(_("Do you really want to quit ?"))

	def win_add(self, win, datas):
		self.pages.append(win)
		self.notebook.append_page(win.widget, gtk.Label(win.name))
		self.notebook.set_current_page(-1)

	def message(self, message):
		id = self.status_bar.get_context_id('message')
		self.status_bar.push(id, message)

	def sb_set(self, view=None):
		if view==None:
			view = self._wid_get()
		for x in self.buttons:
			if self.buttons[x]:
				self.buttons[x].set_sensitive(view and (x in view.handlers))

	def _win_del(self):
		pn = self.notebook.get_current_page()
		if pn != -1:
			self.notebook.disconnect(self.sig_id)
			page = self.pages.pop(pn)
			self.notebook.remove_page(pn)
#			if self.last_page > self.current_page :
#				self.notebook.set_current_page(self.last_page-1)
#			else:
#				self.notebook.set_current_page(self.last_page)
			self.sig_id = self.notebook.connect_after('switch-page', self._sig_page_changt)
			self.sb_set()

			page.destroy()
			del page
		return self.notebook.get_current_page() != -1

	def _wid_get(self):
		pn = self.notebook.get_current_page()
		if pn == -1:
			return False
		return self.pages[pn]

	def _sig_child_call(self, widget, button_name, *args):
		wid = self._wid_get()
		if wid:
			res = True
			if button_name in wid.handlers:
				res = wid.handlers[button_name][1]()
			if button_name=='but_close' and res:
				self._win_del()

	def _sig_page_changt(self, widget=None, *args): 
		self.last_page = self.current_page
		self.current_page = self.notebook.get_current_page()
		self.sb_set()

