/***************************************************************************
                          inputcontrol.cpp  -  description                              
                             -------------------                                         
    begin                : Wed Dec 22 22:09:25 MET 1999 
                                           
    copyright            : (C) 1999 by Daniel Reith                         
    email                : DanR@gmx.de
	
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "inputcontrol.h"

#include <iostream>
#include <wx/config.h>

#include "main.h"


//**************************************************************************
//* Zuordnung der Events
//**************************************************************************

BEGIN_EVENT_TABLE(wxInputControl, wxTextCtrl)
  EVT_CHAR(wxInputControl::OnChar)
  EVT_MIDDLE_DCLICK(wxInputControl::OnMouse)
END_EVENT_TABLE()

//**************************************************************************
//* Konstruktor wxInputControl::wxInputControl(wxWindow *parent)
//**************************************************************************
wxInputControl::wxInputControl(wxWindow *parent) : wxTextCtrl(parent, 2, "", wxDefaultPosition, wxDefaultSize, wxNO_BORDER|wxTE_MULTILINE)
{
  
  // Farbe erzeugen
  cmap = gdk_colormap_get_system();
  colour.red = 0xffff;
  colour.green = 0;
  colour.blue = 0;
  if (!gdk_color_alloc(cmap, &colour)) {
    g_error("couldn't allocate colour");
  };
  cmap = gdk_colormap_get_system();
  colour.red = 0xffff;
  colour.green = 0;
  colour.blue = 0;
  if (!gdk_color_alloc(cmap, &colour)) {
    g_error("couldn't allocate colour");
  }
  
  // gtkctrl erzeugen
  gtkctrl =  GetConnectWidget();
  // neue Schrift laden

  //m_fontname = "-misc-fixed-medium-r-*-*-*-200-*-*-*-*-*-*";
  wxConfigBase *pConfig = wxConfigBase::Get();
  m_fontname = pConfig->Read("/Hauptfenster/Schrift","-misc-fixed-medium-r-normal-*-*-200-*-*-c-*-iso8859-1"); 
  m_font = gdk_font_load (m_fontname);
  //Schrift zuweisen
  gtk_text_insert (GTK_TEXT (gtkctrl), m_font , &gtkctrl->style->black, NULL,"h" , -1);
  gtk_text_backward_delete(GTK_TEXT(gtkctrl), 1);
  //Pointer auf Hauptfenster
  m_hauptfenster=(wxFrame*)GetParent()->GetParent();

}

//**************************************************************************
//* Destruktor wxInputControl::~wxInputControl()
//**************************************************************************
wxInputControl::~wxInputControl()
{
  // Destruktor
  wxConfigBase *pConfig = wxConfigBase::Get();
  pConfig->Write("/Hauptfenster/Schrift", m_fontname);
}


//**************************************************************************
//*
//**************************************************************************

void  wxInputControl::OnChar(wxKeyEvent *event)
{
  Hauptfenster *haupt = (Hauptfenster*)m_hauptfenster;
  // Falls keine Lektion geladen, wird auch nicht die Richtigkeit der Eingabe getestet, es ist keine Eingabe mglich
  if (haupt->GetLektion()==0) return;
  if (haupt->GetLektion()->GetGeladen() == false) return;

  // Die folgende if Bedingung ist ein Cheat, damit die ganze Lektion nicht vollstndig abgearbeitet werden mu.
  // Strg+e springt zum Ende der Lektion
  
  if ((event->ControlDown())&&(event->KeyCode()==101))
    {
      haupt->SetStatusText(_("Ende der Lektion"));
      haupt->GetLektion()->SetEnde();
      haupt->GetLektion()->LektionEnde();
      return;
    }
  
  switch (event->KeyCode()) 
    {      // Abfangen unerwnschter Tasten, wie z.B. die Pfeiltasten
    case WXK_BACK: case WXK_LEFT: case WXK_DOWN: case WXK_RIGHT: case  WXK_UP: case  WXK_END: case WXK_HOME:
    case WXK_CLEAR: case WXK_PRIOR: case WXK_NEXT:
      wxBell();
      break;
    default:
      if (haupt->GetLektion()->Eingabe(event->KeyCode())==true)
	{
	  m_hauptfenster->SetStatusText(_("Richtig"));
	  char c;
	  c  =char(event->KeyCode());
	  wxString s;
	  // sonst kann man kein Enter drcken
	  if (c==13) c=10;
	  s<<c;
	  // Durch diese if Anweisung werden Fehler markiert. Da der falsche Buchstabe aber nicht gezeichnet wird, 
	  // brauchen wir die Hilfsvariable bool m_falsch
	  if (m_falsch)
	    {
	      gtk_text_insert (GTK_TEXT (gtkctrl), m_font , &colour, NULL, s , -1);
	      m_falsch=false;
	    }
	  else
	    {
	      gtk_text_insert (GTK_TEXT (gtkctrl), m_font , &gtkctrl->style->black, NULL,s  , -1);
	      haupt->GetLektion()->Richtig();
	    }
	  if (haupt->GetLektion()->GetPos() == haupt->GetOutput()->GetLastPosition())
	    {
	      haupt->SetStatusText(_("Ende der Lektion"));
	      haupt->GetLektion()->SetEnde();
	      haupt->GetLektion()->LektionEnde();
	    }
	}
      else
	{
	  wxBell();
	  m_hauptfenster->SetStatusText(_("Falsch"));
	  m_falsch=true;
	};
    } 
}

//*********************************************************
//* Kein Paste ins Inputcontrol
//*********************************************************

void wxInputControl::OnMouse(wxMouseEvent* event)
{
}


//*********************************************************
//* 
//*********************************************************

bool wxInputControl::SetGTKFont(wxString fontname)
{
  m_font = gdk_font_load(fontname);
  m_fontname = fontname;
  std::cout << m_fontname << endl;
}
