/***************************************************************************
                          main.h  -  description                              
                             -------------------                                         
    begin                : Wed Dec 22 11:14:58 MEST 1999
                                           
    copyright            : (C) 1999 by Daniel Reith                         
    email                : DanR@gmx.de
	
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/
#ifndef MAIN_H
#define MAIN_H



#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream.h>
#include <stdlib.h>
#include <wx/wx.h>
#include <wx/splitter.h>
#include <wx/textfile.h>
#include <wx/toolbar.h>
#include <wx/config.h>
#include <wx/intl.h>

#include "outputcontrol.h"
#include "inputcontrol.h"
#include "lektion.h"
#include "kurs.h"


class tipptrainer : public wxApp
{
 public:
  virtual bool OnInit();
  virtual int OnExit();
 private:
  wxLocale m_locale;
		
};

class Hauptfenster : public wxFrame
{
 public:
  Hauptfenster();
  ~Hauptfenster();
  void OnHilfe_Info(wxCommandEvent& event);
  void OnD_Beenden(wxCommandEvent& event);
  // Einzelne Lektionen laden bzw. abbrechen
  void OnD_LBeenden(wxCommandEvent& event);
  void OnLektionLaden(wxCommandEvent& event);
  void OnD_LektionPause(wxCommandEvent& event);
  // 10 Finger Kurs beginnen, laden bzw abbrechen
  void OnD_KursLaden(wxCommandEvent& event);
  void OnD_KursBeginnen(wxCommandEvent& event);
  void OnD_KursAbbrechen(wxCommandEvent& event);
  void OnSize(wxSizeEvent& event);

  void KursEnde();
  void OnO_Einstellungen(wxCommandEvent& event);
  void OnO_Schriftwaehlen(wxCommandEvent& event);

  bool SetLektion(Lektion* lektion);
  inline Lektion* GetLektion() {return m_lektion;};
  inline wxMenu* GetDateiMenu() {return DateiMenu;};
  inline wxOutputControl* GetOutput() {return output;};
  inline wxInputControl* GetInput() {return  input;};
		
 private:
  
  wxSplitterWindow *sw;
  wxOutputControl   *output;
  wxInputControl *input;
  wxMenuBar *MainMenu;
  wxMenu		*DateiMenu;
  wxMenu		*BearbeitenMenu;
  wxMenu		*OptionenMenu;
  wxMenu		*HilfeMenu;
  Lektion* m_lektion;
  Kurs* m_kurs;
  // Event Table 
  DECLARE_EVENT_TABLE()
    
    };

    enum
    {
      D_Beenden = 1,
      Hilfe_Info = 2,
      D_LektionLaden = 3,
      O_Einstellungen = 4,
      D_LektionBeenden = 5,
      D_LPause = 6,
      D_KBeginnen = 7,
      D_KLaden = 8,
      D_KAbbrechen = 9,
      O_Schriftwaehlen = 10,      
    };

#endif
