# $Id: login.tcl,v 1.63 2004/04/12 16:22:17 aleksey Exp $


if {![info exists use_tls]} {
    set use_tls 1
}
if {$use_tls && [catch { package require tls 1.4 }]} {
    debugmsg login "unable to load the TLS package, so no SSL support!

The TLS package is available at http://tls.sf.net/"

    set use_tls 0
}
if {!$use_tls} {
    set loginconf(usessl) 0
}

set loginconf(usesasl) $jlib::lib(have_sasl)

custom::defgroup Warnings [::msgcat::mc "Warning display options."] \
    -group Tkabber

custom::defvar tls_warnings 1 [::msgcat::mc "Display SSL warnings."] \
    -group Warnings -type boolean

custom::defgroup Login \
    [::msgcat::mc "Login options."] \
    -group Tkabber

custom::defvar loginconf(user) "" \
    [::msgcat::mc "User name."] \
    -group Login -type string
custom::defvar loginconf(password) "" \
    [::msgcat::mc "Password."] \
    -group Login -type password
custom::defvar loginconf(usedigest) 1 \
    [::msgcat::mc "Use hashed password transmission."] \
    -group Login -type boolean
custom::defvar loginconf(resource) "tkabber" \
    [::msgcat::mc "Resource."] \
    -group Login -type string
custom::defvar loginconf(server) "localhost" \
    [::msgcat::mc "Server name."] \
    -group Login -type string
custom::defvar loginconf(port) "5222" \
    [::msgcat::mc "Server port."] \
    -group Login -type integer
custom::defvar loginconf(priority) "8" \
    [::msgcat::mc "Priority."] \
    -group Login -type integer
custom::defvar loginconf(connect_forever) 0 \
    [::msgcat::mc "Retry to connect forever."] \
    -group Login -type boolean
custom::defvar loginconf(usessl) 0 \
    [::msgcat::mc "Use SSL to connect to server."] \
    -group Login -type boolean
custom::defvar loginconf(sslcertfile) "" \
    [::msgcat::mc "SSL certificate file (optional)."] \
    -group Login -type string
custom::defvar loginconf(sslcafile) "" \
    [::msgcat::mc "SSL CA file (optional)."] \
    -group Login -type string
#custom::defvar loginconf(sslkeyfile) "" \
#    [::msgcat::mc "SSL private key file (optional)."] \
#    -group Login -type string
custom::defvar loginconf(sslport) "5223" \
    [::msgcat::mc "SSL port."] \
    -group Login -type integer
custom::defvar loginconf(useproxy) 0 \
    [::msgcat::mc "Use HTTP proxy to connect."] \
    -group Login -type boolean
custom::defvar loginconf(httpproxy) "localhost" \
    [::msgcat::mc "HTTP proxy address."] \
    -group Login -type string
custom::defvar loginconf(httpproxyport) 3128 \
    [::msgcat::mc "HTTP proxy port."] \
    -group Login -type integer
custom::defvar loginconf(httplogin) "" \
    [::msgcat::mc "HTTP proxy username."] \
    -group Login -type string
custom::defvar loginconf(httppassword) "" \
    [::msgcat::mc "HTTP proxy password."] \
    -group Login -type password
custom::defvar loginconf(usealtserver) 0 \
    [::msgcat::mc "Use explicitly-specified server address."] \
    -group Login -type boolean
custom::defvar loginconf(altserver) "" \
    [::msgcat::mc "Server name or IP-address."] \
    -group Login -type string
custom::defvar loginconf(replace_opened) 1 \
    [::msgcat::mc "Replace opened connections."] \
    -group Login -type boolean
custom::defvar loginconf(usehttppoll) 0 \
    [::msgcat::mc "Use HTTP poll connection method."] \
    -group Login -type boolean
custom::defvar loginconf(pollurl) "http://connect.jabber.cz/" \
    [::msgcat::mc "URL to connect to."] \
    -group Login -type string
custom::defvar loginconf(usepollkeys) 1 \
    [::msgcat::mc "Use HTTP poll client security keys (recommended)."] \
    -group Login -type boolean
custom::defvar loginconf(numberofpollkeys) 100 \
    [::msgcat::mc "Number of HTTP poll client security keys to send before creating new key sequence."] \
    -group Login -type integer
custom::defvar loginconf(polltimeout) 0 \
    [::msgcat::mc "Timeout for waiting for HTTP poll responces (if set to zero, Tkabber will wait forever)."] \
    -group Login -type integer
custom::defvar loginconf(pollmin) 3000 \
    [::msgcat::mc "Minimum poll interval."] \
    -group Login -type integer
custom::defvar loginconf(pollmax) 30000 \
    [::msgcat::mc "Maximum poll interval."] \
    -group Login -type integer
custom::defvar loginconf(usesasl) $loginconf(usesasl) \
    [::msgcat::mc "Use SASL authentification."] \
    -group Login -type boolean

custom::defvar reasonlist {} [::msgcat::mc "List of logout reasons."] \
	-group Hidden

package require http

proc login {logindata} {
    global login_after_time
    global login_after_id

    array set lc $logindata
    set user $lc(user)@$lc(server)/$lc(resource)
    if {[info exists login_after_id($user)]} {
	after cancel $login_after_id($user)
	unset login_after_id($user)
    }
    debugmsg login "Starting login"
    if {[catch {login_connect $logindata} connid] > 0} {
	# Nasty thing has happened.
	debugmsg login "Failed to connect: $connid"
	if {$lc(connect_forever)} {
	    login_retry $logindata
	} else {
	    set res [MessageDlg .connect_err -aspect 50000 -icon error \
		-message [format [::msgcat::mc "Failed to connect: %s"] $connid] \
		-type user -buttons [list abort [::msgcat::mc "Keep trying"]] \
		-default 0 -cancel 0]
	    if {$res} {
		set lc(connect_forever) 1
		set logindata [array get lc]
		login_retry $logindata
	    }
	}
	return
    }
    # OK, connected.
    debugmsg login "Connect successful ($user)"
    set login_after_time 15000
    login_login $logindata $connid
}

proc login_retry {logindata} {
    global login_after_time
    global login_after_id

    if {![info exists login_after_time]} {set login_after_time 15000}
    if {$login_after_time < 1800000} {
	# 1800000 == 30 * 60 * 1000 == 30min
	# the sequence goes: 30s, 1min, 2min, 4min, 8min, 16min, 32min, 32min...
	set login_after_time [expr {$login_after_time * 2}]
    }
    array set lc $logindata
    set user $lc(user)@$lc(server)/$lc(resource)
    debugmsg login "Scheduling connect retry for $user in ${login_after_time}ms"
    if {[info exists login_after_id($user)]} {
	after cancel $login_after_id($user)
    }
    set login_after_id($user) [after $login_after_time [list login $logindata]]
}

proc tls_callback {sock args} {
    global tls_result tls_warnings
    global ssl_certificate_fields
    global tls_warning_info

    switch -- [lindex $args 0] {
	info {
	    set_status [join [lrange $args 2 end] " "]
	}

	verify {
	    if {[cequal [set reason [lindex $args 5]] ""]} {
		return 1
	    }
	    set info [::msgcat::mc [string totitle $reason 0 0]]
	    append tls_warning_info($sock) "$info\n"
	    if {!$tls_warnings} {
		return 1
	    }
	    append info [::msgcat::mc ". Proceed?\n\n"]
	    foreach {k v} [lindex $args 3] {
		if {![cequal $v ""] && [info exists ssl_certificate_fields($k)]} {
		    append info [format "%s: %s\n" $ssl_certificate_fields($k) $v]
		}
	    }

	    set blocking [fconfigure [set fd [lindex $args 1]] -blocking]
	    fconfigure $fd -blocking 1
	    set readable [fileevent $fd readable]
	    fileevent $fd readable {}

	    set res [MessageDlg .tls_callback -aspect 50000 -icon warning \
			        -type user -buttons {yes no} -default 1 \
			        -cancel 1 \
			        -message [string trim $info]]

	    fileevent $fd readable $readable
	    fconfigure $fd -blocking $blocking

	    if {$res} {
		set res 0
	    } else {
		set res 1
	    }
	    return $res
	}

	error {
	    set tls_result [join [lrange $args 2 end] " "]
	}

	default {
	}
    }
}

proc tls_handshake {fd} {
    global tls_count
    global tls_failures
    global tls_result

    incr tls_count
    if {[eof $fd]} {
	set tls_result "EOF during TLS handshake"
	fileevent $fd readable {}
	fileevent $fd writable {}
	return
    }
    flush $fd
    set thrown [catch { tls::handshake $fd } shook]
    if {(!$thrown) && ($shook)} {
	set tls_result ""
    } elseif {[incr tls_failures] > 15} {
	set tls_result $shook
    }
}

proc login_connect {logindata} {
    global use_tls
    global tls_warning_info

    array set lc $logindata
    if {!$lc(usehttppoll)} {
	if {!$lc(useproxy)} {
	    if {$lc(usealtserver)} {
		set server $lc(altserver)
	    } else {
		set server $lc(server)
	    }
	    set server [jlib::idna_domain_toascii $server]
	    if {$use_tls && $lc(usessl)} {
		global tls_count
		global tls_failures
		global tls_result

	        set sock [socket $server $lc(sslport)]
		set tls_warning_info($sock) {}
		set args [list -command [list [namespace current]::tls_callback $sock] \
			       -ssl2    false                                          \
			       -ssl3    true                                           \
			       -tls1    true                                           \
			       -request true                                           \
			       -require false                                          \
			       -server  false]
		if {![cequal $lc(sslcertfile) ""]} {
		    if {[cequal $lc(sslcafile) ""]} {
		        lappend args -cafile $lc(sslcertfile)
		    } else {
		      lappend args -cafile $lc(sslcafile)
		    }
		}
		eval [list tls::import $sock] $args

		fconfigure $sock -encoding binary -translation binary

		fileevent $sock readable \
			  [list [namespace current]::tls_handshake $sock]
		fileevent $sock writable {}

		set tls_count 0
		set tls_failures 0
		catch { unset tls_result }
		tls_handshake $sock
		while {![info exists tls_result]} {
		    vwait tls_count
		}

		fileevent $sock readable {}

		if {![cequal $tls_result ""]} {
		    catch { close $sock }
		    error $tls_result
		}
	    } else {
	        set sock [socket $server $lc(port)]
	    }
	} else {
	    set sock [connect_httpproxy $logindata]
	}

	return [jlib::connect $sock $lc(server) \
			-newconnection [expr {!$lc(replace_opened)}] \
			-user $lc(user) \
			-resource $lc(resource) \
			-usesasl $lc(usesasl)]
    } else {
	if $lc(useproxy) {
	    set Proxy(use)      1
	    ::http::config -proxyhost $lc(httpproxy) -proxyport $lc(httpproxyport)

	    if {$lc(httplogin) != ""} {
		set auth [base64::encode \
                              [encoding convertto "$lc(httplogin):$lc(httppassword)"]]
		set Proxy(auth) [list "Proxy-Authorization" "Basic $auth"]
	    } else {
		set Proxy(auth) {}
	    }
	} else {
	    set Proxy(use)      0
	    set Proxy(auth)     {}
	}
	
	return [jlib::connect {} $lc(server) \
			-newconnection [expr {!$lc(replace_opened)}] \
			-user $lc(user) \
			-resource $lc(resource) \
			-httppoll 1 \
			-polltimeout $lc(polltimeout) \
			-pollint $lc(pollmin) \
			-pollmin $lc(pollmin) \
			-pollmax $lc(pollmax) \
			-pollurl $lc(pollurl) \
			-pollusekeys $lc(usepollkeys) \
			-pollnumkeys $lc(numberofpollkeys) \
			-proxy $Proxy(use) \
			-proxyauth $Proxy(auth) \
			-usesasl $lc(usesasl)]
    }
}
    
proc login_login {logindata connid} {
    global loginconf_hist_$connid
    global gr_nick gr_server gra_server
    global auth_result

    array set lc $logindata
    array set loginconf_hist_$connid $logindata

    set gr_nick $lc(user)
    set gr_server conference.$lc(server)
    set gra_server conference.$lc(server)

    jlib::wait_for_stream $connid

    if {$lc(usedigest)} {
	set autht digest
    } else {
	set autht plain
    }

    lassign [jlib::get_authtypes $lc(user) $connid] res data

    switch -- $res {
	ERR {
	    clear_status
	    recv_auth_result $connid ERR $data
	    return
	}
	OK {
	    set authtype ""
	    foreach at [list $autht digest plain] {
		if {[lcontain $data $at]} {
		    set authtype $at
		    break
		}
	    }

	    if {[cequal $authtype ""]} {
		MessageDlg .auth_err -aspect 50000 -icon error \
		    -message [::msgcat::mc "Can't authenticate: Remote server\
doesn't support\nplain or digest authentication method"] \
		    -type user -buttons ok -default 0 -cancel 0
		return
	    }
	    if {[cequal $authtype plain] && [cequal $autht digest]} {
		set res [MessageDlg .auth_err -aspect 50000 -icon warning \
		    -message [::msgcat::mc "Warning: Remote server doesn't\
support\nhashed password authentication.\n\nProceed with PLAINTEXT authentication?"] \
		    -type user -buttons {yes no} -default 0 -cancel 1]
		if {$res} {
		    return
		}
	    }
	}
	SASL {
	    set authtype ""
	}
    }

    jlib::send_auth \
	$lc(user) $lc(password) $lc(resource) \
	[list recv_auth_result $connid] $authtype $connid
    vwait auth_result($connid)

    if {$auth_result($connid) == "OK"} {
        connected $logindata $connid
    }
}

set reconnect_retries 0

proc logout {{connid {}}} {
    global reconnect_retries
    global login_after_id

    # TODO
    foreach user [array names login_after_id] {
	after cancel $login_after_id($user)
	unset login_after_id($user)
    }

    jlib::disconnect $connid
    if {$connid == {}} {
	roster::clean
    } else {
	roster::clean_connection $connid
    }

    disconnected $connid

    set reconnect_retries 0
}

proc client:disconnect {connid} {
    logout $connid
}

# TODO
proc client:reconnect {connid} {
    global reconnect_retries
    global loginconf_hist_$connid

    debugmsg login "RECONNECT $connid"
    roster::clean_connection $connid

    if {[jlib::connections] == {}} {
	set_status "Disconnected"
    }

    disconnected $connid
    if {[incr reconnect_retries] <= 3} {
        after 1000 [list login [array get loginconf_hist_$connid]]
    }
}

proc connected {logindata connid} {
    hook::run connected_hook $connid
}

# TODO
proc disconnected {connid} {
    global curuserstatus userstatusdesc

    if {[jlib::connections] == {}} {
	set curuserstatus unavailable
	set userstatusdesc [::msgcat::mc "Not logged in"]
	hook::run change_our_presence_post_hook unavailable
    }
    hook::run disconnected_hook $connid
}

package require base64

proc connect_httpproxy {logindata} {
    global use_tls

    array set lc $logindata
    set sock [socket $lc(httpproxy) $lc(httpproxyport)]
    fconfigure $sock -buffering line

    if {$lc(usealtserver)} {
	set server $lc(altserver)
    } else {
	set server $lc(server)
    }
    set server [jlib::idna_domain_toascii $server]
    if {$use_tls && $lc(usessl)} {
	puts $sock \
	    "CONNECT $server:${lc(sslport)} HTTP/1.0"
    } else {
	puts $sock "CONNECT $server:${lc(port)} HTTP/1.0"
    }
    
    if {$lc(httplogin) != ""} {
	set auth [base64::encode \
		      [encoding convertto "$lc(httplogin):$lc(httppassword)"]]
	puts $sock "Proxy-Authorization: Basic $auth"
    }
    puts $sock ""

    fileevent $sock readable {set proxy_readable ""}
    global proxy_readable
    vwait proxy_readable
    fileevent $sock readable {}

    set result [gets $sock]

    set code [lindex [split $result { }] 1]

    #debugmsg login $code
    if {$code >= 200 && $code < 300} {
	while {![cequal [gets $sock] ""]} { }
	if {$use_tls && $lc(usessl)} {
	    if {[cequal $lc(sslcertfile) ""]} {
		tls::import $sock
	    } else {
		tls::import $sock -cafile $lc(sslcafile)
	    }
	}
	return $sock
    } else {
	error "proxy return: $result"
    }
}

proc recv_auth_result {connid res args} {
    global auth_result
    upvar #0 loginconf_hist_$connid lc

    if {$res == "OK"} {
	set auth_result($connid) OK
    } else {
	set auth_result($connid) ERR
	set res [MessageDlg .auth_err -aspect 50000 -icon error \
		     -message [format \
				   [::msgcat::mc "Authentication failed: %s\nCreate new account?"] \
				   [error_to_string [lindex $args 0]]] \
		     -type user -buttons {yes no} -default 0 -cancel 1]
	if {!$res} {
	    jlib::send_iq set \
		[jlib::wrapper:createtag query \
		     -vars {xmlns jabber:iq:register} \
		     -subtags [list [jlib::wrapper:createtag username \
					 -chdata $lc(user)] \
				   [jlib::wrapper:createtag password \
					-chdata $lc(password)]]] \
		-command [list recv_register_result [array get lc]]
	}
    }
}

proc recv_register_result {logindata res args} {
    if {$res == "OK"} {
	jlib::disconnect
	login $logindata
    } else {
	MessageDlg .auth_err -aspect 50000 -icon error \
	    -message [format [::msgcat::mc "Registration failed: %s"] \
			  [error_to_string [lindex $args 0]]] \
	    -type user -buttons ok -default 0 -cancel 0
    }
}

# TODO
proc change_password_dialog {} {
    global oldpassword newpassword password

    set oldpassword ""
    set newpassword ""
    set password ""

    if {[winfo exists .passwordchange]} {
	destroy .passwordchange
    }
    
    Dialog .passwordchange -title [::msgcat::mc "Change password"] \
	-separator 1 -anchor e -default 0 -cancel 1

    .passwordchange add -text [::msgcat::mc "OK"] -command {
	destroy .passwordchange
	send_change_password
    }
    .passwordchange add -text [::msgcat::mc "Cancel"] -command [list destroy .passwordchange]


    set p [.passwordchange getframe]
    
    label $p.loldpass -text [::msgcat::mc "Old password:"]
    ecursor_entry [entry $p.oldpass -show * -textvariable oldpassword]
    label $p.lnewpass -text [::msgcat::mc "New password:"]
    ecursor_entry [entry $p.newpass -show * -textvariable newpassword]
    label $p.lpassword -text [::msgcat::mc "Repeat new password:"]
    ecursor_entry [entry $p.password -show * -textvariable password]

    grid $p.loldpass  -row 0 -column 0 -sticky e
    grid $p.oldpass   -row 0 -column 1 -sticky ew
    grid $p.lnewpass  -row 1 -column 0 -sticky e
    grid $p.newpass   -row 1 -column 1 -sticky ew
    grid $p.lpassword -row 2 -column 0 -sticky e
    grid $p.password  -row 2 -column 1 -sticky ew

    focus $p.oldpass
    .passwordchange draw

}

# TODO
proc send_change_password {} {
    global loginconf
    global oldpassword newpassword password

    if {$oldpassword != $loginconf(password)} {
	MessageDlg .auth_err -aspect 50000 -icon error \
	        -message [::msgcat::mc "Old password is incorrect"] \
		-type user -buttons ok -default 0 -cancel 0
	return
    }
    if {$newpassword != $password} {
	MessageDlg .auth_err -aspect 50000 -icon error \
	        -message [::msgcat::mc "New passwords do not match"] \
		-type user -buttons ok -default 0 -cancel 0
	return
    }

    jlib::send_iq set \
	    [jlib::wrapper:createtag query \
		    -vars {xmlns jabber:iq:register} \
		    -subtags [list [jlib::wrapper:createtag username \
					-chdata $loginconf(user)] \
				   [jlib::wrapper:createtag password \
					-chdata $password]]] \
	    -to $loginconf(server) \
	    -command recv_change_password_result
}

# TODO
proc recv_change_password_result {res args} {
    global loginconf
    global newpassword

    if {$res == "OK"} {
	MessageDlg .shpasswd_result -aspect 50000 -icon info \
		-message [::msgcat::mc "Password is changed"] \
		-type user -buttons ok -default 0 -cancel 0
	for {set i 1} {[info exists ::loginconf$i]} {incr i} {
	    if {!([info exists ::loginconf${i}(user)] && \
		    [info exists ::loginconf${i}(server)] && \
		    [info exists ::loginconf${i}(password)])} {
		continue
	    }
	    upvar ::loginconf${i}(user) user
	    upvar ::loginconf${i}(server) server
	    upvar ::loginconf${i}(password) password
	    if {[string equal $user $loginconf(user)] && \
		    [string equal $server $loginconf(server)] && \
		    [string equal $password $loginconf(password)]} {
		set password $newpassword
	    }
	}
	set loginconf(password) $newpassword
    } else {
	MessageDlg .shpasswd_result -aspect 50000 -icon error \
	    -message [format [::msgcat::mc "Password change failed: %s"] [error_to_string [lindex $args 0]]] \
	    -type user -buttons ok -default 0 -cancel 0
    }
}

# TODO
proc show_logout_dialog {} {
    global reason reasonlist

    set lw .logout

    if {![winfo exists $lw]} {
        Dialog $lw -title [::msgcat::mc "Logout with reason"] \
	    -separator 1 -anchor e -default 0 -cancel 1

        set lf [$lw getframe]
        grid columnconfigure $lf 1 -weight 1

	if {[llength $reasonlist]} {set reason [lindex $reasonlist 0]}

        label $lf.lreason   -text    [::msgcat::mc "Reason:"]
        ecursor_entry [ComboBox $lf.reason -textvariable reason \
		-values $reasonlist -width 35].e
        label $lf.lpriority -text    [::msgcat::mc "Priority:"]
        ecursor_entry [entry $lf.priority -textvariable loginconf(priority)]

        grid $lf.lreason   -row 0 -column 0 -sticky e
        grid $lf.reason    -row 0 -column 1 -sticky ew
        grid $lf.lpriority -row 1 -column 0 -sticky e
        grid $lf.priority  -row 1 -column 1 -sticky ew

        $lw add -text [::msgcat::mc "Log out"] -command logout_reason
        $lw add -text [::msgcat::mc "Cancel"] -command "$lw withdraw"
    } else {
        set lf [$lw getframe]
    }

    $lw draw $lf.reason
}

proc logout_reason {} {
    global userstatus textstatus reason reasonlist

    set reasonlist [update_combo_list $reasonlist $reason 10]
    set custom::saved(::::reasonlist) $reasonlist
    custom::store

    set lw .logout
    $lw withdraw

    set textstatus $reason
    set userstatus unavailable

    logout

    destroy $lw
}

