# $Id: send_message.tcl,v 1.3 2003/06/21 19:16:25 aleksey Exp $

proc send_message {chatid user body type} {
    global messageicon

    set connid [chat::get_connid $chatid]
    set jid [chat::get_jid $chatid]
    set chatw [chat::chat_win $chatid]

    if {[hook::is_flag chat_send_message_hook send]} {
	lappend events [jlib::wrapper:createtag offline]
	lappend events [jlib::wrapper:createtag delivered]
	lappend events [jlib::wrapper:createtag displayed]
	lappend events [jlib::wrapper:createtag composing]
	lappend xlist [jlib::wrapper:createtag x \
			   -vars [list xmlns jabber:x:event] \
			   -subtags $events]

	set command [list message::send_msg $jid \
			 -connection $connid \
			 -type $type \
			 -body $body]
	if {[info exists ::chat::chats(thread,$chatid)]} {
	    lappend command -thread $::chat::chats(thread,$chatid)
	}
	if {$type == "chat"} {
	    lappend command -xlist $xlist
	}
	lassign [eval $command] status x
	if {$status == "error"} {
	    return stop
	}

	set signP 0
	set encryptP 0
	foreach xe $x {
	    jlib::wrapper:splitxml $xe tag vars isempty chdata children

	    switch -- [jlib::wrapper:getattr $vars xmlns] {
		jabber:x:signed {
		    set signP 1
		}

		jabber:x:encrypted {
		    set encryptP 1
		}
	    }
	}

	if {![cequal $type groupchat]} {
	    if {$encryptP} {
		$chatw image create start_message \
		    -image $messageicon(encrypted)
	    }
	    if {$signP} {
		$chatw image create start_message -image $messageicon(signed)
	    }
	}
    }
    hook::unset_flag chat_send_message_hook send
}
hook::add chat_send_message_hook [namespace current]::send_message 90
