#   Copyright (C) 1987-2001 by Jeffery P. Hansen
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Last edit by hansen on Fri Sep 15 12:23:07 2000
#

proc tkg_scopeMenu {w} {
  menubutton $w.file -text [m file] -menu $w.file.menu -underline [ul 0]
  menu $w.file.menu
  $w.file.menu add command -label [m menu.sc.prtrace] -underline [ul 0] -accelerator "Ctl-S p" -command tkg_scopePrintDlg
  $w.file.menu add command -label [m menu.sc.close] -underline [ul 0] -accelerator "Ctl-S e" -command { gat_setMajorMode edit }

  menubutton $w.simulate -text [m simulate] -menu $w.simulate.menu -underline [ul 0]
  tkg_makeSimMenu $w.simulate.menu normal

  $w.simulate.menu entryconfigure 1 -label [m simend] -underline [ul 0] -command { gat_setMajorMode edit } -accelerator "Ctl-S e"

  menubutton $w.trace -text [m menu.sc.trace] -menu $w.trace.menu -underline [ul 0]
  menu $w.trace.menu
  $w.trace.menu add command -label [m menu.sc.zoomin] -underline [ul 5] -accelerator "<" -command { .scope.main.frame.canvas zoom -1 }
  $w.trace.menu add command -label [m menu.sc.zoomout] -underline [ul 5] -accelerator ">"  -command { .scope.main.frame.canvas zoom 1 }

  menubutton $w.help -text [m help]

  pack $w.file -side left
  pack $w.simulate -side left
  pack $w.trace -side left
  pack $w.help -side right 
}

proc tkg_makeScope {} {
  toplevel .scope
  wm geometry .scope +70+0

  frame .scope.mbar -relief raised -bd 2
  frame .scope.main
  frame .scope.main.frame -relief sunken -bd 2

  tkg_scopeMenu .scope.mbar

  bind .scope <Destroy> { gat_setMajorMode edit }

  gat_scope .scope.main.frame.canvas -width 500 -height 400
  scrollbar .scope.main.vert -command ".scope.main.frame.canvas yview" -takefocus 0
  scrollbar .scope.main.horz -orient horizontal  -command ".scope.main.frame.canvas xview" -takefocus 0
  pack .scope.main.vert -side right -fill y
  pack .scope.main.horz -side bottom -fill x
  pack .scope.main.frame -side top -fill both -expand 1 -padx 5 -pady 5
  pack .scope.main.frame.canvas -fill both -expand 1

  pack .scope.mbar -fill x
  pack .scope.main -fill both -expand 1
  tkg_setBindings .scope

  bind .scope.main.frame.canvas <Button-1> 	{ gat_scopeButton %x %y 1 %s }
  bind .scope.main.frame.canvas <Button-3> 	{ gat_scopeButton %x %y 3 %s }
  bind .scope.main.frame.canvas <B1-Motion> 	{ gat_scopeMotion %x %y 1 %s }
  bind .scope.main.frame.canvas <ButtonRelease-1> { gat_scopeMotion %x %y 1 %s }
}

proc tkg_destroyScope {} {
  catch { destroy .scope }

}

proc scope_test {} {
  button .make -text Scope -command makeScope
  button .print -text Print -command printDlg
  pack .make .print -fill x
  wm geometry . +0+0
}
