#   Copyright (C) 1987-2005 by Jeffery P. Hansen
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Last edit by hansen on Thu Feb 14 09:36:00 2002

#
# File menu
#
proc tkg_makeFileMenu {m} {
  menu $m
  $m add command -label [m new] -underline [ul 0] -command act_newFile -accelerator "Ctl-X k"
  $m add command -label [m open] -underline [ul 0] -command act_loadFile -accelerator "Ctl-X Ctl-F"
  $m add command -label [m openlib] -underline [ul 5] -command act_loadLibrary -accelerator "Ctl-X Ctl-L"
  $m add command -label [m save] -underline [ul 0] -command act_saveFile -accelerator "Ctl-X Ctl-S"
  $m add command -label [m saveas] -underline [ul 1] -command act_saveAsFile -accelerator "Ctl-X Ctl-W"
  $m add separator
  $m add command -label [m print] -underline [ul 0] -accelerator "Ctl-X Ctl-P" -command act_print
  $m add command -label [m options] -underline [ul 2] -command act_editOptions -accelerator "Ctl-X o"
  $m add separator
  $m add command -label [m quit]  -underline [ul 0] -command act_exit -accelerator "Ctl-X Ctl-C"
}

######################################################################
#
# Edit menu
#
# Note: state changing code in sel_updateMenuState (selection.c) must
# be changed if new options are added.
#
proc tkg_makeEditMenu {m} {
  menu $m
  $m add command -label [m undo] -underline [ul 0] -accelerator "Alt-u" -command act_undo
  $m add command -label [m redo] -underline [ul 0] -accelerator "Alt-r" -command act_redo
  $m add separator
  $m add command -label [m cut] -underline [ul 0] -accelerator "Ctl-W" -command act_cutToBuf
  $m add command -label [m copy] -underline [ul 3] -accelerator "Ctl-X x" -command act_copyToBuf
  $m add command -label [m paste] -underline [ul 0] -accelerator "Ctl-Y" -command act_yankFromBuf
  $m add command -label [m selall] -underline [ul 0] -accelerator "Ctl-X a" -command act_selectAll
  $m add command -label [m find] -underline [ul 0] -accelerator "Ctl-F" -command act_findObject
  $m add separator
  $m add command -label [m algnv] -underline [ul 6] -accelerator "|" -command act_vAlign
  $m add command -label [m algnh] -underline [ul 6] -accelerator "-" -command act_hAlign
  $m add separator
  $m add command -label [m zoomin] -underline [ul 5] -accelerator "Ctl-z i" -command act_zoomIn
  $m add command -label [m zoomout] -underline [ul 5] -accelerator "Ctl-z o" -command act_zoomOut
}

######################################################################
#
# Tool selection menu
#
proc tkg_makeToolMenu {m} {
    global tkg_allowDebug

    menu $m
    $m add radiobutton -label [m move] -underline [ul 0] -variable mode -value 1 -accelerator F1 -command act_editMode
    $m add radiobutton -label [m delg] -underline [ul 0] -variable mode -value 3 -accelerator F2 -command act_deleteMode
    $m add radiobutton -label [m cutw] -underline [ul 0] -variable mode -value 0 -accelerator F3 -command act_cutMode
    $m add radiobutton -label [m inv] -underline [ul 0] -variable mode -value 2 -accelerator F4 -command act_invertMode
    $m add radiobutton -label [m bitw] -underline [ul 0] -variable mode -value 9 -accelerator F5 -command act_sizeMode
    if { $tkg_allowDebug } {
	$m add radiobutton -label [m debug] -underline [ul 0] -variable mode -value 12 -accelerator F6 -command act_debugMode
    }
    $m add separator
    $m add radiobutton -label [m rot0] -underline [ul 4] -variable rot -value 0 -accelerator Ctl-F1 -command act_rot0
    $m add radiobutton -label [m rot90] -underline [ul 4] -variable rot -value 1 -accelerator Ctl-F2 -command act_rot90
    $m add radiobutton -label [m rot180] -underline [ul 4] -variable rot -value 2 -accelerator Ctl-F3 -command act_rot180
    $m add radiobutton -label [m rot270] -underline [ul 4] -variable rot -value 3 -accelerator Ctl-F4 -command act_rot270
}

######################################################################
#
# Circuit menu
#
proc tkg_makeCircMenu {m} {
  menu $m
  $m add command -label [m circprop] -underline [ul 8] -command act_editCProps -accelerator "Ctl-x E"
  $m add command -label [m cpath] -underline [ul 8] -command act_cpathAnal -accelerator "Ctl-x r"
}

######################################################################
#
# Simulator menu
#
proc tkg_makeSimMenu {m s} {
  menu $m
  $m add command -label [m simbegin] -underline [ul 0] -command act_startSimulator -accelerator "Ctl-S b"
  $m add separator
  $m add command -label [m simrun] -underline [ul 0] -command act_simRun -accelerator "Ctl-S g" -state $s
  $m add command -label [m simpause] -underline [ul 0] -command act_simStop  -accelerator "Ctl-S s" -state $s
  $m add command -label [m simstep] -underline [ul 0] -command act_simStep -accelerator "Space" -state $s
  $m add command -label [m simcycle] -underline [ul 5] -command act_simCycle -state $s -accelerator "Tab"
  $m add command -label [m simbreak] -underline [ul 0] -state $s -command act_editBreakpoints -accelerator "Ctl-S k"
  $m add command -label [m simscript] -underline [ul 1] -state $s -command act_doSimScript -accelerator "Ctl-S x"
  $m add separator
  $m add command -label [m simload] -underline [ul 1] -state $s -command act_simLoadMem -accelerator "Ctl-S l"
  $m add command -label [m simdump] -underline [ul 1] -state $s -command act_simDumpMem -accelerator "Ctl-S d"
  $m add separator
  $m add command -label [m simadprobe] -underline [ul 0] -command act_toggleProbe -accelerator "P" -state $s
}

######################################################################
#
# Module Operations
#
proc tkg_makeModuleMenu {m} {
  menu $m
  $m add command -label [m modopen] -underline [ul 0] -command act_openMod -accelerator >
  $m add command -label [m modclose] -underline [ul 0] -command act_closeMod -accelerator <
  $m add separator
  $m add command -label [m modseti] -underline [ul 0] -command act_setBlockDesc -accelerator "Ctl-b s"
  $m add command -label [m modediti] -underline [ul 0] -command act_editBlockDesc -accelerator "Ctl-b e"
  $m add separator
  $m add command -label [m modnew] -underline [ul 0] -accelerator "Ctl-b n" -command act_blockNew
  $m add command -label [m moddel] -underline [ul 0] -accelerator "Ctl-b d" -command act_blockDelete
  $m add command -label [m modcopy] -underline [ul 0] -accelerator "Ctl-b c" -command act_blockCopy
  $m add command -label [m modrename] -underline [ul 0] -accelerator "Ctl-b r" -command  act_blockRename
  $m add command -label [m modclaim] -underline [ul 1] -accelerator "Ctl-b l" -command act_blockClaim
}

######################################################################
#
# Gate menu
#
proc tkg_makeGateMenu {m} {
  global gatesetech_w

  menu $m
  $m add command -label [m gataddin] -underline [ul 4] -command act_addIn -accelerator \[
  $m add command -label [m gataddout] -underline [ul 4]  -command act_addOut -accelerator \]
  $m add command -label [m gataddinout] -underline [ul 6] -command act_addInOut -accelerator -
  $m add command -label [m gatiochg] -underline [ul 1]  -command act_editPort -accelerator @
  $m add separator
  $m add command -label [m gatanchor] -underline [ul 0] -command act_anchor -accelerator "Ctl-x f"
  $m add command -label [m gatunanchor] -underline [ul 0] -command act_unacnhor -accelerator "Ctl-x u"
  $m add separator
  $m add command -label [m gatrep] -underline [ul 0] -command act_replicate -accelerator Ctl-V
  $m add command -label [m gatdel] -underline [ul 0] -accelerator Del -command act_delete
  $m add cascade -label [m gatsettech] -underline [ul 0] -menu $m.settech
  $m add command -label [m gatprop] -underline [ul 0] -command act_editProps -accelerator E

  menu $m.settech -tearoff 0 
  set gatesetech_w $m.settech
}

######################################################################
#
# Gate creation menus - created based on data in each gate's .c file.
#
proc tkg_makeMakeMenu {m} {
  gat_makeMakeMenu $m
}

menubutton .mbar.file -text [m file] -underline [ul 0] -menu .mbar.file.menu
tkg_makeFileMenu .mbar.file.menu

menubutton .mbar.edit -text [m edit] -underline [ul 0] -menu .mbar.edit.menu 
tkg_makeEditMenu  .mbar.edit.menu

menubutton .mbar.tool -text [m tool] -underline [ul 0] -menu .mbar.tool.menu 
tkg_makeToolMenu .mbar.tool.menu

menubutton .mbar.circ -text [m circ] -underline [ul 0] -menu .mbar.circ.menu 
tkg_makeCircMenu .mbar.circ.menu

menubutton .mbar.sim -text [m simulate] -underline [ul 0] -menu .mbar.sim.menu
tkg_makeSimMenu .mbar.sim.menu normal

menubutton .mbar.module -text [m module] -underline [ul 1] -menu .mbar.module.menu
tkg_makeModuleMenu  .mbar.module.menu


menubutton .mbar.gate -text [m gate] -underline [ul 0] -menu .mbar.gate.menu
tkg_makeGateMenu  .mbar.gate.menu

menubutton .mbar.make -text [m make] -underline [ul 0] -menu .mbar.make.menu
tkg_makeMakeMenu  .mbar.make.menu

######################################################################
#
# Help menu
#
menubutton .mbar.help -text [m help] -underline [ul 0] -menu .mbar.help.menu
menu .mbar.help.menu
.mbar.help.menu add command -label [m hlpabout] -underline [ul 0] -command act_showAbout
.mbar.help.menu add command -label [m hlplicense] -underline [ul 0] -command act_showLicense
.mbar.help.menu add command -label [m hlpdoc] -underline [ul 0] -command act_showDocumentation
.mbar.help.menu add separator
.mbar.help.menu add cascade -label [m hlptut] -menu .mbar.help.menu.tut -underline [ul 1]
.mbar.help.menu add cascade -label [m hlpexample] -menu .mbar.help.menu.ex -underline [ul 1]

menu .mbar.help.menu.ex -tearoff 0
.mbar.help.menu.ex add command -label [m exampcomb] -underline [ul 0] -command act_loadExample1
.mbar.help.menu.ex add command -label [m examp3bit] -underline [ul 0] -command act_loadExample2
.mbar.help.menu.ex add command -label [m examp8bit] -underline [ul 0] -command act_loadExample3
.mbar.help.menu.ex add command -label [m examptrff] -underline [ul 0] -command act_loadExample4
.mbar.help.menu.ex add command -label [m exampcpu] -underline [ul 12] -command act_loadExample5

menu .mbar.help.menu.tut -tearoff 0
.mbar.help.menu.tut add command -label [m tutwelcome] -underline [ul 0] -command act_loadTutorial1
.mbar.help.menu.tut add command -label [m tutcreate] -underline [ul 0] -command act_loadTutorial2
.mbar.help.menu.tut add command -label [m tutedit1] -underline [ul 19] -command act_loadTutorial3
.mbar.help.menu.tut add command -label [m tutedit2] -underline [ul 19] -command act_loadTutorial4
.mbar.help.menu.tut add command -label [m tutmods] -underline [ul 0] -command act_loadTutorial5
.mbar.help.menu.tut add command -label [m tutsim] -underline [ul 0] -command act_loadTutorial6

######################################################################
#
# Final menu creation
#

pack .mbar.file .mbar.edit .mbar.tool .mbar.circ .mbar.sim .mbar.module .mbar.gate .mbar.make -in .mbar -side left
pack .mbar.help -in .mbar -side right

