!
! gx.h -- symbolic constants for the gx device
!
.set GX_BUFFER,         0x100000  ! start address for GX registers

.set GX_OPEN,           0         ! command numbers
.set GX_CLOSE,          1
.set GX_COLOR,          2
.set GX_OP,             3
.set GX_LINE,           4
.set GX_FILL,           5
.set GX_BLIT,           6

.set GX_STATUS,         0         ! symbolic buffer offsets
.set GX_CMD,            4
.set GX_ARG,            8

.set GX_FILL_X,         8         !   for fill
.set GX_FILL_Y,        12
.set GX_FILL_W,        16
.set GX_FILL_H,        20

.set GX_LINE_X1,        8         !   for line
.set GX_LINE_Y1,       12
.set GX_LINE_X2,       16
.set GX_LINE_Y2,       20

.set GX_BLIT_X1,        8         !   for blit
.set GX_BLIT_Y1,       12
.set GX_BLIT_W,        16
.set GX_BLIT_H,        20
.set GX_BLIT_X2,       24
.set GX_BLIT_Y2,       28

! drawing functions for the GX_OP command
.set GX_CLEAR,         0x0         ! 0
.set GX_AND,           0x1         ! source AND destination
.set GX_AND_REVERSE,   0x2         ! source AND NOT destination
.set GX_COPY,          0x3         ! source
.set GX_AND_INVERTED,  0x4         ! NOT source AND destination
.set GX_NOOP,          0x5         ! destination
.set GX_XOR,           0x6         ! source XOR destination
.set GX_OR,            0x7         ! source OR destination
.set GX_NOR,           0x8         ! NOT source AND NOT destination
.set GX_EQUIV,         0x9         ! NOT source XOR destination
.set GX_INVERT,        0xa         ! NOT destination
.set GX_OR_REVERSE,    0xb         ! source OR NOT destination
.set GX_COPY_INVERTED, 0xc         ! NOT source
.set GX_OR_INVERTED,   0xd         ! NOT source OR destination
.set GX_NAND,          0xe         ! NOT source OR NOT destination
