/*
** TleenX2 (Tlen.pl Client)
** Copyright (c) 2002-2003 Hubert Sokoowski <who_ami@tlen.pl>
**                         Pawe Biliski <rael@fr.pl>
**
** This code is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License.
**
*/


#include <stdlib.h>
#include <ctype.h>

#include "main.h"
#include "conffile.h"
#include "users.h"
#include "utils.h"
#include "callbacks.h"

static gint status_map[]={STATUS_AVAILABLE,
  STATUS_EXT_AWAY, STATUS_AWAY,
  STATUS_DND, STATUS_CHATTY,  STATUS_INVISIBLE, STATUS_UNAVAILABLE};

//static gint gg_status_map[]={STATUS_AVAILABLE, STATUS_AWAY,
//  STATUS_UNAVAILABLE};


gchar *user_description(struct user *user)
{
  gchar *s = NULL;

  if(user->description)
  {
    if(strlen(user->description))
    {
      if(strcmp(user->description, opisy[user->status-2]))
      {
        if(user->type == USER_TLEN)
          s = utf(user->description);
        else
          s = g_strdup(user->description);
      }
    }
  }
  return s;
}

gboolean subscription_to(struct user *u)
{
  if(!strcmp(u->subscription, "to") ||
     !strcmp(u->subscription, "both"))
    return TRUE;
  return FALSE;
}

gboolean subscription_from(struct user *u)
{
  if(!strcmp(u->subscription, "from") ||
     !strcmp(u->subscription, "both"))
    return TRUE;
  return FALSE;
}

gint get_type(gchar *id)
{
  gchar *s;

  s = strchr(id, '@');
  if(!s)
  {
    s = strchr(id, '.');
    if(!s)
    {
      if(isdigit(id[0]))
        return USER_GG;
      return USER_TLEN;
    }
    return USER_AGENT;
  }
  if(!strcasecmp(s+1, "tlen.pl"))
    return USER_TLEN;
  if(!strcasecmp(s+1, "jabber.wp.pl"))
    return USER_WP;
  if(profile->ggserver)
  {
    if(!strcasecmp(s+1, profile->ggserver))
      return USER_GG;
  }
  return USER_JABBER;
}

gint get_status(struct user *u)
{
  if(!u)
    return STATUS_UNAVAILABLE;
  switch(u->type)
  {
    case USER_JABBER:
    case USER_WP:
    case USER_GG:
      return j_status_map[u->status-2];
      break;
//      return j_status_map[u->status-2];
//      break;
    case USER_TLEN:
    default:
      return status_map[u->status-2];
  }
}

gchar *get_user_name(const gchar *jid)
{
  gchar *name, *s;
  struct user *user;
  gint type;

  user = get_user(jid);
  if(user)
  {
    if(user->name)
      if(strlen(user->name))
        return g_strdup(user->name);
  }
  type = get_type((gchar*)jid);
  if((type == USER_JABBER) || (type == USER_WP))
    return g_strdup(jid);
  s = strchr(jid, '@');
  if(s)
  {
    *s = '\0';
    name = g_strdup(jid);
    *s = '@';
  }
  else
    name = g_strdup(jid);
  return name;
}

gint users_list_count(GList *l)
{
  gint i;
  struct user *u;

  for(i=0;l;)
  {
    u=(struct user*)l->data;
    if( (u->type != USER_AGENT) && (u->type != USER_VIRTUAL) )
      i++;
    l=l->next;
	u = NULL;
  }
  return i;
}

gint users_list_count_online(GList *l)
{
  gint i;
  struct user *u;

  i=0;
  while(l)
  {
    u=(struct user*)l->data;
    if((get_status(u) != STATUS_UNAVAILABLE) &&
       (u->type != USER_AGENT) && (u->type != USER_VIRTUAL))
      i++;
    l=l->next;
  }
  return i;
}

void free_user(struct user *u)
{
  gchar *s;

  s=u->name;
  if(s)
    g_free(s);
  s=u->jid;
  if(s)
    g_free(s);
  s=u->group;
  if(s)
    g_free(s);
  s=u->subscription;
  if(s)
    g_free(s);
  s=u->description;
  if(s)
    g_free(s);
  s=u->ask;
  if(s)
    g_free(s);
  g_free(u);
}

void users_list_clear()
{
  struct user *u;
  GList *list=users_list;

  while(list)
  {
    u=(struct user*)list->data;
    free_user(u);
    list=list->next;
  }
  g_list_free(users_list);
  users_list=NULL;
}

void talks_list_clear()
{
  struct talk *t;
  GList *list=talks_list;

  while(list)
  {
    t=(struct talk*)list->data;
    gtk_widget_destroy(t->window);
    list=list->next;
  }
  g_list_free(talks_list);
  talks_list=NULL;
}


gchar *user_subscription(const gchar *jid)
{
  GList *list=users_list;
  struct user *user;
  while(list)
  {
    user = (struct user*)list->data;
    if(!strcmp(jid,user->jid))
      return user->subscription;
    list=list->next;
  }
  return NULL;
}

//usuwa z id slash wraz z resource
gchar* user_del_res(gchar *jid)
{
  gchar *s, *s2;

  s = strdup(jid);
  s2 = strchr(s, '/');
  if(s2)
  {
    g_free(jid);
    *s2 = '\0';
    jid = strdup(s);
    *s2 = '/';
  }
  g_free(s);
  return jid;
}

struct user *get_user(const gchar *jid)
{
  GList *list=users_list;
  struct user *user=NULL;
  gchar *s=NULL;

  switch(get_type((gchar*)jid))
  {
    case USER_JABBER:
    case USER_WP:
      s = g_strdup(jid);
      s = user_del_res(s);
      break;
    case USER_TLEN:
	case USER_GG:
    case USER_AGENT:
	case USER_VIRTUAL:
      s = g_strdup(jid);
      break;
  }
  while(list)
  {
    user = (struct user*)list->data;
    if(!strcasecmp(s, user->jid))
      break;
    list=list->next;
    user = NULL;
  }
  g_free(s);
  return user;
}

void del_user(gchar *jid)
{
  struct user *u;
  GList *list;

  list=users_list;
  while(list)
  {
    u=(struct user*)list->data;
    if(!strcmp(jid,u->jid))
    {
      free_user(u);
      users_list = g_list_remove(users_list, (gpointer)u);
      break;
    }
    list = list->next;
  }
}

static
gint sortfunc(gconstpointer d1, gconstpointer d2)
{
  struct user *user1,*user2;

  user1=(struct user*)d1;
  user2=(struct user*)d2;
  return (strcmp(user1->jid,user2->jid));
}


//dodaj lub uaktualnij dane na liscie
//jesli ktores pole jest NULL to nie zmieniamy go
//jesli status jest -1 to rowniez pozostaje bez zmian
void add_user(gchar *name, gchar *jid, gchar *group, gchar *subscription,
              gchar *description, gchar *ask, int status, enum user_type type)
{
  struct user *u;

  u = get_user(jid);
  if(u)
  {
    if(name)
      if(strcmp(name,u->name))
      {
        g_free(u->name);
        u->name = g_strdup(name);
      }
    if(group)
      if(strcmp(group,u->group))
      {
        g_free(u->group);
        u->group= g_strdup(group);
      }
    if(description)
      if(strcmp(description,u->description))
      {
        g_free(u->description);
        u->description= g_strdup(description);
      }
    if(subscription)
      if(strcmp(subscription,u->subscription))
      {
        g_free(u->subscription);
        u->subscription= g_strdup(subscription);
      }
    if(ask)
      if(strcmp(ask,u->ask))
      {
        g_free(u->ask);
        u->ask= g_strdup(ask);
      }
    if((status != u->status) && (status != -1))
      u->status = status;
    if(type != -1)
      u->type = type;
    return;
  }
  u = (struct user*) g_malloc(sizeof(struct user));
  u->name = g_strdup(name);
  u->jid = g_strdup(jid);
  u->group = g_strdup(group);
  u->description = g_strdup(description);
  u->subscription = g_strdup(subscription);
  u->ask = g_strdup(ask);
  u->status = status;
  u->type = type;
  u->pending_event = NOTIFY_NOEVENT;
  users_list = g_list_insert_sorted(users_list,(gpointer)u, sortfunc);
}


/* this one adds virtual users to the roster, these are used by tleenx2
 * to notify about various events e.g. new mail/web message arrival etc */
void add_virtualusers()
{
	gchar *name = NULL, *jid = NULL, *subscription = NULL;
	
	/* web message */
	name = g_strdup("Bramka WWW");
	jid = g_strdup("web-gateway@tleenx");
	subscription  = g_strdup("both");
	add_user(name, jid, "", subscription, "", "",
			TLEN_STATUS_AVAILABLE, USER_VIRTUAL);
	g_free(name);
	g_free(jid);
	g_free(subscription);

	/* new mail @o2.pl */
	name = g_strdup("Poczta o2.pl");
	jid = g_strdup("new-mail-info@tleenx");
	subscription  = g_strdup("both");
	add_user(name, jid, "", subscription, "", "",
			TLEN_STATUS_AVAILABLE, USER_VIRTUAL);
	g_free(name);
	g_free(jid);
	g_free(subscription);

	/* subscription request */
	name = g_strdup("Subscription req.");
	jid = g_strdup("subscription-req@tleenx");
	subscription  = g_strdup("both");
	add_user(name, jid, "", subscription, "", "",
			TLEN_STATUS_AVAILABLE, USER_VIRTUAL);
	g_free(name);
	g_free(jid);
	g_free(subscription);

}
