// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "normalize.h"

namespace Torch {

void MSTDVNormalize(real **tab, real *mean_buff, real *std_buff, int n_ex, int n_dim)
{
  for(int d = 0; d < n_dim; d++)
  {
    real std_buff_  = 0;
    real mean_buff_ = 0;
    for(int i = 0; i < n_ex; i++)
    {
      real z = tab[i][d];
      std_buff_  += z*z;
      mean_buff_ += z;
    }
    std_buff_  /= (real)n_ex;
    mean_buff_ /= (real)n_ex;
    std_buff_  -= mean_buff_*mean_buff_;
    if(std_buff_ <= 0)
    {
      warning("normalize: a column has a null stdv");
      std_buff_ = 1;
    }
    std_buff[d]  = sqrt(std_buff_);
    mean_buff[d] = mean_buff_;
  }
}

void MSTDVSparseNormalize(sreal **tab, real *mean_buff, real *std_buff, int n_ex, int n_dim)
{
  for(int d = 0; d < n_dim; d++)
  {
    mean_buff[d] = 0;
    std_buff[d] = 0;
  }

  for(int i = 0; i < n_ex; i++)
  {
    sreal *z = tab[i];
    while(z->index > 0)
    {
      real zz = z->value;
      int d = z->index;

      std_buff[d]  += zz*zz;
      mean_buff[d] += zz;

      z++;
    }
  }

  for(int d = 0; d < n_dim; d++)
  {
    std_buff[d]  /= (real)n_ex;
    mean_buff[d] /= (real)n_ex;
    std_buff[d]  -= mean_buff[d]*mean_buff[d];
    if(std_buff[d] <= 0)
    {
      warning("normalize: a column has a null stdv");
      std_buff[d] = 1;
    }
    else
      std_buff[d]  = sqrt(std_buff[d]);
  }
}

}

