# -*- coding: utf-8 -*-
#
# Copyright (C) 2007-2018 Edgewall Software
# Copyright (C) 2007 Christian Boos <cboos@edgewall.org>
# All rights reserved.
#
# This software is licensed as described in the file COPYING, which
# you should have received as part of this distribution. The terms
# are also available at http://trac.edgewall.com/license.html.
#
# This software consists of voluntary contributions made by many
# individuals. For the exact contribution history, see the revision
# history and logs, available at http://trac.edgewall.org/.

"""Example macro."""

from trac.util.translation import cleandoc_
from trac.wiki.macros import WikiMacroBase

revision = "$Rev: 16771 $"
url = "$URL: https://svn.edgewall.org/repos/trac/branches/1.2-stable/sample-plugins/HelloWorld.py $"


class HelloWorldMacro(WikiMacroBase):
    _description = cleandoc_(
    """Simple HelloWorld macro.

    Note that the name of the class is meaningful:
     - it must end with "Macro"
     - what comes before "Macro" ends up being the macro name

    The documentation of the class (i.e. what you're reading)
    will become the documentation of the macro, as shown by
    the !MacroList macro (usually used in the WikiMacros page).
    """)

    def expand_macro(self, formatter, name, content, args=None):
        """Return some output that will be displayed in the Wiki content.

        `name` is the actual name of the macro (no surprise, here it'll be
        `'HelloWorld'`),
        `content` is the text enclosed in parenthesis at the call of the
          macro. Note that if there are ''no'' parenthesis (like in, e.g.
          [[HelloWorld]]), then `content` is `None`.
        `args` will contain a dictionary of arguments when called using the
          Wiki processor syntax and will be `None` if called using the
          macro syntax.
        """
        return 'Hello World, content = ' + unicode(content)

    # Note that there's no need to HTML escape the returned data,
    # as the template engine (Genshi) will do it for us.
