/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or                                                        
    modify it under the terms of the GNU General Public License                                                          
    version 2 as published by the Free Software Foundation.

*/

#include <header.h>

struct threadpipe *tpipe;

struct threadpipe *init_threadpipe(){
	struct threadpipe *tpipe;
    int fds[2];
	
	tpipe=g_new0(struct threadpipe, 1);
    if (pipe(fds)) internal("Can't create thread pipe\n");
    tpipe->threadpipe_read=fds[0];
    tpipe->threadpipe_write=fds[1];
    set_handlers(tpipe->threadpipe_read, threadpipe_read_handler, NULL, NULL, CBA0);
    tpipe->threadpipe_rdbuf=g_string_sized_new(100);        
    return tpipe;
}

void free_threadpipe(struct threadpipe *tpipe){
	g_string_free(tpipe->threadpipe_rdbuf, TRUE);
	close(tpipe->threadpipe_read);    
	close(tpipe->threadpipe_write);    
	g_free(tpipe);
}


void threadpipe_read_handler(union cba_t cba){
    char s[1030];
    int ret,err;
    gchar *d, *line;

    ret=read(tpipe->threadpipe_read, s, 1024);
    err=errno;
    if (ret<=0){
        dbg("read error %d %d\n", ret, err);
    }
    s[ret]='\0';
/*    dbg("thrp_r '%s' \n", s);*/
    g_string_append(tpipe->threadpipe_rdbuf, s);
	/*dbg("rdbuf='%s'\n", tpipe->threadpipe_rdbuf->str);*/
    while(1){
        d=index(tpipe->threadpipe_rdbuf->str, '\n');
        if (!d) break;
        line=g_strndup(tpipe->threadpipe_rdbuf->str, d - tpipe->threadpipe_rdbuf->str+1);
		line[d - tpipe->threadpipe_rdbuf->str]='\0'; 
		
        g_string_erase(tpipe->threadpipe_rdbuf, 0, d - tpipe->threadpipe_rdbuf->str+1);
        if (strlen(line)>0) threadpipe_rel_read(line);
        g_free(line);
    }
}

void threadpipe_rel_read(gchar *line){
    gchar **items;
    
/*    dbg("threadpipe_rel_read(%s)\n", line);*/
    items=g_strsplit(line, ";", 0);
    if (!items[0]) internal("bad format");
    
    if (strcmp(items[0], "ST")==0){
        check_autosave();
        redraw_stats(aband);
        recalc_statsfifo(aband);
        redraw_later();
        goto x;
    }
	if (strcmp(items[0], "CWQS")==0){
        redraw_later();
		goto x;
	}
	
	if (!items[1]) internal("bad format 2");
	
	if (strcmp(items[0], "SSBP")==0){
        ssbd_play_read_handler(ssbd, items[1]);
		goto x;
	}
	if (strcmp(items[0], "SSBR")==0){
        ssbd_rec_read_handler(ssbd, items[1]);
		goto x;
	}
	if (strcmp(items[0], "CW")==0){
		cwdaemon_read_handler(cwda, items[1]);
		goto x;
	}
x:;
    g_strfreev(items);
}
