//-*-c++-*-
/*
 Author: Sophie BARDET & Alexandre BURNETT
 Email : sophie.bardet@gmail.com, aburnett397@gmail.com
 Last modification : 14/05/2005
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/

//============================================================
void SuperGraphDeco::clear(){
  graph_component->clear();
}

//============================================================
SuperGraph *SuperGraphDeco::addSubGraph(SelectionProxy *selectionProxy){
  return graph_component->addSubGraph(selectionProxy);
}

//============================================================
void SuperGraphDeco::delSubGraph(SuperGraph * s){
  graph_component->delSubGraph(s);
}

//============================================================
void SuperGraphDeco::delAllSubGraphs(SuperGraph *s){
  graph_component->delAllSubGraphs(s);
}

//============================================================
SuperGraph* SuperGraphDeco::getFather()const{
  return graph_component->getFather();
}

//============================================================
void SuperGraphDeco::setFather(SuperGraph* s){
  graph_component->setFather(s);
}

//============================================================
SuperGraph* SuperGraphDeco::getRoot() const{
  return graph_component->getRoot();
}

//============================================================
Iterator<SuperGraph *> * SuperGraphDeco::getSubGraphs() const{
  return graph_component->getSubGraphs();
}

//============================================================
node SuperGraphDeco::source(const edge e)const{
  return graph_component->source(e);
}

//============================================================
node SuperGraphDeco::target(const edge e)const {
  return graph_component->target(e);
}

//============================================================
node SuperGraphDeco::opposite(const edge e, const node n)const {
  return graph_component->opposite(e,n);
}

//============================================================
edge SuperGraphDeco::existEdge(const node n, const node m)const {
  return graph_component->existEdge(n,m);
}

//============================================================
void SuperGraphDeco::reverse(const edge e){
  graph_component->reverse(e);
}

//============================================================
unsigned int SuperGraphDeco::deg(const node n)const {
  return graph_component->deg(n);
}

//============================================================
unsigned int SuperGraphDeco::indeg(const node n)const {
  return graph_component->indeg(n);
}

//============================================================
unsigned int SuperGraphDeco::outdeg(const node n)const {
  return graph_component->outdeg(n);
}

//============================================================
node SuperGraphDeco::getOneNode() const{
  return graph_component->getOneNode();
}

//============================================================
node SuperGraphDeco::getInNode(const node n,unsigned int i)const{
  return graph_component->getInNode(n,i);
}

//============================================================
node SuperGraphDeco::getOutNode(const node n,unsigned int i) const{
  return graph_component->getOutNode(n,i);
}

edge SuperGraphDeco::getOneEdge() const{
  return graph_component->getOneEdge();
}

//============================================================
unsigned int SuperGraphDeco::numberOfNodes()const{
  return graph_component->numberOfNodes();
}

//============================================================
unsigned int SuperGraphDeco::numberOfEdges()const{
  return graph_component->numberOfEdges();
}

//============================================================
bool SuperGraphDeco::isElement(const node n) const{
  return graph_component->isElement(n);
}

//============================================================
bool SuperGraphDeco::isElement(const edge e) const{
  return graph_component->isElement(e);
}

//============================================================
node SuperGraphDeco::addNode(){
  return graph_component->addNode();
}

//============================================================
void SuperGraphDeco::addNode(const node n){
  graph_component->addNode(n);
}

//============================================================
edge SuperGraphDeco::addEdge(const node n, const node n2){
  return graph_component->addEdge(n, n2);
}

//============================================================
void SuperGraphDeco::addEdge(const edge e){
  graph_component->addEdge(e);
}

//============================================================
void SuperGraphDeco::delNode(const node n){
  graph_component->delNode(n);
}

//============================================================ 
void SuperGraphDeco::delAllNode(const node n){
  graph_component->delAllNode(n);
}

//============================================================
void SuperGraphDeco::delEdge(const edge e){
  graph_component->delEdge(e);
}

//============================================================
void SuperGraphDeco::delAllEdge(const edge e){
  graph_component->delAllEdge(e);
}

//============================================================
void SuperGraphDeco::setEdgeOrder(const node n,const std::vector<edge> & s){
  graph_component->setEdgeOrder(n,s);
}

void SuperGraphDeco::swapEdgeOrder(const node n ,const edge e1, const edge e2){
  graph_component->swapEdgeOrder(n, e1, e2);
} 

//============================================================
Iterator<node>* SuperGraphDeco::getNodes() const {
  return graph_component->getNodes();
}

//============================================================
Iterator<node>* SuperGraphDeco::getInNodes(const node n) const {
  return graph_component->getInNodes(n);
}

//============================================================
Iterator<node>* SuperGraphDeco::getOutNodes(const node n) const {
  return graph_component->getOutNodes(n);
}

//============================================================
Iterator<node>* SuperGraphDeco::getInOutNodes(const node n) const {
  return graph_component->getInOutNodes(n);
}

//============================================================
Iterator<edge>* SuperGraphDeco::getEdges() const {
  return graph_component->getEdges();
}

//============================================================
Iterator<edge>* SuperGraphDeco::getOutEdges(const node n) const {
  return graph_component->getOutEdges(n);
}

//============================================================
Iterator<edge>* SuperGraphDeco::getInOutEdges(const node n) const {
  return graph_component->getInOutEdges(n);
}

//============================================================
Iterator<edge>* SuperGraphDeco::getInEdges(const node n) const {
  return graph_component->getInEdges(n);
}

//============================================================
DataSet & SuperGraphDeco::getAttributes(){
  return graph_component->getAttributes();
}

//============================================================
PProxy* SuperGraphDeco::getProperty(const std::string &name){
  return graph_component->getProperty(name);
}

//============================================================ 
bool SuperGraphDeco::existProperty(const std::string&name){
  return graph_component->existProperty(name);
}

//============================================================
bool SuperGraphDeco::existLocalProperty(const std::string&name){
  return graph_component->existLocalProperty(name) ;
}

//============================================================
void SuperGraphDeco::delLocalProperty(const std::string&name){
  return graph_component->delLocalProperty(name);
}

//============================================================
Iterator<std::string>* SuperGraphDeco::getLocalProperties(){
  return graph_component->getLocalProperties();
}

//============================================================
Iterator<std::string>* SuperGraphDeco::getInheritedProperties(){
  return graph_component->getInheritedProperties();
}

//============================================================
Iterator<std::string>* SuperGraphDeco::getProperties(){
  return graph_component->getProperties();
}
