#include <tulip/SuperGraph.h>
#include <tulip/GlGraphWidget.h>
#include "ElementInfoToolTip.h"

using namespace tlp;


ElementInfoToolTip::ElementInfoToolTip(QWidget* parent,const char* name,GlGraphWidget *glWidget) :
  QToolTip(parent),
  glWidget(glWidget) {
}

void ElementInfoToolTip::maybeTip( const QPoint & p ) {
  node tmpNode;
  edge tmpEdge;
  ElementType type;
  QString tmp;
  if (glWidget->doSelect(p.x(), p.y(), type, tmpNode, tmpEdge)) {
    switch(type) {
    case NODE: 
      tip(QRect(p.x()-2,p.y()-2,4,4),QString("node: ")+tmp.setNum(tmpNode.id)); 
      break;
    case EDGE: 
      tip(QRect(p.x()-2,p.y()-2,4,4),QString("edge: ")+tmp.setNum(tmpEdge.id));
      break;
    }
  }
}
