SET(CPACK_COMPONENT_GROUP_THIRDPARTY_DESCRIPTION "Thirdparty libraries.")
SET(CPACK_COMPONENT_GROUP_LIBRARIES_DESCRIPTION "Tulip framework dynamic libraries.")
SET(CPACK_COMPONENT_GROUP_HEADERS_DESCRIPTION "Tulip framework C++ headers.")
SET(CPACK_COMPONENT_GROUP_SOFTWARE_DESCRIPTION "Tulip softwares.")
SET(CPACK_COMPONENT_GROUP_PLUGINS_DESCRIPTION "Tulip base plugins set.")
SET(CPACK_COMPONENT_GROUP_EXTRAS_DESCRIPTION "Tulip extra files and documentation.")

#thirdparty
DEFINE_COMPONENT(ftgl "FTGL" "A library to render freetype fonts in openGL scenes." ""  ${THIRDPARTY_GROUP_NAME})
DEFINE_COMPONENT(sip "SIP library" "A library providing python bindings for C++." ""  ${THIRDPARTY_GROUP_NAME})

# library/tulip
DEFINE_COMPONENT(libtulip "Core library" "Tulip core library provides a framework for huge graph manipulation." ""  ${LIBS_GROUP_NAME})
DEFINE_COMPONENT(libtulip_dev "Core library - Development files" "Tulip core library provides a framework for huge graph manipulation." "libtulip"  ${HEADERS_GROUP_NAME})

# library/tulip-ogl
DEFINE_COMPONENT(libtulip_ogl "OpenGL library" "Tulip OpenGL provides a library for 3D visualization of graphs created with the Tulip core library. " "libtulip;ftgl" ${LIBS_GROUP_NAME})
DEFINE_COMPONENT(libtulip_ogl_dev "OpenGL libary - Development files" "Tulip OpenGL provides a library for for 3D visualization of graphs created with the Tulip core library." "libtulip_dev;libtulip_ogl"  ${HEADERS_GROUP_NAME})

#library/tulip-qt
DEFINE_COMPONENT(libtulip_qt "Qt library" "Tulip Qt provides a library for the Qt4 framework helping the design of graphical interfaces to integrate Tulip 3D visualizations into a Qt application." "libtulip;libtulip_ogl"  ${LIBS_GROUP_NAME})
DEFINE_COMPONENT(libtulip_qt_dev "Qt library - Development files" "Tulip Qt provides a library for the Qt4 framework helping the design of graphical interfaces to integrate Tulip 3D visualizations into a Qt application." "libtulip_qt;libtulip_ogl_dev" ${HEADERS_GROUP_NAME})

#Extra features
DEFINE_COMPONENT(tulip_ogdf "OGDF library bridge" "Tulip OGDF provides a bridge to use the powerful OGDF library (Open Graph Drawing Framework) inside Tulip." "libtulip" ${LIBS_GROUP_NAME})
DEFINE_COMPONENT(tulip_python "Python bindings" "Python bindings for Tulip." "sip"  ${LIBS_GROUP_NAME})

# plugins
DEFINE_COMPONENT(tulip_plugins "Tulip Base plugins" "Base Tulip Plugins from trunk" "libtulip;libtulip_ogl;libtulip_qt"  ${PLUGINS_GROUP_NAME})
DEFINE_COMPONENT(tulip "Tulip software" "The main Tulip software. Provides a complete interface and a set of tools to easily create, manage and visualize huge graphs in 3D scenes." "libtulip;libtulip_ogl;libtulip_qt;tulip_plugins" ${SOFTWARE_GROUP_NAME})

# doc/
# must be always present because it may be installed by hand
# even it is not generated
DEFINE_COMPONENT(tulip_doc "Framework documentation" "Manuals and doxygen for the Tulip framework." "tulip" ${EXTRAS_GROUP_NAME})

IF(SPHINX_FOUND)
DEFINE_COMPONENT(tulip_python_doc "Python bindings documentation" "Manual and API description for the Tulip Python bindings." "tulip_python"  ${EXTRAS_GROUP_NAME})
ENDIF(SPHINX_FOUND)

IF(LINUX)
  SET(META_DEPS "ftgl;gzstream;sip;libtulip;libtulip_ogl;libtulip_qt;tulip;tulip_plugins")
  # meta package (Linux only)
  IF(GENERATE_DOC)
    SET(META_DEPS "${META_DEPS};tulip-doc")
  ENDIF()
  DEFINE_COMPONENT(tulip_all "Meta package" "Meta package containing tulip application, libraries, documentation and base plugins" "${META_DEPS}" "" ${EXTRAS_GROUP_NAME})

  SET(CPACK_DEBIAN_EXCLUDE_COMPONENTS "ftgl;sip;tulip_all")
  
  SET(CPACK_UBUNTU_DISTRIBUTION_RELEASES lucid maverick natty oneiric)

  SET(CPACK_UBUNTU_COMMON_BUILD_DEPENDS "libgl1-mesa-dev;libglu1-mesa-dev;libglew1.5-dev;libftgl-dev;libjpeg62-dev;libpng12-dev;libxml2-dev;libqt4-dev;libqt4-opengl-dev;libqtwebkit-dev;zlib1g-dev;libstdc++6;python-dev;python-sip-dev;doxygen;gcj-jdk;libxml-commons-resolver1.1-java-gcj;qt4-dev-tools;python-sphinx;docbook-xsl;graphviz;texlive-font-utils")

  SET(CPACK_COMPONENT_LIBTULIP_UBUNTU_COMMON_DEPENDS "")
  SET(CPACK_COMPONENT_LIBTULIP_DEV_UBUNTU_COMMON_DEPENDS "zlib1g-dev, libc6-dev")
  SET(CPACK_COMPONENT_LIBTULIP_OGL_UBUNTU_COMMON_DEPENDS "")
  SET(CPACK_COMPONENT_LIBTULIP_OGL_DEV_UBUNTU_COMMON_DEPENDS "libtulip-dev, libgl1-mesa-dev, libglu1-mesa-dev, libglew1.5-dev, libftgl-dev, libjpeg62-dev, libpng12-dev, libxml2-dev")
  SET(CPACK_COMPONENT_LIBTULIP_QT_UBUNTU_COMMON_DEPENDS "")
  SET(CPACK_COMPONENT_LIBTULIP_QT_DEV_UBUNTU_COMMON_DEPENDS "libtulip-ogl-dev, libqt4-dev, libqt4-opengl-dev")
  SET(CPACK_COMPONENT_TULIP_OGDF_UBUNTU_COMMON_DEPENDS "") 
  SET(CPACK_COMPONENT_TULIP_PYTHON_UBUNTU_COMMON_DEPENDS "tulip, python-sip")
  SET(CPACK_COMPONENT_TULIP_PLUGINS_UBUNTU_COMMON_DEPENDS "tulip")
  SET(CPACK_COMPONENT_TULIP_UBUNTU_COMMON_DEPENDS "tulip-plugins")
  SET(CPACK_COMPONENT_TULIP_DOC_UBUNTU_COMMON_DEPENDS "tulip, qt4-dev-tools")
  SET(CPACK_COMPONENT_TULIP_PYTHON_DOC_UBUNTU_COMMON_DEPENDS "tulip-python")  

  SET(CPACK_LUCID_BUILD_DEPENDS ${CPACK_UBUNTU_COMMON_BUILD_DEPENDS})
  SET(CPACK_MAVERICK_BUILD_DEPENDS ${CPACK_UBUNTU_COMMON_BUILD_DEPENDS})
  SET(CPACK_NATTY_BUILD_DEPENDS ${CPACK_UBUNTU_COMMON_BUILD_DEPENDS})
  SET(CPACK_ONEIRIC_BUILD_DEPENDS ${CPACK_UBUNTU_COMMON_BUILD_DEPENDS})

  SET(CPACK_COMPONENT_LIBTULIP_LUCID_DEPENDS ${CPACK_COMPONENT_LIBTULIP_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_LIBTULIP_DEV_LUCID_DEPENDS ${CPACK_COMPONENT_LIBTULIP_DEV_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_LIBTULIP_OGL_LUCID_DEPENDS ${CPACK_COMPONENT_LIBTULIP_OGL_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_LIBTULIP_OGL_DEV_LUCID_DEPENDS ${CPACK_COMPONENT_LIBTULIP_OGL_DEV_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_LIBTULIP_QT_LUCID_DEPENDS ${CPACK_COMPONENT_LIBTULIP_QT_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_LIBTULIP_QT_DEV_LUCID_DEPENDS ${CPACK_COMPONENT_LIBTULIP_QT_DEV_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_TULIP_OGDF_LUCID_DEPENDS ${CPACK_COMPONENT_LIBTULIP_OGDF_UBUNTU_COMMON_DEPENDS}) 
  SET(CPACK_COMPONENT_TULIP_PYTHON_LUCID_DEPENDS ${CPACK_COMPONENT_TULIP_PYTHON_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_TULIP_PLUGINS_LUCID_DEPENDS ${CPACK_COMPONENT_TULIP_PLUGINS_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_TULIP_LUCID_DEPENDS ${CPACK_COMPONENT_TULIP_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_TULIP_DOC_LUCID_DEPENDS ${CPACK_COMPONENT_TULIP_DOC_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_TULIP_PYTHON_DOC_LUCID_DEPENDS ${CPACK_COMPONENT_TULIP_PYTHON_DOC_UBUNTU_COMMON_DEPENDS})

  SET(CPACK_COMPONENT_LIBTULIP_MAVERICK_DEPENDS ${CPACK_COMPONENT_LIBTULIP_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_LIBTULIP_DEV_MAVERICK_DEPENDS ${CPACK_COMPONENT_LIBTULIP_DEV_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_LIBTULIP_OGL_MAVERICK_DEPENDS ${CPACK_COMPONENT_LIBTULIP_OGL_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_LIBTULIP_OGL_DEV_MAVERICK_DEPENDS ${CPACK_COMPONENT_LIBTULIP_OGL_DEV_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_LIBTULIP_QT_MAVERICK_DEPENDS ${CPACK_COMPONENT_LIBTULIP_QT_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_LIBTULIP_QT_DEV_MAVERICK_DEPENDS ${CPACK_COMPONENT_LIBTULIP_QT_DEV_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_TULIP_OGDF_MAVERICK_DEPENDS ${CPACK_COMPONENT_LIBTULIP_OGDF_UBUNTU_COMMON_DEPENDS}) 
  SET(CPACK_COMPONENT_TULIP_PYTHON_MAVERICK_DEPENDS ${CPACK_COMPONENT_TULIP_PYTHON_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_TULIP_PLUGINS_MAVERICK_DEPENDS ${CPACK_COMPONENT_TULIP_PLUGINS_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_TULIP_MAVERICK_DEPENDS ${CPACK_COMPONENT_TULIP_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_TULIP_DOC_MAVERICK_DEPENDS ${CPACK_COMPONENT_TULIP_DOC_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_TULIP_PYTHON_DOC_MAVERICK_DEPENDS ${CPACK_COMPONENT_TULIP_PYTHON_DOC_UBUNTU_COMMON_DEPENDS})

  SET(CPACK_COMPONENT_LIBTULIP_NATTY_DEPENDS ${CPACK_COMPONENT_LIBTULIP_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_LIBTULIP_DEV_NATTY_DEPENDS ${CPACK_COMPONENT_LIBTULIP_DEV_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_LIBTULIP_OGL_NATTY_DEPENDS ${CPACK_COMPONENT_LIBTULIP_OGL_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_LIBTULIP_OGL_DEV_NATTY_DEPENDS ${CPACK_COMPONENT_LIBTULIP_OGL_DEV_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_LIBTULIP_QT_NATTY_DEPENDS ${CPACK_COMPONENT_LIBTULIP_QT_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_LIBTULIP_QT_DEV_NATTY_DEPENDS ${CPACK_COMPONENT_LIBTULIP_QT_DEV_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_TULIP_OGDF_NATTY_DEPENDS ${CPACK_COMPONENT_LIBTULIP_OGDF_UBUNTU_COMMON_DEPENDS}) 
  SET(CPACK_COMPONENT_TULIP_PYTHON_NATTY_DEPENDS ${CPACK_COMPONENT_TULIP_PYTHON_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_TULIP_PLUGINS_NATTY_DEPENDS ${CPACK_COMPONENT_TULIP_PLUGINS_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_TULIP_NATTY_DEPENDS ${CPACK_COMPONENT_TULIP_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_TULIP_DOC_NATTY_DEPENDS ${CPACK_COMPONENT_TULIP_DOC_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_TULIP_PYTHON_DOC_NATTY_DEPENDS ${CPACK_COMPONENT_TULIP_PYTHON_DOC_UBUNTU_COMMON_DEPENDS})

  SET(CPACK_COMPONENT_LIBTULIP_ONEIRIC_DEPENDS ${CPACK_COMPONENT_LIBTULIP_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_LIBTULIP_DEV_ONEIRIC_DEPENDS ${CPACK_COMPONENT_LIBTULIP_DEV_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_LIBTULIP_OGL_ONEIRIC_DEPENDS ${CPACK_COMPONENT_LIBTULIP_OGL_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_LIBTULIP_OGL_DEV_ONEIRIC_DEPENDS ${CPACK_COMPONENT_LIBTULIP_OGL_DEV_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_LIBTULIP_QT_ONEIRIC_DEPENDS ${CPACK_COMPONENT_LIBTULIP_QT_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_LIBTULIP_QT_DEV_ONEIRIC_DEPENDS ${CPACK_COMPONENT_LIBTULIP_QT_DEV_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_TULIP_OGDF_ONEIRIC_DEPENDS ${CPACK_COMPONENT_LIBTULIP_OGDF_UBUNTU_COMMON_DEPENDS}) 
  SET(CPACK_COMPONENT_TULIP_PYTHON_ONEIRIC_DEPENDS ${CPACK_COMPONENT_TULIP_PYTHON_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_TULIP_PLUGINS_ONEIRIC_DEPENDS ${CPACK_COMPONENT_TULIP_PLUGINS_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_TULIP_ONEIRIC_DEPENDS ${CPACK_COMPONENT_TULIP_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_TULIP_DOC_ONEIRIC_DEPENDS ${CPACK_COMPONENT_TULIP_DOC_UBUNTU_COMMON_DEPENDS})
  SET(CPACK_COMPONENT_TULIP_PYTHON_DOC_ONEIRIC_DEPENDS ${CPACK_COMPONENT_TULIP_PYTHON_DOC_UBUNTU_COMMON_DEPENDS})
  

ENDIF()
