#Boa:Frame:TunaPie
#TunaPie (c)2005-2006 James Stone. Released under the GNU GPL.
#
#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
#
#Written using Boa-Constructor.
#http://boa-constructor.sourceforge.net/
#
#Version 0.4.9 28/11/06

import wxversion
wxversion.select("2.6")
import wx
from wx.lib.anchors import LayoutAnchors
import wx.lib.stattext
import os
import urllib
import time
import tuner
import getpass
import thread
import AboutTuner
import TunerPrefs
import TunerInfoDialog
import RecordTime
import RecordQueue
import select
import time
import socket
#import sys

def create(parent):
    return TunaPie(parent)

[wxID_TUNAPIE, wxID_TUNAPIEADDBUTTON, wxID_TUNAPIEBITRATECTRL, 
 wxID_TUNAPIEDELETEBUTTON, wxID_TUNAPIEDOWNBUTTON, wxID_TUNAPIEFAVORITES, 
 wxID_TUNAPIEGENREBOX, wxID_TUNAPIEGENRECTRL, wxID_TUNAPIEGENSTATICTEXT1, 
 wxID_TUNAPIEGENSTATICTEXT2, wxID_TUNAPIEGENSTATICTEXT3, 
 wxID_TUNAPIEGENSTATICTEXT4, wxID_TUNAPIEGOBUTTON, wxID_TUNAPIEINFOBUTTON, 
 wxID_TUNAPIELISTBOX1, wxID_TUNAPIELISTENERSCTRL, wxID_TUNAPIEPLAYBUTTON, 
 wxID_TUNAPIEPLAYINGCTRL, wxID_TUNAPIERADIORADIO, wxID_TUNAPIERECORDBUTTON, 
 wxID_TUNAPIESORT, wxID_TUNAPIESTATICBOX1, wxID_TUNAPIESTATICBOX2, 
 wxID_TUNAPIESTATICBOX3, wxID_TUNAPIESTATICBOX4, wxID_TUNAPIESTATICBOX5, 
 wxID_TUNAPIESTATICBOX6, wxID_TUNAPIESTATUSTEXT, wxID_TUNAPIESTOPBUTTON, 
 wxID_TUNAPIETEXTCTRL1, wxID_TUNAPIETVRADIO, wxID_TUNAPIEUPBUTTON, 
] = [wx.NewId() for _init_ctrls in range(32)]

[wxID_TUNAPIEMENUFILEPREF, wxID_TUNAPIEMENUFILEQUIT, 
 wxID_TUNAPIEMENUFILERECORDQUEUE, wxID_TUNAPIEMENUFILERELOAD, 
] = [wx.NewId() for _init_coll_menufile_Items in range(4)]

[wxID_TUNAPIEMANCONTEXTADD, wxID_TUNAPIEMANCONTEXTPLAY, 
] = [wx.NewId() for _init_coll_mancontext_Items in range(2)]

[wxID_TUNAPIEFAVCONTEXTDELETE, wxID_TUNAPIEFAVCONTEXTPLAY, 
] = [wx.NewId() for _init_coll_favcontext_Items in range(2)]

[wxID_TUNAPIEHELPMENUABOUT] = [wx.NewId() for _init_coll_helpmenu_Items in range(1)]

class TunaPie(wx.Frame):
    def _init_coll_menuBar1_Menus(self, parent):
        # generated method, don't edit

        parent.Append(menu=self.menufile, title='File')
        parent.Append(menu=self.helpmenu, title='Help')

    def _init_coll_helpmenu_Items(self, parent):
        # generated method, don't edit

        parent.Append(help='', id=wxID_TUNAPIEHELPMENUABOUT,
              kind=wx.ITEM_NORMAL, text='About')
        self.Bind(wx.EVT_MENU, self.OnHelpmenuAboutMenu,
              id=wxID_TUNAPIEHELPMENUABOUT)

    def _init_coll_menufile_Items(self, parent):
        # generated method, don't edit

        parent.Append(help='', id=wxID_TUNAPIEMENUFILEPREF, kind=wx.ITEM_NORMAL,
              text='Preferences')
        parent.Append(help='', id=wxID_TUNAPIEMENUFILERECORDQUEUE,
              kind=wx.ITEM_NORMAL, text=u'Record Queue')
        parent.Append(help='', id=wxID_TUNAPIEMENUFILERELOAD,
              kind=wx.ITEM_NORMAL, text=u'Reload')
        parent.Append(help=u'', id=wxID_TUNAPIEMENUFILEQUIT,
              kind=wx.ITEM_NORMAL, text='Quit')
        self.Bind(wx.EVT_MENU, self.OnMenufileQuitMenu,
              id=wxID_TUNAPIEMENUFILEQUIT)
        self.Bind(wx.EVT_MENU, self.OnMenufilePrefMenu,
              id=wxID_TUNAPIEMENUFILEPREF)
        self.Bind(wx.EVT_MENU, self.OnMenufileRecordqueueMenu,
              id=wxID_TUNAPIEMENUFILERECORDQUEUE)
        self.Bind(wx.EVT_MENU, self.OnMenufileReloadMenu,
              id=wxID_TUNAPIEMENUFILERELOAD)

    def _init_utils(self):
        # generated method, don't edit
        self.menufile = wx.Menu(title='')

        self.helpmenu = wx.Menu(title='')

        self.menuBar1 = wx.MenuBar()
        self.menuBar1.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))

        self._init_coll_menufile_Items(self.menufile)
        self._init_coll_helpmenu_Items(self.helpmenu)
        self._init_coll_menuBar1_Menus(self.menuBar1)

    def _init_ctrls(self, prnt):
        # generated method, don't edit
        wx.Frame.__init__(self, id=wxID_TUNAPIE, name='TunaPie', parent=prnt,
              pos=wx.Point(120, 120), size=wx.Size(770, 410),
              style=wx.DEFAULT_FRAME_STYLE, title='TunaPie')
        self._init_utils()
        self.SetClientSize(wx.Size(770, 410))
        self.SetMenuBar(self.menuBar1)
        self.SetBackgroundColour(wx.Colour(246, 246, 246))
        self.SetBackgroundStyle(wx.BG_STYLE_SYSTEM)
        self.SetThemeEnabled(True)
        self.SetIcon(wx.Icon('tplogo.ico',wx.BITMAP_TYPE_ICO))
        self.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.NORMAL, False,u'Sans'))
        self.SetAutoLayout(True)
        self.SetMinSize(wx.Size(770, 410))
        self.Bind(wx.EVT_CLOSE, self.OnTunaPieClose)

        self.listBox1 = wx.ListBox(choices=[], id=wxID_TUNAPIELISTBOX1,
              name='listBox1', parent=self, pos=wx.Point(272, 40),
              size=wx.Size(312, 280), style=wx.LB_EXTENDED | wx.LB_SINGLE)
        self.listBox1.SetBackgroundColour(wx.Colour(255, 255, 255))
        self.listBox1.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.listBox1.SetThemeEnabled(True)
        self.listBox1.SetConstraints(LayoutAnchors(self.listBox1, True, True,
              False, True))
        self.listBox1.SetAutoLayout(True)
        self.listBox1.Bind(wx.EVT_LISTBOX, self.OnListBox1Listbox,
              id=wxID_TUNAPIELISTBOX1)
        self.listBox1.Bind(wx.EVT_LISTBOX_DCLICK, self.OnListBox1ListboxDclick,
              id=wxID_TUNAPIELISTBOX1)
        self.listBox1.Bind(wx.EVT_KEY_UP, self.OnListBox1KeyUp)

        self.sort = wx.Choice(choices=['Listeners', 'Name', 'Genre', 'Bitrate'],
              id=wxID_TUNAPIESORT, name='sort', parent=self, pos=wx.Point(96,
              118), size=wx.Size(136, 24), style=0)
        self.sort.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.sort.SetSelection(-1)
        self.sort.SetThemeEnabled(True)
        self.sort.SetConstraints(LayoutAnchors(self.sort, True, True, False,
              False))
        self.sort.SetAutoLayout(True)
        self.sort.SetMaxSize(wx.Size(136, 24))
        self.sort.Bind(wx.EVT_CHOICE, self.OnSortChoice, id=wxID_TUNAPIESORT)

        self.genStaticText1 = wx.lib.stattext.GenStaticText(ID=wxID_TUNAPIEGENSTATICTEXT1,
              label='Selection:', name='genStaticText1', parent=self,
              pos=wx.Point(16, 66), size=wx.Size(56, 13), style=0)
        self.genStaticText1.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.genStaticText1.SetBackgroundColour(wx.Colour(246, 246, 246))
        self.genStaticText1.SetBackgroundStyle(wx.BG_STYLE_SYSTEM)
        self.genStaticText1.SetThemeEnabled(True)
        self.genStaticText1.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.genStaticText1.SetConstraints(LayoutAnchors(self.genStaticText1,
              True, True, False, False))
        self.genStaticText1.SetAutoLayout(True)
        self.genStaticText1.SetMaxSize(wx.Size(56, 13))

        self.genStaticText2 = wx.lib.stattext.GenStaticText(ID=wxID_TUNAPIEGENSTATICTEXT2,
              label='Sort By:', name='genStaticText2', parent=self,
              pos=wx.Point(16, 116), size=wx.Size(45, 13), style=0)
        self.genStaticText2.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.genStaticText2.SetBackgroundColour(wx.Colour(233, 233, 244))
        self.genStaticText2.SetBackgroundStyle(wx.BG_STYLE_SYSTEM)
        self.genStaticText2.SetThemeEnabled(True)
        self.genStaticText2.SetMaxSize(wx.Size(45, 13))
        self.genStaticText2.SetConstraints(LayoutAnchors(self.genStaticText2,
              True, True, False, False))
        self.genStaticText2.SetAutoLayout(True)

        self.staticBox1 = wx.StaticBox(id=wxID_TUNAPIESTATICBOX1, label='Genre',
              name='staticBox1', parent=self, pos=wx.Point(16, 144),
              size=wx.Size(240, 48), style=0)
        self.staticBox1.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.staticBox1.SetThemeEnabled(True)
        self.staticBox1.SetConstraints(LayoutAnchors(self.staticBox1, True,
              True, False, False))
        self.staticBox1.SetAutoLayout(True)
        self.staticBox1.SetMaxSize(wx.Size(240, 48))

        self.staticBox2 = wx.StaticBox(id=wxID_TUNAPIESTATICBOX2,
              label='Now Playing', name='staticBox2', parent=self,
              pos=wx.Point(16, 328), size=wx.Size(240, 48), style=0)
        self.staticBox2.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.staticBox2.SetThemeEnabled(True)
        self.staticBox2.SetMaxSize(wx.Size(240, 48))
        self.staticBox2.SetConstraints(LayoutAnchors(self.staticBox2, True,
              True, False, False))
        self.staticBox2.SetAutoLayout(True)

        self.staticBox3 = wx.StaticBox(id=wxID_TUNAPIESTATICBOX3,
              label='Listeners', name='staticBox3', parent=self,
              pos=wx.Point(16, 204), size=wx.Size(240, 48), style=0)
        self.staticBox3.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.staticBox3.SetThemeEnabled(True)
        self.staticBox3.SetConstraints(LayoutAnchors(self.staticBox3, True,
              True, False, False))
        self.staticBox3.SetAutoLayout(True)
        self.staticBox3.SetMaxSize(wx.Size(240, 48))

        self.staticBox4 = wx.StaticBox(id=wxID_TUNAPIESTATICBOX4,
              label='Bitrate', name='staticBox4', parent=self, pos=wx.Point(16,
              268), size=wx.Size(240, 48), style=0)
        self.staticBox4.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.staticBox4.SetThemeEnabled(True)
        self.staticBox4.SetConstraints(LayoutAnchors(self.staticBox4, True,
              True, False, False))
        self.staticBox4.SetMaxSize(wx.Size(240, 48))

        self.genStaticText3 = wx.lib.stattext.GenStaticText(ID=wxID_TUNAPIEGENSTATICTEXT3,
              label='Status:', name='genStaticText3', parent=self,
              pos=wx.Point(16, 12), size=wx.Size(41, 13), style=0)
        self.genStaticText3.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.genStaticText3.SetBackgroundColour(wx.Colour(233, 233, 244))
        self.genStaticText3.SetBackgroundStyle(wx.BG_STYLE_SYSTEM)
        self.genStaticText3.SetThemeEnabled(True)
        self.genStaticText3.SetMaxSize(wx.Size(47,13))
        self.genStaticText3.SetConstraints(LayoutAnchors(self.genStaticText3,
              True, True, False, False))
        self.genStaticText3.SetAutoLayout(True)

        self.playingctrl = wx.TextCtrl(id=wxID_TUNAPIEPLAYINGCTRL,
              name='playingctrl', parent=self, pos=wx.Point(32, 344),
              size=wx.Size(208, 22), style=0, value='')
        self.playingctrl.SetEditable(False)
        self.playingctrl.SetBackgroundColour(wx.Colour(194, 236, 208))
        self.playingctrl.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.playingctrl.SetThemeEnabled(True)
        self.playingctrl.SetConstraints(LayoutAnchors(self.playingctrl, True,
              True, False, True))
        self.playingctrl.SetAutoLayout(True)
        self.playingctrl.SetMaxSize(wx.Size(208, 22))

        self.genrectrl = wx.TextCtrl(id=wxID_TUNAPIEGENRECTRL, name='genrectrl',
              parent=self, pos=wx.Point(32, 160), size=wx.Size(208, 22),
              style=0, value='')
        self.genrectrl.SetEditable(False)
        self.genrectrl.SetForegroundColour(wx.Colour(0, 0, 0))
        self.genrectrl.SetBackgroundColour(wx.Colour(194, 236, 206))
        self.genrectrl.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.genrectrl.SetThemeEnabled(True)
        self.genrectrl.SetConstraints(LayoutAnchors(self.genrectrl, True, True,
              False, False))
        self.genrectrl.SetAutoLayout(True)
        self.genrectrl.SetMaxSize(wx.Size(208, 22))

        self.listenersctrl = wx.TextCtrl(id=wxID_TUNAPIELISTENERSCTRL,
              name='listenersctrl', parent=self, pos=wx.Point(32, 222),
              size=wx.Size(208, 22), style=0, value='')
        self.listenersctrl.SetEditable(False)
        self.listenersctrl.SetBackgroundColour(wx.Colour(194, 236, 206))
        self.listenersctrl.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.listenersctrl.SetThemeEnabled(True)
        self.listenersctrl.SetConstraints(LayoutAnchors(self.listenersctrl,
              True, True, False, False))
        self.listenersctrl.SetAutoLayout(True)
        self.listenersctrl.SetMaxSize(wx.Size(208, 22))

        self.bitratectrl = wx.TextCtrl(id=wxID_TUNAPIEBITRATECTRL,
              name='bitratectrl', parent=self, pos=wx.Point(32, 284),
              size=wx.Size(208, 22), style=0, value='')
        self.bitratectrl.SetEditable(False)
        self.bitratectrl.SetBackgroundColour(wx.Colour(194, 236, 206))
        self.bitratectrl.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.bitratectrl.SetThemeEnabled(True)
        self.bitratectrl.SetConstraints(LayoutAnchors(self.bitratectrl, True,
              True, False, False))
        self.bitratectrl.SetAutoLayout(True)
        self.bitratectrl.SetMaxSize(wx.Size(208, 22))

        self.favorites = wx.ListBox(choices=[], id=wxID_TUNAPIEFAVORITES,
              name='favorites', parent=self, pos=wx.Point(608, 32),
              size=wx.Size(142, 304), style=wx.LB_EXTENDED | wx.LB_SINGLE)
        self.favorites.SetBackgroundColour(wx.Colour(255, 255, 255))
        self.favorites.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.favorites.SetThemeEnabled(True)
        self.favorites.SetConstraints(LayoutAnchors(self.favorites, True, True,
              True, True))
        self.favorites.SetAutoLayout(True)
        self.favorites.Bind(wx.EVT_LISTBOX, self.OnFavoritesListbox,
              id=wxID_TUNAPIEFAVORITES)
        self.favorites.Bind(wx.EVT_LISTBOX_DCLICK,
              self.OnFavoritesListboxDclick, id=wxID_TUNAPIEFAVORITES)
        self.favorites.Bind(wx.EVT_KEY_UP, self.OnFavoritesKeyUp)

        self.staticBox5 = wx.StaticBox(id=wxID_TUNAPIESTATICBOX5,
              label='Favorites', name='staticBox5', parent=self,
              pos=wx.Point(600, 8), size=wx.Size(160, 368), style=0)
        self.staticBox5.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.staticBox5.SetThemeEnabled(True)
        self.staticBox5.SetConstraints(LayoutAnchors(self.staticBox5, True,
              True, True, True))
        self.staticBox5.SetAutoLayout(True)

        self.deletebutton = wx.Button(id=wxID_TUNAPIEDELETEBUTTON,
              label='Delete', name='deletebutton', parent=self,
              pos=wx.Point(656, 344), size=wx.Size(48, 22), style=0)
        self.deletebutton.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.deletebutton.SetThemeEnabled(True)
        self.deletebutton.SetConstraints(LayoutAnchors(self.deletebutton, True,
              False, False, True))
        self.deletebutton.SetAutoLayout(True)
        self.deletebutton.SetMaxSize(wx.Size(48, 22))
        self.deletebutton.Bind(wx.EVT_BUTTON, self.OnDeletebuttonButton,
              id=wxID_TUNAPIEDELETEBUTTON)

        self.GenreBox = wx.ListBox(choices=['Alternative', 'Ambient', 'Blues',
              'Classical', 'Country', 'Electronic', 'Hip Hop', 'Jazz', 'Pop',
              'Rock', 'Rap', 'Soul', 'Spiritual', 'Spoken', 'World', 'Other'],
              id=wxID_TUNAPIEGENREBOX, name='GenreBox', parent=self,
              pos=wx.Point(96, 44), size=wx.Size(136, 64), style=wx.LB_SINGLE)
        self.GenreBox.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.GenreBox.SetBackgroundColour(wx.Colour(255, 255, 255))
        self.GenreBox.SetThemeEnabled(True)
        self.GenreBox.SetConstraints(LayoutAnchors(self.GenreBox, True, True,
              False, False))
        self.GenreBox.SetAutoLayout(True)
        self.GenreBox.SetMaxSize(wx.Size(136, 64))
        self.GenreBox.Bind(wx.EVT_LISTBOX, self.OnGenreBoxListbox,
              id=wxID_TUNAPIEGENREBOX)

        self.addbutton = wx.Button(id=wxID_TUNAPIEADDBUTTON, label='Add',
              name='addbutton', parent=self, pos=wx.Point(552, 10),
              size=wx.Size(40, 22), style=0)
        self.addbutton.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.addbutton.SetThemeEnabled(True)
        self.addbutton.SetConstraints(LayoutAnchors(self.addbutton, True, True,
              False, False))
        self.addbutton.SetAutoLayout(True)
        self.addbutton.SetMaxSize(wx.Size(40, 22))
        self.addbutton.Bind(wx.EVT_BUTTON, self.OnAddbuttonButton,
              id=wxID_TUNAPIEADDBUTTON)

        self.staticBox6 = wx.StaticBox(id=wxID_TUNAPIESTATICBOX6,
              label='Search', name='staticBox6', parent=self, pos=wx.Point(272,
              328), size=wx.Size(312, 48), style=0)
        self.staticBox6.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.staticBox6.SetThemeEnabled(True)
        self.staticBox6.SetConstraints(LayoutAnchors(self.staticBox6, True,
              False, False, True))
        self.staticBox6.SetAutoLayout(True)
        self.staticBox6.SetMaxSize(wx.Size(312, 48))

        self.textCtrl1 = wx.TextCtrl(id=wxID_TUNAPIETEXTCTRL1, name='textCtrl1',
              parent=self, pos=wx.Point(288, 344), size=wx.Size(248, 22),
              style=0, value='')
        self.textCtrl1.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.textCtrl1.SetBackgroundColour(wx.Colour(255, 253, 239))
        self.textCtrl1.SetThemeEnabled(True)
        self.textCtrl1.SetConstraints(LayoutAnchors(self.textCtrl1, True, False,
              False, True))
        self.textCtrl1.SetAutoLayout(True)
        self.textCtrl1.SetMaxSize(wx.Size(248, 22))
        self.textCtrl1.Bind(wx.EVT_TEXT, self.OnTextCtrl1Text,
              id=wxID_TUNAPIETEXTCTRL1)

        self.GoButton = wx.Button(id=wxID_TUNAPIEGOBUTTON, label='Go',
              name='GoButton', parent=self, pos=wx.Point(544, 344),
              size=wx.Size(32, 22), style=0)
        self.GoButton.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.GoButton.SetThemeEnabled(True)
        self.GoButton.SetConstraints(LayoutAnchors(self.GoButton, True, False,
              False, True))
        self.GoButton.SetAutoLayout(True)
        self.GoButton.SetMaxSize(wx.Size(32, 22))
        self.GoButton.Bind(wx.EVT_BUTTON, self.OnGoButtonButton,
              id=wxID_TUNAPIEGOBUTTON)

        self.genStaticText4 = wx.lib.stattext.GenStaticText(ID=wxID_TUNAPIEGENSTATICTEXT4,
              label='Radio Genre', name='genStaticText4', parent=self,
              pos=wx.Point(16, 45), size=wx.Size(69, 13), style=0)
        self.genStaticText4.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.genStaticText4.SetBackgroundColour(wx.Colour(233, 233, 244))
        self.genStaticText4.SetBackgroundStyle(wx.BG_STYLE_SYSTEM)
        self.genStaticText4.SetThemeEnabled(True)
        self.genStaticText4.SetConstraints(LayoutAnchors(self.genStaticText4,
              True, True, False, False))
        self.genStaticText4.SetAutoLayout(True)
        self.genStaticText4.SetMaxSize(wx.Size(69, 13))

        self.radioradio = wx.RadioButton(id=wxID_TUNAPIERADIORADIO,
              label='Radio', name='radioradio', parent=self, pos=wx.Point(288,
              8), size=wx.Size(56, 24), style=0)
        self.radioradio.SetValue(True)
        self.radioradio.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.radioradio.SetThemeEnabled(True)
        self.radioradio.SetMaxSize(wx.Size(56, 24))
        self.radioradio.SetConstraints(LayoutAnchors(self.radioradio, True,
              True, False, False))
        self.radioradio.SetAutoLayout(True)
        self.radioradio.Bind(wx.EVT_RADIOBUTTON, self.OnRadioradioRadiobutton,
              id=wxID_TUNAPIERADIORADIO)

        self.tvradio = wx.RadioButton(id=wxID_TUNAPIETVRADIO, label='TV',
              name='tvradio', parent=self, pos=wx.Point(240, 8),
              size=wx.Size(40, 24), style=0)
        self.tvradio.SetValue(False)
        self.tvradio.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.tvradio.SetThemeEnabled(True)
        self.tvradio.SetConstraints(LayoutAnchors(self.tvradio, True, True,
              False, False))
        self.tvradio.SetAutoLayout(True)
        self.tvradio.SetMaxSize(wx.Size(40, 24))
        self.tvradio.Bind(wx.EVT_RADIOBUTTON, self.OnTvradioRadiobutton,
              id=wxID_TUNAPIETVRADIO)

        self.PlayButton = wx.Button(id=wxID_TUNAPIEPLAYBUTTON, label='Play',
              name='PlayButton', parent=self, pos=wx.Point(400, 10),
              size=wx.Size(40, 22), style=0)
        self.PlayButton.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.PlayButton.SetBestFittingSize(wx.Size(40, 22))
        self.PlayButton.SetThemeEnabled(True)
        self.PlayButton.SetConstraints(LayoutAnchors(self.PlayButton, True,
              True, False, False))
        self.PlayButton.SetAutoLayout(True)
        self.PlayButton.SetMaxSize(wx.Size(40, 22))
        self.PlayButton.Bind(wx.EVT_BUTTON, self.OnPlayButtonButton,
              id=wxID_TUNAPIEPLAYBUTTON)

        self.RecordButton = wx.Button(id=wxID_TUNAPIERECORDBUTTON,
              label='Record', name='RecordButton', parent=self,
              pos=wx.Point(496, 10), size=wx.Size(48, 22), style=0)
        self.RecordButton.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.RecordButton.SetBestFittingSize(wx.Size(48, 22))
        self.RecordButton.SetThemeEnabled(True)
        self.RecordButton.SetConstraints(LayoutAnchors(self.RecordButton, True,
              True, False, False))
        self.RecordButton.SetAutoLayout(True)
        self.RecordButton.SetMaxSize(wx.Size(48, 22))
        self.RecordButton.Bind(wx.EVT_BUTTON, self.OnRecordButtonButton,
              id=wxID_TUNAPIERECORDBUTTON)

        self.StatusText = wx.TextCtrl(id=wxID_TUNAPIESTATUSTEXT,
              name='StatusText', parent=self, pos=wx.Point(64, 12),
              size=wx.Size(168, 22), style=0, value='Ready')
        self.StatusText.SetEditable(False)
        self.StatusText.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.StatusText.SetBackgroundColour(wx.Colour(194, 236, 206))
        self.StatusText.SetThemeEnabled(True)
        self.StatusText.SetConstraints(LayoutAnchors(self.StatusText, True,
              True, True , False))
        self.StatusText.SetAutoLayout(True)
        self.StatusText.SetMaxSize(wx.Size(168, 22))

        self.Stopbutton = wx.Button(id=wxID_TUNAPIESTOPBUTTON, label='Stop',
              name='Stopbutton', parent=self, pos=wx.Point(352, 10),
              size=wx.Size(40, 22), style=0)
        self.Stopbutton.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.Stopbutton.SetBestFittingSize(wx.Size(40, 22))
        self.Stopbutton.SetThemeEnabled(True)
        self.Stopbutton.SetConstraints(LayoutAnchors(self.Stopbutton, True,
              True, False, False))
        self.Stopbutton.SetAutoLayout(True)
        self.Stopbutton.SetMaxSize(wx.Size(40, 22))
        self.Stopbutton.Bind(wx.EVT_BUTTON, self.OnStopbuttonButton,
              id=wxID_TUNAPIESTOPBUTTON)

        self.InfoButton = wx.Button(id=wxID_TUNAPIEINFOBUTTON, label=u'Info',
              name=u'InfoButton', parent=self, pos=wx.Point(448, 10),
              size=wx.Size(40, 22), style=0)
        self.InfoButton.SetBestFittingSize(wx.Size(40, 22))
        self.InfoButton.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.InfoButton.SetThemeEnabled(True)
        self.InfoButton.SetConstraints(LayoutAnchors(self.InfoButton, True,
              True, False, False))
        self.InfoButton.SetAutoLayout(True)
        self.InfoButton.SetMaxSize(wx.Size(40, 22))
        self.InfoButton.Bind(wx.EVT_BUTTON, self.OnInfoButtonButton,
              id=wxID_TUNAPIEINFOBUTTON)

        self.upbutton = wx.Button(id=wxID_TUNAPIEUPBUTTON, label=u'/\\',
              name=u'upbutton', parent=self, pos=wx.Point(621, 344),
              size=wx.Size(21, 22), style=0)
        self.upbutton.SetFont(wx.Font(5, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.upbutton.SetThemeEnabled(True)
        self.upbutton.SetConstraints(LayoutAnchors(self.upbutton, True, False,
              False, True))
        self.upbutton.SetAutoLayout(True)
        self.upbutton.SetMaxSize(wx.Size(21, 22))
        self.upbutton.Bind(wx.EVT_BUTTON, self.OnUpbuttonButton,
              id=wxID_TUNAPIEUPBUTTON)

        self.downbutton = wx.Button(id=wxID_TUNAPIEDOWNBUTTON, label=u'\\/',
              name=u'downbutton', parent=self, pos=wx.Point(720, 344),
              size=wx.Size(21, 22), style=0)
        self.downbutton.SetFont(wx.Font(5, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.downbutton.SetThemeEnabled(True)
        self.downbutton.SetConstraints(LayoutAnchors(self.downbutton, True,
              False, False, True))
        self.downbutton.SetAutoLayout(True)
        self.downbutton.SetMaxSize(wx.Size(21, 22))
        self.downbutton.Bind(wx.EVT_BUTTON, self.OnDownbuttonButton,
              id=wxID_TUNAPIEDOWNBUTTON)

    def __init__(self, parent):
        self._init_ctrls(parent)
        self.home=os.environ.get('HOME')
        self.running=0 # pid of external player
        self.reloading=0 # set when contacting server
        self.downloading=0 #set when downloading from server
        self.downloadedshoutcast=0
        self.lastmod=-1 # tv or radio last modality when browsing favs?
        self.adult=tuner.adultset()
        try: os.mkdir(self.home+'/.tunapie')
        except OSError:
            pass
        try: self.favname,self.favurl,self.favgen,self.favplay,\
                        self.favbit,self.favlist,self.favmod=\
                        tuner.decode(self.home+'/.tunapie/favorites',1,1,1)
        except IOError:
            self.favname,self.favurl,self.favmod,self.favlist,self.favplay,\
                self.favbit,self.favgen=[],[],[],[],[],[],[]
        for name in self.favname:
            self.favorites.Append(name)
        self.name=[]
        self.mediaplayer='/usr/bin/xmms'
        self.videoplayer='/usr/bin/totem'
        self.term='/usr/bin/x-terminal-emulator'
        self.ripper='/usr/bin/streamripper -t -u winamp2 -o never'
        self.rdir=self.home+'/.tunapie/streamripper'
        self.shoutice=1 #0 is icecast server 1 is shoutcast
        self.maxd=100
        self.newsize=8
        self.mediaplayer,self.videoplayer,self.term,self.ripper,self.rdir,\
            self.shoutice,self.maxd,self.newsize=tuner.readprefs(self.home,\
            self.mediaplayer,self.videoplayer,self.term,self.ripper,self.rdir,\
            self.shoutice,self.maxd,self.newsize)
        #tuner.pkill(self.videoplayer[self.videoplayer.rfind("/")+1:len(self.videoplayer)])
        #tuner.pkill(self.mediaplayer[self.mediaplayer.rfind("/")+1:self.mediaplayer.rfind("/")+16])
        self.setfontsize()
        socket.setdefaulttimeout(10)
        wx.CallAfter(self.download,)

    def setfontsize(self):
        size=int(self.newsize)
        self.menuBar1.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL, False,u'Sans'))
        self.listBox1.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.sort.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.genStaticText1.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.genStaticText2.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.staticBox1.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.staticBox2.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.staticBox3.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.staticBox4.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.genStaticText3.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.playingctrl.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.genrectrl.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.listenersctrl.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.bitratectrl.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.favorites.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.staticBox5.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.deletebutton.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.GenreBox.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.addbutton.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.staticBox6.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.textCtrl1.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.GoButton.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))    
        self.genStaticText4.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))   
        self.radioradio.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.tvradio.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans')) 
        self.PlayButton.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.RecordButton.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.StatusText.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.Stopbutton.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.InfoButton.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL, 
              False, u'Sans'))
        self.upbutton.SetFont(wx.Font(size-3, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.downbutton.SetFont(wx.Font(size-3, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
    
    def download(self):
        #called by at automatic download points
        #only calls reload (which does the real downloading)
        #if has not already been done this session
        if int(self.shoutice):
            if not(self.downloadedshoutcast):
                self.downloadedshoutcast=1
                self.reloading=1
                thread.start_new_thread(self.reload,(3,))
                self.checkfilesize() 
        else:
            try:
                if time.time()-os.stat(self.home+'/.tunapie/icecast')[8]<86400:
                        selection=self.GenreBox.GetStringSelection().lower()
                        self.choose(selection)
                        return
            except OSError:
                pass
            self.reloading=1
            thread.start_new_thread(self.reload,(5,))
            self.checkfilesize()
        self.OnRadioradioRadiobutton(1)

    def OnListBox1Listbox(self, event):
        self.favorites.SetSelection(-1)
        selection=self.listBox1.GetSelection()
        if selection==-1:
            return
        self.listenersctrl.SetValue(self.listeners[selection])
        self.bitratectrl.SetValue(self.bitrate[selection])
        self.playingctrl.SetValue(self.playing[selection])
        self.genrectrl.SetValue(self.genre[selection])

    def checkfilesize(self):
        print 'Waiting for server'
        while 1:
            self.StatusText.SetValue('Waiting for server.')
            time.sleep(0.4)
            wx.Yield()
            self.StatusText.SetValue('Waiting for server..')
            time.sleep(0.4)
            wx.Yield()
            self.StatusText.SetValue('Waiting for server...')
            time.sleep(0.4)
            wx.Yield()
            if (self.downloading>0):
                if(self.downloading==2):
                    self.downloading=0
                    self.reloading=0
                    self.StatusText.SetValue('Error: cannot contact server')
                    print 'Error: cannot contact server.'
                    wx.Yield()
                    time.sleep(2)
                    self.StatusText.SetValue('Ready')
                    self.reloading=0
                    return
                break
        print 'Downloading...'
        while 1:
            self.StatusText.SetValue('Downloading...-')
            time.sleep(0.2)
            wx.Yield()
            self.StatusText.SetValue('Downloading...\\')
            time.sleep(0.2)
            wx.Yield()
            self.StatusText.SetValue('Downloading...|')
            time.sleep(0.2)
            wx.Yield()
            self.StatusText.SetValue('Downloading.../')
            time.sleep(0.2)
            wx.Yield()
            if (self.downloading==3):
                self.downloading=0
                while 1:
                    time.sleep(0.2)
                    wx.Yield()
                    if (self.reloading==0):
                        print 'Ready.'
                        self.StatusText.SetValue('Ready')
                        return

    def reporthook(self,b,c,d): 
            if (b):
                self.downloading=1
            
    def reload(self,type,searchquery=""):    #type: reload 1=radio 2=tv 3=both 4=search 5=icecast
        if(type==1)|(type==3):
            try: radiofile=urllib.urlretrieve('http://www.shoutcast.com/sbin/newxml.phtml?genre=Top500',self.home+'/.tunapie/radiolist',self.reporthook)
            except IOError:
                self.downloading=2
                return
            except AttributeError:
                self.downloading=2
                return
        if(type==2)|(type==3):
            try: tvfile=urllib.urlretrieve('http://www.shoutcast.com/sbin/newtvlister.phtml',self.home+'/.tunapie/tvlist',self.reporthook)
            except IOError:
                self.downloading=2
                return
            except AttributeError:
                self.downloading=2
                return
        if(type==4): #search
	    try: searchfile=urllib.urlretrieve('http://www.shoutcast.com/sbin/newxml.phtml?search='+searchquery.replace(" ","%20"),self.home+'/.tunapie/search',self.reporthook)
            except IOError:
                self.downloading=2
                return
            except AttributeError:
                self.downloading=2
                return
        if(type==5): #icecast
            try: icfile=urllib.urlretrieve('http://dir.xiph.org/?start=0&num=150000',self.home+'/.tunapie/icecast',self.reporthook)
            except IOError:
                self.downloading=2
                return
            except AttributeError:
                self.downloading=2
                return
        self.downloading=3
        self.updatefavs()
        self.reloading=0
        return

    def parsefiles(self):
        if not(int(self.shoutice)):
            filename='/.tunapie/icecast'
            try: 
                self.url,self.name,self.genre,self.playing,self.bitrate,\
                self.listeners=tuner.decodeice(self.home+filename,self.radioradio.GetValue())
            except IOError:
                return -1
            return 0
        if(self.radioradio.GetValue()==True):
            filename='/.tunapie/radiolist'
        else:
            filename='/.tunapie/tvlist'
        try: self.url,self.name,self.genre,self.playing,self.bitrate,\
            self.listeners=tuner.decode(self.home+filename,self.radioradio.GetValue(),self.adult)
        except IOError:
            return -1
        return 0

    def choose(self, selection, namesearch=0):
        ret=self.parsefiles()
        if ret==-1:
            return
        namenew,genrenew,playingnew,listenersnew,bitratenew,urlnew=\
                self.find(selection,namesearch)
        self.name,self.genre,self.playing,self.listeners,self.bitrate,self.url=\
            namenew,genrenew,playingnew,listenersnew,bitratenew,urlnew
        self.OnSortChoice(1)
        
    def find(self, selection='', namesearch=0):
        namenew,genrenew,playingnew,listenersnew,bitratenew,urlnew=\
            [],[],[],[],[],[]
        i=-1
        if(selection):
            for item in self.genre:
                i+=1
                genre=item.lower()
                if(genre.find(selection)>-1):
                    namenew.append(self.name[i])
                    genrenew.append(self.genre[i])
                    playingnew.append(self.playing[i])
                    listenersnew.append(self.listeners[i])
                    bitratenew.append(self.bitrate[i])
                    urlnew.append(self.url[i])
                    continue
                if namesearch==1:
                    try:
                        uppername=self.name[i]
                    except IndexError:
                        #Not downloaded the listing properly!
			continue
                    name=uppername.lower()
                    try:
                        if(name.find(selection)>-1):
                            namenew.append(self.name[i])
                            genrenew.append(self.genre[i])
                            playingnew.append(self.playing[i])
                            listenersnew.append(self.listeners[i])
                            bitratenew.append(self.bitrate[i])
                            urlnew.append(self.url[i])
                            continue
                    except UnicodeDecodeError:
                        pass
                    try:
                        #not sure this is really necessary!!
                        upperplaying=self.playing[i]
                    except IndexError:
                        continue
                    lowerplaying=upperplaying.lower()
                    try:
                        if(lowerplaying.find(selection)>-1):
                            namenew.append(self.name[i])
                            genrenew.append(self.genre[i])
                            playingnew.append(self.playing[i])
                            listenersnew.append(self.listeners[i])
                            bitratenew.append(self.bitrate[i])
                            urlnew.append(self.url[i])
                            continue
                    except UnicodeDecodeError:
                            continue                        
        else:
            streamlist=int(self.maxd)
            if len(self.name)<int(self.maxd):
                streamlist=len(self.name)
            for i in range(streamlist):
                namenew.append(self.name[i])
                genrenew.append(self.genre[i])
                playingnew.append(self.playing[i])
                listenersnew.append(self.listeners[i])
                bitratenew.append(self.bitrate[i])
                urlnew.append(self.url[i])
        return(namenew,genrenew,playingnew,listenersnew,bitratenew,urlnew)

    def OnTextCtrl1Text(self, event):
        self.GoButton.SetDefault()

    def OnTvradioRadiobutton(self, event):
        if self.reloading==1:
            return
        self.infoclear()
        self.lastmod=0
        self.listBox1.Clear()
        if event!=1:
            self.favorites.SetSelection(-1)
        self.GenreBox.SetSelection(-1)
        self.choose('')

    def OnRadioradioRadiobutton(self, event):
        if self.reloading==1:
            return
        self.infoclear()
        self.lastmod=1
        self.listBox1.Clear()
        if event!=1:
            self.favorites.SetSelection(-1)
        selection=self.GenreBox.GetStringSelection().lower()
        self.choose(selection)

    def OnGenreBoxLeftUp(self, event):
        self.OnRadioradioRadiobutton(1)

    def OnGenreBoxListbox(self, event):
        self.infoclear()
        self.radioradio.SetValue(1)
        self.OnRadioradioRadiobutton(1)

    def OnPlayButtonButton(self, event):
        if self.reloading==1:
            return
        if(self.running):
            if (self.videoplayer.find("totem")<0 or self.tvradio.GetValue()==0):
                wasrunning=tuner.pkill(self.videoplayer[self.videoplayer.rfind("/")+1:self.videoplayer.find((' '),self.videoplayer.rfind("/")+1)])
            if (self.mediaplayer.find("xmms")<0 or self.tvradio.GetValue()==1):
                tuner.pkill(self.mediaplayer[self.mediaplayer.rfind("/")+1:self.mediaplayer.rfind("/")+16])
            if self.tvradio.GetValue()==1:
                try:
                    if int(wasrunning):
                        return
                except: pass
        selection=self.listBox1.GetSelection()
        if selection==-1:
            selection=self.favorites.GetSelection()
            if selection==-1:
                return
            if(self.tvradio.GetValue()==True):
                videoplayer=self.videoplayer
                if videoplayer.find("mplayer")>-1:
                    if ((self.favgen[selection].lower().find('porn')>-1)|\
                        (self.favgen[selection].lower().find('swctv')>-1)):
                        videoplayer+=' -demuxer 35'
                self.running,output,outputfd=tuner.playvid(videoplayer,self.favurl[selection])
                self.printout(output,outputfd)
                return
            if(self.radioradio.GetValue()==True):
                self.running=tuner.playselection(self.mediaplayer,self.favurl[selection])
            return
        if(self.tvradio.GetValue()==True):
            videoplayer=self.videoplayer
            if videoplayer.find("mplayer")>-1:
                if ((self.genre[selection].lower().find('porn')>-1)|\
                    (self.genre[selection].lower().find('swctv')>-1)):\
                    videoplayer+=' -demuxer 35'
            self.running,output,outputfd=tuner.playvid(videoplayer,self.url[selection])
            self.printout(output,outputfd)
            return
        if(self.radioradio.GetValue()==True):
            try: self.running=tuner.playselection(self.mediaplayer,self.url[selection])
            except IOError: #if try to play empty stream!
                return
        return
    
    def printout(self,pipe,pipefd):
        if (self.videoplayer.find("mplayer")<0):
            return
        i=0
        output=''
        print 'Contacting server'
        self.StatusText.SetValue('Contacting server')
        while 1:
            select.select([pipefd],[],[])
            outchunk=pipe.read()
            output+=outchunk
            if i>3:
                output=output[len(outchunk):]
            if outchunk=='':
                try:
                    print 'Ready'
                    self.StatusText.SetValue('Ready')
                    return
                except wx.PyDeadObjectError:
                    return
            wx.Yield()
            i+=1
            print (output)
            if (output.find('Cache')>-1):
                self.StatusText.SetValue('Downloading')
            if (output.find('playback')>-1):
                self.StatusText.SetValue('Playing')
            if (output.find('full')>-1):
                print 'Server full'
                self.StatusText.SetValue('Server full')
                for wait in range(5):
                    time.sleep(0.2)
                    wx.Yield()
                print 'Ready'
                self.StatusText.SetValue('Ready')
                return
            if (output.find('Exiting... (End of file)')>-1):
                print 'Error'
                self.StatusText.SetValue('Error')
                for wait in range(5):
                    time.sleep(0.2)
                    wx.Yield()
                print 'Ready'
                self.StatusText.SetValue('Ready')
                return
            

    def OnSortChoice(self, event):
        if not(self.name):
            return    
        self.listBox1.Clear()
        self.infoclear()
        if self.sort.GetStringSelection()=='Name':
            directory=zip(self.name, self.listeners,  self.genre, self.bitrate,\
                self.url, self.playing)
            directory.sort()
            self.listeners,self.genre,self.bitrate,self.url,self.playing,\
                self.name=[],[],[],[],[],[]
            for i in directory:
                self.name.append(i[0])
                self.listeners.append(i[1])
                self.genre.append(i[2])
                self.bitrate.append(i[3])
                self.url.append(i[4])
                self.playing.append(i[5])
        elif self.sort.GetStringSelection()=='Genre':
            directory=zip(self.genre, self.listeners,  self.name, self.bitrate,\
                self.url, self.playing)
            directory.sort()
            self.listeners,self.genre,self.bitrate,self.url,self.playing,\
                self.name=[],[],[],[],[],[]
            for i in directory:
                self.genre.append(i[0])
                self.listeners.append(i[1])
                self.name.append(i[2])
                self.bitrate.append(i[3])
                self.url.append(i[4])
                self.playing.append(i[5])
        elif self.sort.GetStringSelection()=='Bitrate':
            bitratenew=[]
            for i in self.bitrate:
                bitratenew.append(int(i))
            self.bitrate=bitratenew
            directory=zip(self.bitrate, self.listeners,  self.genre, self.name,\
                self.url, self.playing)
            directory.sort()
            directory.reverse()
            self.listeners,self.genre,self.bitrate,self.url,self.playing,\
                self.name=[],[],[],[],[],[]
            for i in directory:
                self.bitrate.append(str(i[0]))
                self.listeners.append(i[1])
                self.genre.append(i[2])
                self.name.append(i[3])
                self.url.append(i[4])
                self.playing.append(i[5])
        else: #Sort by listeners is default
            #//this bit to get the lines sorted as int rather than str
            listenersnew=[]
            for i in self.listeners:
                listenersnew.append(int(i))
            self.listeners=listenersnew
            #//
            directory=zip(self.listeners, self.name,  self.genre, self.bitrate,\
                self.url, self.playing)
            directory.sort()
            directory.reverse()
            self.listeners,self.genre,self.bitrate,self.url,self.playing,\
                self.name=[],[],[],[],[],[]
            for i in directory:
                self.listeners.append(str(i[0]))
                self.name.append(i[1])
                self.genre.append(i[2])
                self.bitrate.append(i[3])
                self.url.append(i[4])
                self.playing.append(i[5])
        for item in self.name:
            self.listBox1.Append(item)

    def infoclear(self):
        self.listBox1.SetSelection(-1)
        self.listenersctrl.SetValue("")
        self.bitratectrl.SetValue("")
        self.playingctrl.SetValue("")
        self.genrectrl.SetValue("")
        return

    def OnGoButtonButton(self, event):
        if self.reloading==1:
            return
        self.infoclear()
        self.GenreBox.SetSelection(-1)
        self.listBox1.Clear()
        selection=self.textCtrl1.GetLineText(0)
        selection=selection.lower()
        selection=tuner.fixunicode(selection)
        #new server-based search for shoutcast radio
        if (self.radioradio.GetValue()==True):
            if(int(self.shoutice)):
                if (len(selection)<3 or selection=="the"):
                    return
                self.reloading=1
                self.downloading=0
                thread.start_new_thread(self.reload,(4,selection))
                self.checkfilesize()
                self.url,self.name,self.genre,self.playing,self.bitrate,\
                    self.listeners=tuner.decode(self.home+'/.tunapie/search',1,0)
                for item in self.name:
                    self.listBox1.Append(item)
                self.OnSortChoice(1)
                return
        #old style search for shoutcast tv
        self.choose(selection,1)

    def OnAddbuttonButton(self, event):
        selection=self.listBox1.GetSelection()
        if (selection<0):
            return
        i=-1
        for name in self.favname:
            i+=1
            if (name==self.name[selection]):
                if (self.favbit[i]==self.bitrate[selection]):
                    if (self.favurl[i]==self.url[selection]):
                        print "Duplicate entry"
                        self.StatusText.SetValue('Duplicate entry!')
                        for wait in range(5):
                            time.sleep(0.2)
                            wx.Yield()
                        print 'Ready'
                        self.StatusText.SetValue('Ready')
                        return
        self.favname.append(self.name[selection])
        self.favurl.append(self.url[selection])
        self.favmod.append(self.radioradio.GetValue())
        self.favplay.append(self.playing[selection])
        self.favbit.append(self.bitrate[selection])
        self.favgen.append(self.genre[selection])
        self.favlist.append(self.listeners[selection])
        self.favorites.Append(self.name[selection])
        #save favorites here
        tuner.savefavorites(self.home,self.favname,self.favurl,self.favlist,\
            self.favplay,self.favbit,self.favgen,self.favmod)

    def OnHelpmenuAboutMenu(self, event):
        if self.reloading==1:
            return
        dlg=AboutTuner.About(self)
        dlg.setfontsize(self.newsize)
        try:
            if dlg.ShowModal()==1:
                seq.reset()
                self.retrievedata()
        finally:
            dlg.Destroy()

    def OnDeletebuttonButton(self, event):
        selection=self.favorites.GetSelection()
        if selection<0:
            return
        newurl,newname,newmod,newlist,newplay,newbit,newgen=[],[],[],[],[],[],[]
        for i in range(len(self.favname)):
            if i!=selection:
                newurl.append(self.favurl[i])
                newname.append(self.favname[i])
                newmod.append(self.favmod[i])
                newlist.append(self.favlist[i])
                newplay.append(self.favplay[i])
                newbit.append(self.favbit[i])
                newgen.append(self.favgen[i])
        self.favname,self.favurl,self.favmod,self.favlist,self.favplay,\
            self.favbit,self.favgen=newname,newurl,newmod,newlist,newplay\
            ,newbit,newgen
        self.favclearsave()
        
    def favclearsave (self):
        self.favorites.Clear()
        for name in self.favname:
            self.favorites.Append(name)
        #save favorites here
        tuner.savefavorites(self.home,self.favname,self.favurl,\
            self.favlist,self.favplay,self.favbit,self.favgen,self.favmod)

    def OnMenufileQuitMenu(self, event):
        self.OnTunaPieClose(1)

    def OnMenufilePrefMenu(self, event):
        if self.reloading==1:
            return
        dlg=TunerPrefs.preferences(self)
        dlg.setfontsize(self.newsize)
        dlg.setvars(self.mediaplayer,self.videoplayer\
            ,self.term,self.ripper,self.home,self.rdir,self.shoutice,self.maxd,\
            self.newsize)
        try:
            if dlg.ShowModal()==1:
                seq.reset()
                self.retrievedata()
        finally:
            dlg.Destroy()
        self.mediaplayer,self.videoplayer,self.term,self.ripper,self.rdir,\
            self.shoutice,self.maxd,self.newsize=tuner.readprefs(self.home,self.mediaplayer,self.videoplayer,\
            self.term,self.ripper,self.rdir,self.shoutice,self.maxd,self.newsize)
        self.setfontsize()
        self.download()
        self.OnRadioradioRadiobutton(1)

    def OnRecordButtonButton(self, event):
        try: os.listdir(self.rdir)
        except OSError:
            try: os.makedirs(self.rdir)
            except OSError:
                print 'Cannot create rip directory!'
                self.StatusText.SetValue('Cannot create rip directory!')
                for wait in range(5):
                        time.sleep(0.2)
                        wx.Yield()
                print 'Ready'
                self.StatusText.SetValue('Ready')
                return
        selection=self.listBox1.GetSelection()
        if selection==-1:
            selection=self.favorites.GetSelection()
            if selection==-1:
                return
            recordoptions=[self.term,'-e',self.ripper,self.favurl[selection],self.rdir]
        else:
            recordoptions=[self.term,'-e',self.ripper,self.url[selection],self.rdir]
        dlg=RecordTime.RecordStream(self)
        dlg.setfontsize(self.newsize)
        dlg.setoptions(recordoptions)
        try:
            if dlg.ShowModal()==1:
                seq.reset()
                self.retrievedata()
        finally:
            dlg.Destroy()

    def OnFavoritesListbox(self, event):
        self.listBox1.SetSelection(-1)
        selection=self.favorites.GetSelection()
        if selection==-1:
            return
        refresh=1
        if self.favmod[selection]==self.lastmod:
            refresh=0
        if self.favmod[selection]==1:
            self.radioradio.SetValue(self.favmod[selection])
            if(refresh):
                self.OnRadioradioRadiobutton(1)
        else:
            self.tvradio.SetValue(not(self.favmod[selection]))
            if(refresh):
                self.OnTvradioRadiobutton(1)
        self.listenersctrl.SetValue(self.favlist[selection])
        self.bitratectrl.SetValue(self.favbit[selection])
        self.playingctrl.SetValue(self.favplay[selection])
        self.genrectrl.SetValue(self.favgen[selection])

    def OnTunaPieClose(self, event):
        #tuner.pkill(self.videoplayer[self.videoplayer.rfind("/")+1:self.videoplayer.find((' '),self.videoplayer.rfind("/")+1)])
        #tuner.pkill(self.mediaplayer[self.mediaplayer.rfind("/")+1:self.mediaplayer.rfind("/")+16])
        try: os.remove('/tmp/'+getpass.getuser()+'_tunapie_temp.pls')
        except OSError:
            pass
        self.Destroy()

    def OnStopbuttonButton(self, event):
        tuner.pkill(self.videoplayer[self.videoplayer.rfind("/")+1:len(self.videoplayer)])
        tuner.pkill(self.mediaplayer[self.mediaplayer.rfind("/")+1:self.mediaplayer.rfind("/")+16])
            
    def OnMenufileReloadMenu(self, event):
        if self.reloading==1:
            return
        if self.running:
            tuner.pkill(self.videoplayer[self.videoplayer.rfind("/")+1:len(self.videoplayer)])
            tuner.pkill(self.mediaplayer[self.mediaplayer.rfind("/")+1:self.mediaplayer.rfind("/")+16])
        self.reloading=1
        self.downloading=0
        if (int(self.shoutice)==1):
            thread.start_new_thread(self.reload,(3,))
        else:
            thread.start_new_thread(self.reload,(5,))
        self.checkfilesize()
        #get top 100:
        self.choose('')
        #call thread to wait then disable button

    def updatefavs(self):
        #need to call this after new update to db.
        currentmod=self.radioradio.GetValue()
        i=0
        while 1:
            #loads either tv or radio listings
            ret=self.parsefiles()
            if ret==-1:
                return
            j=-1
            for name in self.favname:
                j+=1
                namenew,genrenew,playingnew,listenersnew,bitratenew,urlnew=\
                    self.find(name.lower(),1)
                k=-1
                for newname in namenew:
                    k+=1
                    if (name==newname):
                        if (self.favbit[j]==bitratenew[k]):
                            self.favurl[j]=urlnew[k]
                            self.favplay[j]=playingnew[k]
                            self.favlist[j]=listenersnew[k]
                            break
            if i==0:
                #runs through one set of listings first, then does the other (tv or radio)
                self.tvradio.SetValue(currentmod)
                i=1
                continue
            self.radioradio.SetValue(currentmod)
            self.favclearsave()
            return
    
    def OnInfoButtonButton(self, event):
        if self.reloading==1:
            return
        selection=self.listBox1.GetSelection()
        dlg=TunerInfoDialog.StreamInfo(self)
        dlg.setfontsize(self.newsize)
        fav=0
        if (selection==-1):
            selection=self.favorites.GetSelection()
            if (selection==-1):
                return
            fav=1
        #self.reloading=1
        #    thread.start_new_thread(self.reload,(3,))
        #    self.checkfilesize()
        if (fav==1):
            dlg.FillInfo(tuner.playselection(self.mediaplayer,self.favurl[selection],1))
        else:
            dlg.FillInfo(tuner.playselection(self.mediaplayer,self.url[selection],1))
        #dlg.setvars(self.mediaplayer,self.videoplayer\
         #   ,self.term,self.ripper,self.home,self.maxdl)
        try:
            if dlg.ShowModal()==1:
                seq.reset()
                self.retrievedata()
        finally:
            dlg.Destroy()

    def OnMenufileRecordqueueMenu(self, event):
        if self.reloading==1:
            return
        dlg=RecordQueue.recqueue(self)
        dlg.setfontsize(self.newsize)
        try:
            if dlg.ShowModal()==1:
                seq.reset()
                self.retrievedata()
        finally:
            dlg.Destroy()
    
    def OnListBox1ListboxDclick(self, event):
        self.OnPlayButtonButton(1)

    def OnFavoritesListboxDclick(self, event):
        self.OnPlayButtonButton(1)

    def OnListBox1KeyUp(self, event):
        key=wx.KeyEvent.GetKeyCode(event)
        if (key==318):
            self.listBox1.SetSelection(-1)
            self.favorites.SetFocus()
            self.OnFavoritesListbox(1)
        if(key==13):
            self.OnPlayButtonButton(1)
        
    def OnFavoritesKeyUp(self, event):
        key=wx.KeyEvent.GetKeyCode(event)
        if (key==316):
            self.favorites.SetSelection(-1)
            self.listBox1.SetFocus()
            self.OnListBox1Listbox(1)
        if(key==13):
            self.OnPlayButtonButton(1)

    def OnUpbuttonButton(self, event):
        selection=self.favorites.GetSelection()
        if selection>0:
            oldfavname=self.favname[selection-1]
            oldfavurl=self.favurl[selection-1]
            oldfavmod=self.favmod[selection-1]
            oldfavplay=self.favplay[selection-1]
            oldfavbit=self.favbit[selection-1]
            oldfavgen=self.favgen[selection-1]
            oldfavlist=self.favlist[selection-1]
            self.favname[selection-1]=self.favname[selection]
            self.favurl[selection-1]=self.favurl[selection]
            self.favmod[selection-1]=self.favmod[selection]
            self.favplay[selection-1]=self.favplay[selection]
            self.favbit[selection-1]=self.favbit[selection]
            self.favgen[selection-1]=self.favgen[selection]
            self.favlist[selection-1]=self.favlist[selection]
            self.favname[selection]=oldfavname
            self.favurl[selection]=oldfavurl
            self.favmod[selection]=oldfavmod
            self.favplay[selection]=oldfavplay
            self.favbit[selection]=oldfavbit
            self.favgen[selection]=oldfavgen
            self.favlist[selection]=oldfavlist
            self.favclearsave()
            self.favorites.SetSelection(selection-1)

    def OnDownbuttonButton(self, event):
        selection=self.favorites.GetSelection()
        if selection>-1 and selection<(len(self.favname)-1):
            oldfavname=self.favname[selection+1]
            oldfavurl=self.favurl[selection+1]
            oldfavmod=self.favmod[selection+1]
            oldfavplay=self.favplay[selection+1]
            oldfavbit=self.favbit[selection+1]
            oldfavgen=self.favgen[selection+1]
            oldfavlist=self.favlist[selection+1]
            self.favname[selection+1]=self.favname[selection]
            self.favurl[selection+1]=self.favurl[selection]
            self.favmod[selection+1]=self.favmod[selection]
            self.favplay[selection+1]=self.favplay[selection]
            self.favbit[selection+1]=self.favbit[selection]
            self.favgen[selection+1]=self.favgen[selection]
            self.favlist[selection+1]=self.favlist[selection]
            self.favname[selection]=oldfavname
            self.favurl[selection]=oldfavurl
            self.favmod[selection]=oldfavmod
            self.favplay[selection]=oldfavplay
            self.favbit[selection]=oldfavbit
            self.favgen[selection]=oldfavgen
            self.favlist[selection]=oldfavlist
            self.favclearsave()
            self.favorites.SetSelection(selection+1)
