<?php
/**
 * Copyright 1999 - 2002 by Gero Kohnert
 *
 * this script parses all the inputs and stores the object into the database.
 * on completition it jumps to the detail screen of the stored object
 *
 * @modulegroup task
 * @module task_ins
 * @package task
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'task.pinc';
 include_once 'product.pinc';
 include_once 'timetrack.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("task","ins");

 $msg = "";

 $gotourl="task_new.php";

 $t = new task($dbconn);

 if ( isset($_POST['id']) ) {
   $t->read($_POST['id']);
   $gotourl= addUrlParameter($gotourl,"id=". $t->id);
 }

 if ( !isset($_POST['pid']) || ($_POST['pid'] == "") ) {
   $pid =  $current_user->id;
 } else {
   $pid = $_POST['pid'];
   $gotourl= addUrlParameter($gotourl,"pid=". $pid);
 }
 $t->setParent($pid);


 if ( !isset($_POST['name']) || (trim($_POST['name']) == "") ) {
   $msg .= sprintf($lang['Err0009'],$lang['TaskName']) ."<br>";
 } else {
   $t->setName(trim(StripSlashes($_POST['name'])));
   $gotourl= addUrlParameter($gotourl,"name=". UrlEncode($t->name));
 }
 if ( !isset($_POST['desc']) || (trim($_POST['desc']) == "") ) {
   $msg .= sprintf($lang['Err0009'],$lang['TaskDesc']) ."<br>";
 } else {
   $t->setDescription(trim(StripSlashes($_POST['desc'])));
   $gotourl= addUrlParameter($gotourl,"desc=". UrlEncode($t->desc));
 }
 if ( !isset($_POST['state']) || ($_POST['state'] == "") ) {
   $msg .= sprintf($lang['Err0014'],$lang['TaskState']) ."<br>";
 } else {
   $state = $_POST['state'];
   $gotourl= addUrlParameter($gotourl,"state=". UrlEncode($state));
 }

 $volume = 0.0;
 list($volume) = sscanf($_POST['volume'],"%f");
 if ( !is_double($volume) || ($volume < 0) ) {
   $msg .= sprintf($lang['Err0009'],$lang['TaskVolumeFull']) ."<br>";
 } else {
   $gotourl= addUrlParameter($gotourl,"volume=". UrlEncode($volume));
 }

 $volume_done = 0.0;
 list($volume_done) = sscanf($_POST['volume_done'],"%f");
 if ( !is_double($volume_done) || ($volume_done < 0) ) {
   $msg .= sprintf($lang['Err0009'],$lang['TaskVolumeDone']) ."<br>";
 } else {
   $gotourl= addUrlParameter($gotourl,"volume_done=". UrlEncode($volume_done));
 }

 $volume_todo = -1.0;
 list($volume_todo) = sscanf($_POST['volume_todo'],"%f");
 if ( !is_double($volume_todo) || ($volume_todo < 0 && $volume_todo != -1.0)) {
   $msg .= sprintf($lang['Err0009'],$lang['TaskVolumeTodo']) ."<br>";
 } else {
   $gotourl= addUrlParameter($gotourl,"volume_todo=". UrlEncode($volume_todo));
 }

 if ( !isset($_POST['worker']) ) {
   $msg .= sprintf($lang['Err0014'],$lang['TaskWorker']) ."<br>";
 } else {
   $t->worker = array();
   foreach($_POST['worker'] as $i => $f ) {
     $t->worker[$f] = getObject($dbconn,$f);
     $gotourl= addUrlParameter($gotourl,"worker[]=". $f);
   }
 }


 $s_start = new DateTime(0);
 $s_start->setDateTimeF("s_start");
 $gotourl= addUrlParameter($gotourl,"s_start=". $s_start->getYYYYMMDDHHMM() );
 if ( 1 != $s_start->checkDMY() ) {
   $msg .= sprintf($lang['Err0038'],$lang['TaskS_Start']) ."<br>";
 }

 $s_end = new DateTime(0);
 $s_end->setDateTimeF("s_end");
 $gotourl= addUrlParameter($gotourl,"s_end=". $s_end->getYYYYMMDDHHMM() );
 if ( 1 != $s_end->checkDMY() ) {
   $msg .= sprintf($lang['Err0038'],$lang['TaskS_End']) ."<br>";
 }

 if ( ($s_start->ts > $s_end->ts ) ) {
   $msg .= $lang['Err0002'] ."<br>";
 }

 # other modules
 $msg .= module_parseforms($current_user,$t,$gotourl);

 if ( $msg == "" ) {
   $t->parent = getObject($dbconn,$t->p_id);

   # First time work done
   if ( ($t->volume_done == 0) && ($volume_done > 0) ) {
     $t->setRStart(new DateTime());
   }
   # First time state set to finished
   if ( ($t->state != TASK_FINISH) && ($state == TASK_FINISH) ) {
     $t->setREnd(new DateTime());
   }
   if ( ($volume_done > $t->volume_done) && ($state == TASK_FINISH) ) {
     $t->setREnd(new DateTime());
   }


   $t->setState($state);
   $t->setVolume($volume);
   $t->setVolumeDone($volume_done);
   $t->setVolumeTodo($volume_todo);
   $t->setSStart($s_start);
   $t->setSEnd($s_end);

   $dbconn->Begin("WORK");
   $msg .= $t->save();
   $dbconn->Commit("WORK");

   $gotourl= $t->getURL();
 }

 $_SESSION['MSGID'.strlen($msg)] = UrlEncode($msg);
 $gotourl = addUrlParameter($gotourl,"msgid=MSGID". strlen($msg));
 $gotourl = addSessionKey($gotourl);

 Header("Status: 302 Moved Temporarily");
 Header("Location: ". getBaseUrl() . $gotourl);
 $dbconn->Close();
 /*
  *  CVS Info:  $Id: task_ins.php,v 1.29.2.5 2003/07/03 14:35:23 gokohnert Exp $
  *  $Author: gokohnert $
  */
?>