/*
	TuxPuck - font.h
	Copyright (C) 2001-2002 Jacob Kroon

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	Jacob Kroon - d00jkr@efd.lth.se
*/

#ifndef _FONT_H
#define _FONT_H

/* includes */
#include <SDL_video.h>

/* structs */
typedef struct _Font Font;

/* functions */
Font *font_create(Uint8 *, Uint32 *);
void font_free(Font *);
void font_print(Font *, char *, SDL_Rect *);
Uint32 font_calc_width(Font *, char *);
void font_move_pen(Font *, Uint16, Uint16);
void font_set_pen(Font *, Uint16, Uint16);
void font_set_color(Font *, Uint8, Uint8, Uint8);
void font_set_alpha(Font *, Uint8);

#endif /* _FONT_H */
