/*
	TuxPuck - sprite.h
	Copyright (C) 2001-2002 Jacob Kroon

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	Jacob Kroon - d00jkr@efd.lth.se
*/

#ifndef _SPRITE_H
#define _SPRITE_H

/* includes */
#include <SDL_types.h>

/* structs */
typedef struct _Sprite Sprite;

/* functions */
Sprite *sprite_create(Uint8 *, Uint32 *);
void sprite_free(Sprite *);
void sprite_blit(Sprite *);
void sprite_erase(Sprite *);
Uint8 sprite_update(Sprite *, Uint32);
void sprite_set_position(Sprite *, Uint32, Uint32);
void sprite_set_animation(Sprite *, Uint8);

#endif /* _SPRITE_H */
