#ifndef RECORDTYPE_HH
#define RECORDTYPE_HH

//---------------------------------------------------------------------------
// Copyright (c) 1995-1996 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//---------------------------------------------------------------------------
#include "VHDLType.hh"
#include "TypeKind.hh"
#include <stddef.h>

class ObjectBase;
class VHDLKernelBase;
class EnumerationType;
class SignalBase;

class RecordType : public VHDLType {
public:

  //This data is needed to perform the flattening of the type
  int numberOfFields;

  // This flag is for checking whether this composite type is a composite
  // resolved type. This flag is set in the setCompositeResolvedSignal method.
  // It can be set even in setParentCompositeType method also.
  bool isCompositeResolvedType;
  
// Note: The method "get_kind()" MUST NOT be overloaded by a derived type.
// This is to ensure that the type is recognized correctly.
  virtual Type get_kind() const {
    return RECORD_TYPE;
  }

  ObjectBase* getObject() const {
    return NULL;
  }

  virtual ObjectBase::ObjectType getKind() const;

  virtual VHDLType* clone() const;

  virtual int get_number_of_elements() const {
    return numberOfFields;
  }

  virtual void print(ostream& os = cout) const {
    register int field_number;
    for( field_number = 1; field_number <= numberOfFields; field_number++) {
      get_field(field_number).print(os);
    }
  }
  
  //This function has to be defined for the user defined record types
  virtual VHDLType& get_field(int fieldnumber) const = 0;

  VHDLType& operator=(const VHDLType&) {
    cerr << "RecordType::operator = called" << endl;
    abort();
    return *this;		// Just to keep CC quiet.
  }

  bool operator==(const VHDLType&) const;

  VHDLType& assignVal(const VHDLType& val);

  RecordType() {
    numberOfFields = 0;
    isCompositeResolvedType = false;
  }

  RecordType(ObjectBase::ObjectType) {
    numberOfFields = 0;
    isCompositeResolvedType = false;
  }

  virtual ~RecordType() { }

  virtual void setResolutionFunctionId(int resolutionFnId);
  virtual void setTypeConversionFunctionId(int typeConversionFnId);
  void setElaborationInfo(const VHDLType&);
  void setNumAttributes(int );
  void setAttrib(AttribType, VHDLType&);

  int savantwrite(AccessVariable <char*> &) const;
  int savantwrite(SavantlineType &) const;
  int savantread(AccessVariable <char*> &);
  int savantread(SavantlineType &);

  //The TYPE's resolve is called only for composite resolved signals
  //This resolve goes down to first sub-element of the VHDLType and
  //calls the sub-elements resolve, but which actually does the resolution
  //for the whole composite type
  virtual VHDLType* resolve(VHDLKernelBase*);
  virtual void updateEffVal(const VHDLType*);
  virtual void setParentCompositeType(VHDLType*);
  virtual void setCompositeResolvedSignal(bool);
  virtual bool _is_signal() const { return get_field(1)._is_signal(); }
  virtual SignalBase* locateSig(int);
  virtual SignalBase* findSigInBlock(int, int);
  bool _is_composite_resolved_type() const;
};

void assignVariable(RecordType& dest, const RecordType& src, 
		    const ArrayInfo& dinfo, const ArrayInfo& sinfo);

EnumerationType savantEqual(const RecordType&, const RecordType&);
EnumerationType savantNotEqual(const RecordType&, const RecordType&);
#endif
