/* ==================================================== ======== ======= *
 *
 *  ddraw.cc  [demo]
 *  Ubit Project [Elc::2001]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2001 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:01] ======= *
 * ==================================================== ======== ======= */

#include <ubit/ubit.hpp>
#include <ubit/ugraph.hpp>
#include "dmisc.hh"
#include "ddraw.hh"


DrawDialog::DrawDialog() : bg(UBgcolor::white) {
  xpoints = null; ypoints = null; 
  card = 0; size = 0; 

  fgcolor.set(UColor::red);
  bgcolor.set(UBgcolor::white);

  drawingArea = &ubox
    (
     bg
     + uheight(300)  // size of the drawingArea
     + uwidth(300)
     + UOn::mpress   / ucall(this, &DrawDialog::pressMouse) 
     + UOn::mrelease / ucall(this, &DrawDialog::releaseMouse) 
     + UOn::mdrag    / ucall(this, &DrawDialog::dragMouse) 
     + UOn::viewPaint/ ucall(this, &DrawDialog::repaintDrawingCB) 
     );

  URadioSelect &fgsel = uradioSelect();
  URadioSelect &bgsel = uradioSelect();

  // adds children to "this" object
  addlist
    (
     utitle("Drawing and Graphics")
     + utop()
     + uhbox(UBorder::etchedOut + uhspacing(0) + uvmargin(1)
	     + ulabel(UFont::bold + " Foreground :   ")
	     + ubutton(UBgcolor::white + "   " + fgsel
		       + UOn::action
		       / ucallref(this, UColor::white, &DrawDialog::setFgcolor))
	     + ubutton(UBgcolor::black + "   " + fgsel
		       + UOn::action
		       / ucallref(this, UColor::black, &DrawDialog::setFgcolor))
	     + ubutton(UBgcolor::red + "   " + fgsel
		       + UOn::action
		       / ucallref(this, UColor::red, &DrawDialog::setFgcolor))
	     + ubutton(UBgcolor::yellow + "   " + fgsel
		       + UOn::action
		       / ucallref(this, UColor::yellow, &DrawDialog::setFgcolor))
	     + ubutton(UBgcolor::blue + "   " + fgsel
		       + UOn::action
		       / ucallref(this, UColor::blue, &DrawDialog::setFgcolor))
	     + ubutton(UBgcolor::green + "   " + fgsel
		       + UOn::action
		       / ucallref(this, UColor::green, &DrawDialog::setFgcolor))
	     )

     + uhbox(UBorder::etchedOut + uhspacing(0) + uvmargin(1)
	     + ulabel(UFont::bold + " Background :  ")

	     + ubutton(UBgcolor::white + "   " + bgsel
		       + ucallref(this, UColor::white, &DrawDialog::setBgcolor))

	     + ubutton(UBgcolor::black + "   " + bgsel
		       + ucallref(this, UColor::black, &DrawDialog::setBgcolor))

	     + ubutton(UBgcolor::red + "   "+ bgsel
		       + ucallref(this, UColor::red, &DrawDialog::setBgcolor))

	     + ubutton(UBgcolor::yellow + "   "+ bgsel
		       + ucallref(this, UColor::yellow, &DrawDialog::setBgcolor))

	     + ubutton(UBgcolor::blue + "   "+ bgsel
		       + ucallref(this, UColor::blue, &DrawDialog::setBgcolor))

	     + ubutton(UBgcolor::green + "   "+ bgsel
		       + ucallref(this, UColor::green, &DrawDialog::setBgcolor))

	     + UFont::bold
	     + ubutton("Frisco"+ bgsel
		       + ucallref(this, uima("frisco.gif"), &DrawDialog::setBgima))
	     + ubutton("Eiffel"+ bgsel
		       + ucallref(this, uima("tour-eiffel.gif"), &DrawDialog::setBgima))
	     + ubutton("Metal"+ bgsel
		       + ucallref(this, uima("metal.gif"), &DrawDialog::setBgima))
	     )

     + uvflex()
     // drawing area shown twice
     + uscrollpane(uheight(150) + uwidth(150) + drawingArea)
     + uscrollpane(uheight(150) + uwidth(150)	+ drawingArea)
     
     + utop()
     + uhbox(uhflex() + ulabel("Drag Mouse to Draw ")
             + uright() + ubutton(UFont::bold + " Close " + ucloseWin())
             + " ")
    );
  //bgsel.select(0);  
  //fgsel.select(2);
};


void DrawDialog::pressMouse(UEvent& e) {
  if (!xpoints) {
    size = 100;
    xpoints = (u_pos*) malloc(size * sizeof(u_pos));
    ypoints = (u_pos*) malloc(size * sizeof(u_pos));
  }
  xpoints[0] = lastx = e.getX();
  ypoints[0] = lasty = e.getY();
  card = 1;

  // clearView(true) means: repaints the content of this view
  UGraph g(e.getView());
  g.clearView(true);
}

void DrawDialog::releaseMouse(UEvent& e) {
  // updates and synchronizes both views
  drawingArea->update();
}

void DrawDialog::dragMouse(UEvent& e) {
  UGraph g(e);
  g.setColor(fgcolor);
  g.drawLine(lastx, lasty, e.getX(), e.getY());
  g.flush();

  if (card >= size) {
    size += 100;
    xpoints = (u_pos*) realloc(xpoints, size * sizeof(u_pos));
    ypoints = (u_pos*) realloc(ypoints, size * sizeof(u_pos));
  }
  xpoints[card] = lastx = e.getX();
  ypoints[card] = lasty = e.getY();
  card++;
}

void DrawDialog::repaintDrawingCB(UEvent& e) {
  if (card > 0) {
    UGraph g(e);
    g.setColor(fgcolor);
    g.drawPolyline(xpoints, ypoints, card);
    //g.flush();
  }
}

void DrawDialog::drawXOR(UEvent& e) {
  UGraph g(e);
  g.setColor(fgcolor);
  g.setBgcolor(bgcolor);
  g.setXORMode();
  g.fillRect(100, 100, 80, 80);
  g.drawLine(80, 80, 80, 200);
  g.drawLine(200, 80, 80, 80);
  g.drawLine(80, 200, 200, 200);
  g.drawLine(200, 80, 200, 200);
  //g.flush();
}

void DrawDialog::setFgcolor(UColor& c) {
  fgcolor.set(c);
  drawingArea->update();
}

void DrawDialog::setBgcolor(UColor& c) {
  bgcolor.set(c);
  bg.set(c);
}

void DrawDialog::setBgima(UIma& i) {
  bg.set(i);
};

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:02] ======= */

