/* ==================================================== ======== ======= *
 *
 *  drules.cc  [demo]
 *  Ubit Project [Elc::mar99]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit System: A Visual+Textual Environment for Building GUIs.
 *
 *  (C) 1999 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:99] ======= *
 * ==================================================== ======== ======= */


#include <ubit/ubit.hpp>
#include "drules.hh"


RuleDialog::RuleDialog() {
    UFont &b = UFont::bold;
    UFont &sf = UFont::small;

    //static UPix &minusPix = upix("minus.xbm");
    static UPix &plusPix = upix("plus.xbm");

    addlist
      ( //  adds children to "this" object
       uvbox
       (
	UBorder::etchedIn
	
	+ uhbox( UFont::large + UColor::red + UHalign::center
		 + " Combination Rules "
		 )

	+ uitem( UBorder::etchedOut
		 + uhbox(b + UBgcolor::grey + " UHbox ")
		 + sf + " = ubox( UOrient::horizontal ) = "
		 + ubox( UOrient::horizontal + b + UBgcolor::grey + " UHbox " )
		 )

	+ " "
	+ uitem( UBorder::etchedOut
		 + ubutton(b + "UButton")
		 + sf + " = uhbox( UBorder::activeShadowOut + UMode::canArm ) = "		    
		 + uhbox( UBorder::shadowOut /*+ UMode::canFocus*/ + UMode::canArm + b + UBgcolor::grey + "UButton" )
		 )
	
	+ " "
	+ uitem( UBorder::etchedOut
		 + ucheckbox(b + "UCheckbox")
		 + sf + " = ubutton( UMode::canSelect + USymbol::check) = "
		 + ubutton( UMode::canSelect + USymbol::check + b + "UCheckbox" )
		 )
	
	+ " " 
	+ uitem( UBorder::etchedOut
		 + ubox(b
			+ UMode::canSelect
			+ plusPix
			// actual pixmap depends on Checkbox state
			//.condset(plusPix, chk.when(UOn::unselect))
			//.condset(minusPix, chk.when(UOn::select))
			+ "Custom Checkbox")
		 + sf + " = ucheckbox( UMode::ghost + upix(\"+\",&UOn::on) + upix(\"-\",&UC::off )"
		 )
	
	+ " " 
		  // uedit()	// makes text editable
	+ uitem( UBorder::etchedOut
		 + utextbox(b + uedit() + "UTextbox")
		 + sf + " = ubox( UBorder::shadowIn + UMode::canInput + uedit() )"
		 + ubox( UBorder::shadowIn + /*UMode::canFocus +*/ b + uedit()+ "UTextfield" )
		 )

	+ UFont::bold + UFont::italic + " ... etc ... "
	)

       + uhbox( UBorder::shadowIn + UHalign::center
		+ ubutton( UFont::bold + UFont::italic + UBgcolor::orange
			   + UColor::white + "    Close    " + ucloseWin()
			   )
       )
      );
}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

