/* ==================================================== ======== ======= *
 *
 *  dstatus.cc
 *  Ubit Project [Elc::may99]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:99] ======= *
 * ==================================================== ======== ======= */


#include <stdio.h>
#include <ubit/ubit.hpp>
#include "dstatus.hh"


MyStatusBar::MyStatusBar(/*UTimer *t,*/ UArgs args) {
  //timer = t;
  UTextbox *txt=null;

  addlist
    (
     ubox( UMode::canSelect + USymbol::square 
	   + UOn::action   / ucall(this, &MyStatusBar::clickOnSquare)
	   + UOn::select   / ucall(this, &MyStatusBar::squareSetOn)
	   + UOn::unselect / ucall(this, &MyStatusBar::squareSetOff)
	   )

     + uhbox( UBorder::shadowIn + " ....   ")
     + uhflex()

     + (txt =
	&utextbox())->addlist( UBgcolor::grey + " "
		       // box is red when time-lapse is 0
			    /*
		       + ubox( UBorder::shadowIn 
			       + ubgcolor(UColor::grey)
			       .condset(UColor::red, timer->when(0))
			       .condset(UColor::grey, timer->when(1))
			       + "  ")
		       
		       // box is blue when time-lapse is 1
		       + ubox( UBorder::shadowIn 
			       + ubgcolor(UColor::grey)
			       .condset(UColor::blue, timer->when(1))
			       .condset(UColor::grey, timer->when(2))
			       + "  ")
			 
		       // box is orange when time-lapse is 2
		       + ubox( UBorder::shadowIn
			       + ubgcolor(UColor::grey)

			       .condset(UColor::orange, timer->when(2))
			       .condset(UColor::grey, timer->when(0))
			       + "  ")
		       + " "
		       
		       + ucolor(UColor::black)
		       .condset(UColor::red, timer->when(0))
		       .condset(UColor::blue, timer->when(1))
		       .condset(UColor::orange, timer->when(2))
		       
		       // Start / stop timer
			 + ucall(this, &clickOnBar, UOn::press)
		       
		       //+ ustr(" Click to start...")
		       + ustr(" Ready.")
		       .condset("Are", timer->when(0))
		       .condset("You", timer->when(1))
		       .condset("Experienced?", timer->when(2))
			    */
		       )
     + uleft()
     + ubar(uvcenter())
     + (buttonBar = &ubar(args))         //uvcenter()))
     );

#if TEST
  txt->add(
	  // Start / stop timer
	  ucall(this, &clickOnBar, UOn::press)
	  
	  // message appears when the mouse enters the containing box
	  + "  " + UColor::black
	  + ustr(&ctrlmess," Click to start...")
	  .condset("[Start/Stop]", txt->when(UOn::enter))
	  //.condset("[Start/Stop]", UOn::leave)
	  );
#endif
}


void MyStatusBar::clickOnBar(UEvent&) {
  /*###########
  if (timer->isRunning()) {
    timer->stop();
    //    invite->show(false);
    //ctrlmess->set("[Start]");
  }
  else {
    timer->start();
    //invite->show(false);
    //ctrlmess->set("[Stop]");
  }
  #########*/
}


void MyStatusBar::clickOnSquare(UEvent&) {
  printf("clickOnSquare\n");
}

void MyStatusBar::squareSetOn(UEvent&) {
  printf("squareSetOn\n");
}

void MyStatusBar::squareSetOff(UEvent&) {
  printf("squareSetOff\n");
}


/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:99] ======= */
