/*********************************************************************
 *
 * This is based on code created by Peter Harvey,
 * (pharvey@codebydesign.com).
 *
 * Modified and extended by Nick Gorham
 * (nick@easysoft.com).
 *
 * Any bugs or problems should be considered the fault of Nick and not
 * Peter.
 *
 * copyright (c) 1999 Nick Gorham
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **********************************************************************
 *
 * $Id: SQLGetInfoW.c,v 1.2 2001/12/13 13:00:32 lurcher Exp $
 *
 * $Log: SQLGetInfoW.c,v $
 * Revision 1.2  2001/12/13 13:00:32  lurcher
 *
 * Remove most if not all warnings on 64 bit platforms
 * Add support for new MS 3.52 64 bit changes
 * Add override to disable the stopping of tracing
 * Add MAX_ROWS support in postgres driver
 *
 * Revision 1.1.1.1  2001/10/17 16:40:05  lurcher
 *
 * First upload to SourceForge
 *
 * Revision 1.3  2001/07/03 09:30:41  nick
 *
 * Add ability to alter size of displayed message in the log
 *
 * Revision 1.2  2001/04/12 17:43:36  nick
 *
 * Change logging and added autotest to odbctest
 *
 * Revision 1.1  2000/12/31 20:30:54  nick
 *
 * Add UNICODE support
 *
 *
 **********************************************************************/

#include "drivermanager.h"

static char const rcsid[]= "$RCSfile: SQLGetInfoW.c,v $";

SQLRETURN SQLGetInfoW( SQLHDBC connection_handle,
           SQLUSMALLINT info_type,
           SQLPOINTER info_value,
           SQLSMALLINT buffer_length,
           SQLSMALLINT *string_length )
{
    DMHDBC connection = (DMHDBC)connection_handle;
    SQLRETURN ret = SQL_SUCCESS;
    int type;
    char txt[ 30 ], *cptr;
    SQLPOINTER *ptr;
    SQLCHAR s1[ 100 + LOG_MESSAGE_LEN ];

    /*
     * check connection
     */

    if ( !__validate_dbc( connection ))
    {
        dm_log_write( __FILE__, 
                    __LINE__, 
                    LOG_INFO, 
                    LOG_INFO, 
                    "Error: SQL_INVALID_HANDLE" );

        return SQL_INVALID_HANDLE;
    }

    function_entry( connection );

    if ( log_info.log_flag )
    {
        sprintf( connection -> msg, "\n\t\tEntry:\
            \n\t\t\tConnection = %p\
            \n\t\t\tInfo Type = %s\
            \n\t\t\tInfo Value = %p\
            \n\t\t\tBuffer Length = %d\
            \n\t\t\tStrLen = %p",
                connection,
                __info_as_string( s1, info_type ),
                info_value, 
                (int)buffer_length,
                (void*)string_length );

        dm_log_write( __FILE__, 
                __LINE__, 
                LOG_INFO, 
                LOG_INFO, 
                connection -> msg );
    }

    thread_protect( SQL_HANDLE_DBC, connection );

    if ( info_type != SQL_ODBC_VER &&
            connection -> state == STATE_C2 )
    {
        dm_log_write( __FILE__, 
                __LINE__, 
                LOG_INFO, 
                LOG_INFO, 
                "Error: 08003" );

        __post_internal_error( &connection -> error,
                ERROR_08003, NULL,
                connection -> environment -> requested_version );

        thread_release( SQL_HANDLE_DBC, connection );

        return function_return( connection, SQL_ERROR );
    }
    else if ( connection -> state == STATE_C3 )
    {
        dm_log_write( __FILE__, 
                __LINE__, 
                LOG_INFO, 
                LOG_INFO, 
                "Error: 08003" );

        __post_internal_error( &connection -> error,
                ERROR_08003, NULL,
                connection -> environment -> requested_version );

        thread_release( SQL_HANDLE_DBC, connection );

        return function_return( connection, SQL_ERROR );
    }

    if ( buffer_length < 0 )
    {
        dm_log_write( __FILE__, 
                __LINE__, 
                LOG_INFO, 
                LOG_INFO, 
                "Error: HY090" );

        __post_internal_error( &connection -> error,
                ERROR_HY090, NULL,
                connection -> environment -> requested_version );

        thread_release( SQL_HANDLE_DBC, connection );

        return function_return( connection, SQL_ERROR );
    }

    switch ( info_type )
    {
      case SQL_DATA_SOURCE_NAME:
        type = 1;
        cptr = connection -> dsn;
        break;

      case SQL_DM_VER:
        type = 1;
        sprintf( txt, "%02d.%02d.%04d.%04d",
                SQL_SPEC_MAJOR, SQL_SPEC_MINOR, 
                atoi( VERSION ), atoi( VERSION + 2 ));
        cptr = txt;
        break;

      case SQL_ODBC_VER:
        type = 1;
        sprintf( txt, "%02d.%02d",
                SQL_SPEC_MAJOR, SQL_SPEC_MINOR );
        cptr = txt;
        break;

      case SQL_DRIVER_HDBC:
        type = 2;
        ptr = (SQLPOINTER) connection -> driver_dbc;
        break;

      case SQL_DRIVER_HENV:
        type = 2;
        ptr = (SQLPOINTER) connection -> driver_env;
        break;

      case SQL_DRIVER_HDESC:
        {
            DMHDESC hdesc = *((DMHDESC*) info_value); 

            type = 2;

            if ( __validate_desc( hdesc ))
            {
                ptr = (SQLPOINTER) hdesc -> driver_desc;
            }
            else
            {
                dm_log_write( __FILE__, 
                        __LINE__, 
                        LOG_INFO, 
                        LOG_INFO, 
                        "Error: HY024" );

                __post_internal_error( &connection -> error,
                        ERROR_HY024, NULL,
                        connection -> environment -> requested_version );

                thread_release( SQL_HANDLE_DBC, connection );

                return function_return( connection, SQL_ERROR );
            }
        }
        break;

      case SQL_DRIVER_HLIB:
        type = 2;
        ptr = connection -> dl_handle;
        break;

      case SQL_DRIVER_HSTMT:
        {
            DMHSTMT hstmt = *((DMHSTMT*) info_value); 

            type = 2;

            if ( __validate_stmt( hstmt ))
            {
                ptr = (SQLPOINTER) hstmt -> driver_stmt;
            }
            else
            {
                dm_log_write( __FILE__, 
                        __LINE__, 
                        LOG_INFO, 
                        LOG_INFO, 
                        "Error: HY024" );

                __post_internal_error( &connection -> error,
                        ERROR_HY024, NULL,
                        connection -> environment -> requested_version );

                thread_release( SQL_HANDLE_DBC, connection );

                return function_return( connection, SQL_ERROR );
            }
        }
        break;

      case SQL_XOPEN_CLI_YEAR:
        type = 1;
        cptr = "1994";
        break;

      default:
        /*
         * pass all the others on
         */
        if ( connection -> unicode_driver )
        {
            if ( !CHECK_SQLGETINFOW( connection ))
            {
                dm_log_write( __FILE__, 
                        __LINE__, 
                        LOG_INFO, 
                        LOG_INFO, 
                        "Error: IM001" );

                __post_internal_error( &connection -> error,
                        ERROR_IM001, NULL,
                        connection -> environment -> requested_version );

                thread_release( SQL_HANDLE_DBC, connection );

                return function_return( connection, SQL_ERROR );
            }

            ret = SQLGETINFOW( connection,
                    connection -> driver_dbc,
                    info_type,
                    info_value,
                    buffer_length,
                    string_length );

            if ( log_info.log_flag )
            {
                sprintf( connection -> msg, 
                        "\n\t\tExit:[%s]",
                            __get_return_status( ret ));

                dm_log_write( __FILE__, 
                        __LINE__, 
                        LOG_INFO, 
                        LOG_INFO, 
                        connection -> msg );
            }
        }
        else
        {
            if ( !CHECK_SQLGETINFO( connection ))
            {
                dm_log_write( __FILE__, 
                        __LINE__, 
                        LOG_INFO, 
                        LOG_INFO, 
                        "Error: IM001" );

                __post_internal_error( &connection -> error,
                        ERROR_IM001, NULL,
                        connection -> environment -> requested_version );

                thread_release( SQL_HANDLE_DBC, connection );

                return function_return( connection, SQL_ERROR );
            }

            ret = SQLGETINFO( connection,
                    connection -> driver_dbc,
                    info_type,
                    info_value,
                    buffer_length,
                    string_length );

            switch( info_type )
            {
              case SQL_ACCESSIBLE_PROCEDURES:
              case SQL_ACCESSIBLE_TABLES:
              case SQL_CATALOG_NAME:
              case SQL_CATALOG_NAME_SEPARATOR:
              case SQL_CATALOG_TERM:
              case SQL_COLLATION_SEQ:
              case SQL_COLUMN_ALIAS:
              case SQL_DATA_SOURCE_NAME:
              case SQL_DATA_SOURCE_READ_ONLY:
              case SQL_DATABASE_NAME:
              case SQL_DBMS_NAME:
              case SQL_DBMS_VER:
              case SQL_DESCRIBE_PARAMETER:
              case SQL_DRIVER_NAME:
              case SQL_DRIVER_ODBC_VER:
              case SQL_DRIVER_VER:
              case SQL_ODBC_VER:
              case SQL_EXPRESSIONS_IN_ORDERBY:
              case SQL_IDENTIFIER_QUOTE_CHAR:
              case SQL_INTEGRITY:
              case SQL_KEYWORDS:
              case SQL_LIKE_ESCAPE_CLAUSE:
              case SQL_MAX_ROW_SIZE_INCLUDES_LONG:
              case SQL_MULT_RESULT_SETS:
              case SQL_MULTIPLE_ACTIVE_TXN:
              case SQL_NEED_LONG_DATA_LEN:
              case SQL_ORDER_BY_COLUMNS_IN_SELECT:
              case SQL_PROCEDURE_TERM:
              case SQL_PROCEDURES:
              case SQL_ROW_UPDATES:
              case SQL_SCHEMA_TERM:
              case SQL_SEARCH_PATTERN_ESCAPE:
              case SQL_SERVER_NAME:
              case SQL_SPECIAL_CHARACTERS:
              case SQL_TABLE_TERM:
              case SQL_USER_NAME:
              case SQL_XOPEN_CLI_YEAR:
              case SQL_OUTER_JOINS:
                if ( SQL_SUCCEEDED( ret ) && info_value )
                {
                    ansi_to_unicode_in_place( info_value, SQL_NTS );
                }
                break;
            }

            if ( log_info.log_flag )
            {
                sprintf( connection -> msg, 
                        "\n\t\tExit:[%s]",
                            __get_return_status( ret ));

                dm_log_write( __FILE__, 
                        __LINE__, 
                        LOG_INFO, 
                        LOG_INFO, 
                        connection -> msg );
            }
        }

        thread_release( SQL_HANDLE_DBC, connection );

        return function_return( connection, ret );
    }

    if ( type == 1 )
    {
        SQLWCHAR *s1;

        s1 = ansi_to_unicode((SQLCHAR*) cptr, SQL_NTS );

        if ( string_length )
            *string_length = strlen( cptr );

        if ( info_value )
        {
            if ( buffer_length > strlen( cptr ) + 1 )
            {
                wide_strcpy( info_value, s1 );
            }
            else
            {
                memcpy( info_value, s1, ( buffer_length - 1 * 2 ));
                ((SQLWCHAR*)info_value)[ buffer_length - 1 ] = '\0';
                ret = SQL_SUCCESS_WITH_INFO;
            }
        }

        if ( s1 )
            free( s1 );
    }
    else if ( type == 2 )
    {
        if ( info_value )
            *((int*)info_value) = (int)ptr;

        if ( string_length )
            *string_length = sizeof( SQLPOINTER );
    }

    if ( log_info.log_flag )
    {
        sprintf( connection -> msg, 
                "\n\t\tExit:[%s]",
                    __get_return_status( ret ));

        dm_log_write( __FILE__, 
                __LINE__, 
                LOG_INFO, 
                LOG_INFO, 
                connection -> msg );
    }

    thread_release( SQL_HANDLE_DBC, connection );

    return function_return( connection, ret );
}
