# Copyright (C) 2007  Lars Wirzenius <liw@iki.fi>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


"""Test plugin which defines operation which requires the "null" operation."""


import unperishlib


class NeedNull(unperishlib.Operation):

    def get_name(self):
        # We re-define the method here, intead of using the name attribute,
        # to make sure test coverate is complete.
        return "neednull"
        
    def get_required_options(self):
        # We re-define the method here, intead of using the required_options
        # attribute, to make sure test coverate is complete.
        return ["null"]
