/* l_lx_exec86.h -- created from l_lx_exec86.bin, 5279 (0x149f) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2006 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2006 Laszlo Molnar
   Copyright (C) 2000-2006 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <mfx@users.sourceforge.net>          <ml1050@users.sourceforge.net>
 */


#define LINUX_I386EXEC_LOADER_SIZE    5279
#define LINUX_I386EXEC_LOADER_ADLER32 0xf155b1a6
#define LINUX_I386EXEC_LOADER_CRC32   0x8ea0096c

unsigned char linux_i386exec_loader[5279] = {
232,  0,  0,  0,  0,184, 78, 77, 82, 85, 96,106, 63,139,116, 36,   /* 0x   0 */
 40,139,124, 36, 48,131,205,255,235,  0,164,235,  0,138,  6, 70,   /* 0x  10 */
136,  7, 71,  1,219,117,  7,139, 30,131,238,252, 17,219,114,  0,   /* 0x  20 */
 49,192, 64,138,  7,114,  0,184,  1,  0,  0,  0,  1,219,117,  7,   /* 0x  30 */
139, 30,131,238,252, 17,219, 17,192,  1,219,117,  7,139, 30,131,   /* 0x  40 */
238,252, 17,219,115,  0,  1,219,115,  0,117,  9,139, 30,131,238,   /* 0x  50 */
252, 17,219,115,  0, 49,201,131,232,  3,114, 13,193,224,  8,138,   /* 0x  60 */
  6, 70,131,240,255,116,  0,137,197,  1,219,117,  7,139, 30,131,   /* 0x  70 */
238,252, 17,219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,   /* 0x  80 */
219, 17,201,117,  0, 65,  1,219,117,  7,139, 30,131,238,252, 17,   /* 0x  90 */
219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219,115,  0,   /* 0x  a0 */
  1,219,115,  0,117,  9,139, 30,131,238,252, 17,219,115,  0, 65,   /* 0x  b0 */
 65,131,193,  2,129,253,  0,243,255,255,131,209,  1, 86,141, 52,   /* 0x  c0 */
 47,243,164, 94,233,  0,  0,  0,  0,141, 20, 47,131,253,252,138,   /* 0x  d0 */
  4, 15,118,  0,138,  2, 66,136,  7, 71, 73,117,247,233,  0,  0,   /* 0x  e0 */
  0,  0,139,  2,131,194,  4,137,  7,131,199,  4,131,233,  4,119,   /* 0x  f0 */
241,  1,207,233,  0,  0,  0,  0,235,  0,164,235,  0,138,  6, 70,   /* 0x 100 */
136,  7, 71,  1,219,117,  7,139, 30,131,238,252, 17,219,114,  0,   /* 0x 110 */
 49,192, 64,138,  7,114,  0,184,  1,  0,  0,  0,  1,219,117,  7,   /* 0x 120 */
139, 30,131,238,252, 17,219, 17,192,  1,219,117,  7,139, 30,131,   /* 0x 130 */
238,252, 17,219,114,  0,  1,219,115, 11,117,  0,139, 30,131,238,   /* 0x 140 */
252, 17,219,114,  0, 72,  1,219,117,  7,139, 30,131,238,252, 17,   /* 0x 150 */
219, 17,192,235,  0, 49,201,131,232,  3,114, 17,193,224,  8,138,   /* 0x 160 */
  6, 70,131,240,255,116,  0,209,248,137,197,235, 11,  1,219,117,   /* 0x 170 */
  7,139, 30,131,238,252, 17,219, 17,201,  1,219,117,  7,139, 30,   /* 0x 180 */
131,238,252, 17,219, 17,201,117,  0, 65,  1,219,117,  7,139, 30,   /* 0x 190 */
131,238,252, 17,219, 17,201,  1,219,117,  7,139, 30,131,238,252,   /* 0x 1a0 */
 17,219,115,  0,  1,219,115,  0,117,  9,139, 30,131,238,252, 17,   /* 0x 1b0 */
219,115,  0, 65, 65,131,193,  2,129,253,  0,251,255,255,131,209,   /* 0x 1c0 */
  1, 86,141, 52, 47,243,164, 94,233,  0,  0,  0,  0,141, 20, 47,   /* 0x 1d0 */
131,253,252,138,  4, 15,118,  0,138,  2, 66,136,  7, 71, 73,117,   /* 0x 1e0 */
247,233,  0,  0,  0,  0,139,  2,131,194,  4,137,  7,131,199,  4,   /* 0x 1f0 */
131,233,  4,119,241,  1,207,233,  0,  0,  0,  0,235,  0,164,235,   /* 0x 200 */
  0,138,  6, 70,136,  7, 71,  1,219,117,  7,139, 30,131,238,252,   /* 0x 210 */
 17,219,114,  0, 49,192, 64,138,  7,114,  0,184,  1,  0,  0,  0,   /* 0x 220 */
  1,219,117,  7,139, 30,131,238,252, 17,219, 17,192,  1,219,117,   /* 0x 230 */
  7,139, 30,131,238,252, 17,219,114,  0,  1,219,115, 11,117,  0,   /* 0x 240 */
139, 30,131,238,252, 17,219,114,  0, 72,  1,219,117,  7,139, 30,   /* 0x 250 */
131,238,252, 17,219, 17,192,235,  0,  1,219,117,  7,139, 30,131,   /* 0x 260 */
238,252, 17,219, 17,201,235,  0, 49,201,131,232,  3,114, 17,193,   /* 0x 270 */
224,  8,138,  6, 70,131,240,255,116,  0,209,248,137,197,235, 11,   /* 0x 280 */
  1,219,117,  7,139, 30,131,238,252, 17,219,114,204, 65,  1,219,   /* 0x 290 */
117,  7,139, 30,131,238,252, 17,219,114,190,  1,219,117,  7,139,   /* 0x 2a0 */
 30,131,238,252, 17,219, 17,201,  1,219,117,  7,139, 30,131,238,   /* 0x 2b0 */
252, 17,219,115,  0,  1,219,115,  0,117,  9,139, 30,131,238,252,   /* 0x 2c0 */
 17,219,115,  0, 65, 65,131,193,  2,129,253,  0,251,255,255,131,   /* 0x 2d0 */
209,  2, 86,141, 52, 47,243,164, 94,233,  0,  0,  0,  0,141, 20,   /* 0x 2e0 */
 47,131,253,252,138,  4, 15,118,  0,138,  2, 66,136,  7, 71, 73,   /* 0x 2f0 */
117,247,233,  0,  0,  0,  0,139,  2,131,194,  4,137,  7,131,199,   /* 0x 300 */
  4,131,233,  4,119,241,  1,207,233,  0,  0,  0,  0,185, 84, 69,   /* 0x 310 */
 88, 76,138,  7, 71, 44,232, 60,  1,119,247,128, 63, 63,117,  0,   /* 0x 320 */
139,  7,138, 95,  4,102,193,232,  8,134,196,193,192, 16,134,196,   /* 0x 330 */
 41,248,128,235,232,137,  7,131,199,  5,136,216,226,  0,185, 84,   /* 0x 340 */
 69, 88, 76,176,232,176,233,242,174,117,  0,128, 63, 63,117,  0,   /* 0x 350 */
139,  7,102,193,232,  8,134,196,193,192, 16,134,196, 41,248,171,   /* 0x 360 */
235,  0,139, 84, 36, 40,  3, 84, 36, 44, 57,242,116,  1, 72,135,   /* 0x 370 */
 68, 36, 32,139, 84, 36, 52,137,249,139,124, 36, 48, 41,249,137,   /* 0x 380 */
 10, 90, 87,106, 15, 91,136,215,147,235,  0, 90, 88, 89,151, 96,   /* 0x 390 */
 49,219,187, 78, 77, 82, 85,106, 15, 88,138,100, 36, 32,106, 15,   /* 0x 3a0 */
 91,138,124, 36, 32,138, 84, 36, 32,233,  0,  0,  0,  0, 15,183,   /* 0x 3b0 */
 47, 43,110, 12, 41,221,117,  0,131,237,  1,115,  0,136, 95,255,   /* 0x 3c0 */
 73,136,  7, 71,139,  7,156,102,193,232,  8,193,192, 16,134,196,   /* 0x 3d0 */
157,115,  0,176,  0, 15,200,115,  0,209,232,115,  0,254,203, 75,   /* 0x 3e0 */
 35, 30,125,  2,  3, 30,137,  4,156,235,  0,141, 20, 24, 15,182,   /* 0x 3f0 */
210, 35, 22, 59, 22,114,  2, 43, 22,139,  4,148,254,203, 75, 35,   /* 0x 400 */
 30,125,  2,  3, 30,139, 44,156,133,237,117,  0, 80,139, 70,  4,   /* 0x 410 */
254,200, 72, 35,  6,125,  2,  3,  6, 49,237,137, 70,  4,135,108,   /* 0x 420 */
132,  4, 88,137, 44,148,137,  4,156, 41,248,131,233,  4,  3, 70,   /* 0x 430 */
 16,  1,240,137,  7,131,199,  4,235,  0,235,  0, 80,176,233,176,   /* 0x 440 */
232, 80,106,  0, 83,137,230, 94,137,218,178,233,178,232, 67,106,   /* 0x 450 */
  0,254,203, 75,117,  0, 15,183,  7,131,199,  1, 60,128,114,  4,   /* 0x 460 */
 60,143,118,  0, 41,208, 43, 70,  8,131,232,  2,116,  0,131,232,   /* 0x 470 */
  1,114,  0,115,  0,122,  0,123,  0,248,235,  0,131,233,  1,127,   /* 0x 480 */
  0,137,231,185,  4,  1,  0,  0,139, 14,131,193,  5,139, 14,131,   /* 0x 490 */
193,  4, 49,192,243,171,137,252, 86, 97,151, 81, 80, 82,195,137,   /* 0x 4a0 */
254,235,  0,138,  7,131,199,  1, 60,128,114, 10, 60,143,119,  6,   /* 0x 4b0 */
128,127,254, 15,116,  0, 44,232, 60,  1,119,  0, 56, 23,117,  0,   /* 0x 4c0 */
139,  7,102,193,232,  8,193,192, 16,134,196, 41,248,  1,240,137,   /* 0x 4d0 */
  7,131,199,  4,131,233,  4,138,  7,131,199,  1,226,  0,131,233,   /* 0x 4e0 */
  1,127,  0, 97,195, 93,187,  0, 16, 64,  0,  0, 76, 69, 88, 69,   /* 0x 4f0 */
 67, 48, 48, 48,  0,  0,  0,  0,  0,  0,  0,  0,  0,  5,  0,  0,   /* 0x 500 */
  0, 76, 69, 88, 69, 67, 48, 50, 48,  0,  0,  0,  0,  0, 76, 69,   /* 0x 510 */
 88, 69, 67, 48, 48, 57,  0,  5,  0,  0,  0, 76, 69, 88, 69, 67,   /* 0x 520 */
 48, 49, 48,  0, 10,  0,  0,  0, 78, 50, 66, 83, 77, 65, 49, 48,   /* 0x 530 */
  0, 24,  0,  0,  0,  0,  0,  0,  0, 26,  0,  0,  0, 78, 50, 66,   /* 0x 540 */
 68, 69, 67, 49, 48,  0,  4,  0,  0,  0, 78, 50, 66, 70, 65, 83,   /* 0x 550 */
 49, 48,  0, 27,  0,  0,  0,  0,  0,  0,  0, 29,  0,  0,  0, 78,   /* 0x 560 */
 50, 66, 68, 69, 67, 49, 48,  0,  4,  0,  0,  0, 78, 50, 66, 70,   /* 0x 570 */
 65, 83, 49, 49,  0, 29,  0,  0,  0, 78, 50, 66, 68, 69, 67, 49,   /* 0x 580 */
 48,  0, 35,  0,  0,  0, 78, 50, 66, 83, 77, 65, 50, 48,  0, 46,   /* 0x 590 */
  0,  0,  0,  0,  0,  0,  0, 48,  0,  0,  0, 78, 50, 66, 83, 77,   /* 0x 5a0 */
 65, 49, 48,  0,  2,  0,  0,  0, 78, 50, 66, 70, 65, 83, 50, 48,   /* 0x 5b0 */
  0, 51,  0,  0,  0,  0,  0,  0,  0, 55,  0,  0,  0, 78, 50, 66,   /* 0x 5c0 */
 70, 65, 83, 49, 49,  0,  0,  0,  0,  0, 78, 50, 66, 68, 69, 67,   /* 0x 5d0 */
 50, 48,  0, 60,  0,  0,  0, 78, 50, 66, 83, 77, 65, 51, 48,  0,   /* 0x 5e0 */
 73,  0,  0,  0,  0,  0,  0,  0, 86,  0,  0,  0, 78, 50, 66, 68,   /* 0x 5f0 */
 69, 67, 50, 48,  0,  0,  0,  0,  0, 78, 50, 66, 70, 65, 83, 51,   /* 0x 600 */
 48,  0, 86,  0,  0,  0,  0,  0,  0,  0, 90,  0,  0,  0, 78, 50,   /* 0x 610 */
 66, 68, 69, 67, 50, 48,  0,  0,  0,  0,  0,  0,  0,  0,  0,101,   /* 0x 620 */
  0,  0,  0, 78, 50, 66, 68, 69, 67, 50, 48,  0,  0,  0,  0,  0,   /* 0x 630 */
 78, 50, 66, 68, 69, 67, 51, 48,  0,101,  0,  0,  0,  0,  0,  0,   /* 0x 640 */
  0,119,  0,  0,  0, 78, 50, 66, 68, 69, 67, 54, 48,  0,  0,  0,   /* 0x 650 */
  0,  0,  0,  0,  0,  0,149,  0,  0,  0, 78, 50, 66, 68, 69, 67,   /* 0x 660 */
 53, 48,  0,  0,  0,  0,  0, 78, 50, 66, 83, 77, 65, 52, 48,  0,   /* 0x 670 */
163,  0,  0,  0,  0,  0,  0,  0,176,  0,  0,  0, 78, 50, 66, 68,   /* 0x 680 */
 69, 67, 51, 48,  0, 49,  0,  0,  0, 78, 50, 66, 70, 65, 83, 52,   /* 0x 690 */
 48,  0,176,  0,  0,  0,  0,  0,  0,  0,180,  0,  0,  0, 78, 50,   /* 0x 6a0 */
 66, 68, 69, 67, 51, 48,  0, 49,  0,  0,  0,  0,  0,  0,  0,191,   /* 0x 6b0 */
  0,  0,  0, 78, 50, 66, 68, 69, 67, 51, 48,  0, 49,  0,  0,  0,   /* 0x 6c0 */
 78, 50, 66, 68, 85, 77, 77, 49,  0,191,  0,  0,  0, 78, 50, 66,   /* 0x 6d0 */
 83, 77, 65, 53, 48,  0,191,  0,  0,  0, 78, 50, 66, 70, 65, 83,   /* 0x 6e0 */
 53, 48,  0,193,  0,  0,  0, 78, 50, 66, 68, 69, 67, 53, 48,  0,   /* 0x 6f0 */
196,  0,  0,  0, 78, 50, 66, 83, 77, 65, 54, 48,  0,205,  0,  0,   /* 0x 700 */
  0,  0,  0,  0,  0,217,  0,  0,  0, 78, 50, 66, 68, 69, 67, 49,   /* 0x 710 */
 48,  0,  0,  0,  0,  0, 78, 50, 66, 70, 65, 83, 54, 48,  0,217,   /* 0x 720 */
  0,  0,  0,  0,  0,  0,  0,228,  0,  0,  0, 78, 50, 66, 70, 65,   /* 0x 730 */
 83, 54, 49,  0,  0,  0,  0,  0,  0,  0,  0,  0,242,  0,  0,  0,   /* 0x 740 */
 78, 50, 66, 68, 69, 67, 49, 48,  0,  0,  0,  0,  0, 78, 50, 66,   /* 0x 750 */
 70, 65, 83, 54, 49,  0,242,  0,  0,  0,  0,  0,  0,  0,  8,  1,   /* 0x 760 */
  0,  0, 78, 50, 66, 68, 69, 67, 49, 48,  0,  0,  0,  0,  0, 78,   /* 0x 770 */
 50, 66, 68, 69, 67, 54, 48,  0,  8,  1,  0,  0, 78, 82, 86, 50,   /* 0x 780 */
 66, 69, 78, 68,  0,  8,  1,  0,  0, 78, 50, 68, 83, 77, 65, 49,   /* 0x 790 */
 48,  0,  8,  1,  0,  0,  0,  0,  0,  0, 10,  1,  0,  0, 78, 50,   /* 0x 7a0 */
 68, 68, 69, 67, 49, 48,  0,  4,  0,  0,  0, 78, 50, 68, 70, 65,   /* 0x 7b0 */
 83, 49, 48,  0, 11,  1,  0,  0,  0,  0,  0,  0, 13,  1,  0,  0,   /* 0x 7c0 */
 78, 50, 68, 68, 69, 67, 49, 48,  0,  4,  0,  0,  0, 78, 50, 68,   /* 0x 7d0 */
 70, 65, 83, 49, 49,  0, 13,  1,  0,  0, 78, 50, 68, 68, 69, 67,   /* 0x 7e0 */
 49, 48,  0, 19,  1,  0,  0, 78, 50, 68, 83, 77, 65, 50, 48,  0,   /* 0x 7f0 */
 30,  1,  0,  0,  0,  0,  0,  0, 32,  1,  0,  0, 78, 50, 68, 83,   /* 0x 800 */
 77, 65, 49, 48,  0,  2,  0,  0,  0, 78, 50, 68, 70, 65, 83, 50,   /* 0x 810 */
 48,  0, 35,  1,  0,  0,  0,  0,  0,  0, 39,  1,  0,  0, 78, 50,   /* 0x 820 */
 68, 70, 65, 83, 49, 49,  0,  0,  0,  0,  0, 78, 50, 68, 68, 69,   /* 0x 830 */
 67, 50, 48,  0, 44,  1,  0,  0, 78, 50, 68, 83, 77, 65, 51, 48,   /* 0x 840 */
  0, 57,  1,  0,  0,  0,  0,  0,  0, 70,  1,  0,  0, 78, 50, 68,   /* 0x 850 */
 68, 69, 67, 51, 48,  0, 16,  0,  0,  0, 78, 50, 68, 70, 65, 83,   /* 0x 860 */
 51, 48,  0, 70,  1,  0,  0,  0,  0,  0,  0, 76,  1,  0,  0, 78,   /* 0x 870 */
 50, 68, 68, 69, 67, 51, 48,  0, 16,  0,  0,  0,  0,  0,  0,  0,   /* 0x 880 */
 85,  1,  0,  0, 78, 50, 68, 68, 69, 67, 51, 48,  0, 16,  0,  0,   /* 0x 890 */
  0, 78, 50, 68, 68, 69, 67, 51, 48,  0, 85,  1,  0,  0,  0,  0,   /* 0x 8a0 */
  0,  0,101,  1,  0,  0, 78, 50, 68, 68, 69, 67, 50, 48,  0,  0,   /* 0x 8b0 */
  0,  0,  0,  0,  0,  0,  0,119,  1,  0,  0, 78, 50, 68, 68, 69,   /* 0x 8c0 */
 67, 54, 48,  0,  0,  0,  0,  0,  0,  0,  0,  0,153,  1,  0,  0,   /* 0x 8d0 */
 78, 50, 68, 68, 69, 67, 53, 48,  0,  0,  0,  0,  0, 78, 50, 68,   /* 0x 8e0 */
 83, 77, 65, 52, 48,  0,167,  1,  0,  0,  0,  0,  0,  0,180,  1,   /* 0x 8f0 */
  0,  0, 78, 50, 68, 68, 69, 67, 51, 48,  0, 69,  0,  0,  0, 78,   /* 0x 900 */
 50, 68, 70, 65, 83, 52, 48,  0,180,  1,  0,  0,  0,  0,  0,  0,   /* 0x 910 */
184,  1,  0,  0, 78, 50, 68, 68, 69, 67, 51, 48,  0, 69,  0,  0,   /* 0x 920 */
  0,  0,  0,  0,  0,195,  1,  0,  0, 78, 50, 68, 68, 69, 67, 51,   /* 0x 930 */
 48,  0, 69,  0,  0,  0, 78, 50, 68, 68, 85, 77, 77, 49,  0,195,   /* 0x 940 */
  1,  0,  0, 78, 50, 68, 83, 77, 65, 53, 48,  0,195,  1,  0,  0,   /* 0x 950 */
 78, 50, 68, 70, 65, 83, 53, 48,  0,197,  1,  0,  0, 78, 50, 68,   /* 0x 960 */
 68, 69, 67, 53, 48,  0,200,  1,  0,  0, 78, 50, 68, 83, 77, 65,   /* 0x 970 */
 54, 48,  0,209,  1,  0,  0,  0,  0,  0,  0,221,  1,  0,  0, 78,   /* 0x 980 */
 50, 68, 68, 69, 67, 49, 48,  0,  0,  0,  0,  0, 78, 50, 68, 70,   /* 0x 990 */
 65, 83, 54, 48,  0,221,  1,  0,  0,  0,  0,  0,  0,232,  1,  0,   /* 0x 9a0 */
  0, 78, 50, 68, 70, 65, 83, 54, 49,  0,  0,  0,  0,  0,  0,  0,   /* 0x 9b0 */
  0,  0,246,  1,  0,  0, 78, 50, 68, 68, 69, 67, 49, 48,  0,  0,   /* 0x 9c0 */
  0,  0,  0, 78, 50, 68, 70, 65, 83, 54, 49,  0,246,  1,  0,  0,   /* 0x 9d0 */
  0,  0,  0,  0, 12,  2,  0,  0, 78, 50, 68, 68, 69, 67, 49, 48,   /* 0x 9e0 */
  0,  0,  0,  0,  0, 78, 50, 68, 68, 69, 67, 54, 48,  0, 12,  2,   /* 0x 9f0 */
  0,  0, 78, 82, 86, 50, 68, 69, 78, 68,  0, 12,  2,  0,  0, 78,   /* 0x a00 */
 50, 69, 83, 77, 65, 49, 48,  0, 12,  2,  0,  0,  0,  0,  0,  0,   /* 0x a10 */
 14,  2,  0,  0, 78, 50, 69, 68, 69, 67, 49, 48,  0,  4,  0,  0,   /* 0x a20 */
  0, 78, 50, 69, 70, 65, 83, 49, 48,  0, 15,  2,  0,  0,  0,  0,   /* 0x a30 */
  0,  0, 17,  2,  0,  0, 78, 50, 69, 68, 69, 67, 49, 48,  0,  4,   /* 0x a40 */
  0,  0,  0, 78, 50, 69, 70, 65, 83, 49, 49,  0, 17,  2,  0,  0,   /* 0x a50 */
 78, 50, 69, 68, 69, 67, 49, 48,  0, 23,  2,  0,  0, 78, 50, 69,   /* 0x a60 */
 83, 77, 65, 50, 48,  0, 34,  2,  0,  0,  0,  0,  0,  0, 36,  2,   /* 0x a70 */
  0,  0, 78, 50, 69, 83, 77, 65, 49, 48,  0,  2,  0,  0,  0, 78,   /* 0x a80 */
 50, 69, 70, 65, 83, 50, 48,  0, 39,  2,  0,  0,  0,  0,  0,  0,   /* 0x a90 */
 43,  2,  0,  0, 78, 50, 69, 70, 65, 83, 49, 49,  0,  0,  0,  0,   /* 0x aa0 */
  0, 78, 50, 69, 68, 69, 67, 50, 48,  0, 48,  2,  0,  0, 78, 50,   /* 0x ab0 */
 69, 83, 77, 65, 51, 48,  0, 61,  2,  0,  0,  0,  0,  0,  0, 74,   /* 0x ac0 */
  2,  0,  0, 78, 50, 69, 68, 69, 67, 51, 48,  0, 31,  0,  0,  0,   /* 0x ad0 */
 78, 50, 69, 70, 65, 83, 51, 48,  0, 74,  2,  0,  0,  0,  0,  0,   /* 0x ae0 */
  0, 80,  2,  0,  0, 78, 50, 69, 68, 69, 67, 51, 48,  0, 31,  0,   /* 0x af0 */
  0,  0,  0,  0,  0,  0, 89,  2,  0,  0, 78, 50, 69, 68, 69, 67,   /* 0x b00 */
 51, 48,  0, 31,  0,  0,  0, 78, 50, 69, 68, 69, 67, 51, 48,  0,   /* 0x b10 */
 89,  2,  0,  0,  0,  0,  0,  0,105,  2,  0,  0, 78, 50, 69, 68,   /* 0x b20 */
 69, 67, 50, 48,  0,  0,  0,  0,  0,  0,  0,  0,  0,120,  2,  0,   /* 0x b30 */
  0, 78, 50, 69, 68, 69, 67, 53, 48,  0,  0,  0,  0,  0,  0,  0,   /* 0x b40 */
  0,  0,138,  2,  0,  0, 78, 50, 69, 68, 69, 67, 54, 48,  0,  0,   /* 0x b50 */
  0,  0,  0, 78, 50, 69, 83, 77, 65, 52, 48,  0,184,  2,  0,  0,   /* 0x b60 */
  0,  0,  0,  0,197,  2,  0,  0, 78, 50, 69, 68, 69, 67, 51, 48,   /* 0x b70 */
  0, 82,  0,  0,  0, 78, 50, 69, 70, 65, 83, 52, 48,  0,197,  2,   /* 0x b80 */
  0,  0,  0,  0,  0,  0,201,  2,  0,  0, 78, 50, 69, 68, 69, 67,   /* 0x b90 */
 51, 48,  0, 82,  0,  0,  0,  0,  0,  0,  0,212,  2,  0,  0, 78,   /* 0x ba0 */
 50, 69, 68, 69, 67, 51, 48,  0, 82,  0,  0,  0, 78, 50, 69, 68,   /* 0x bb0 */
 85, 77, 77, 49,  0,212,  2,  0,  0, 78, 50, 69, 83, 77, 65, 53,   /* 0x bc0 */
 48,  0,212,  2,  0,  0, 78, 50, 69, 70, 65, 83, 53, 48,  0,214,   /* 0x bd0 */
  2,  0,  0, 78, 50, 69, 68, 69, 67, 53, 48,  0,217,  2,  0,  0,   /* 0x be0 */
 78, 50, 69, 83, 77, 65, 54, 48,  0,226,  2,  0,  0,  0,  0,  0,   /* 0x bf0 */
  0,238,  2,  0,  0, 78, 50, 69, 68, 69, 67, 49, 48,  0,  0,  0,   /* 0x c00 */
  0,  0, 78, 50, 69, 70, 65, 83, 54, 48,  0,238,  2,  0,  0,  0,   /* 0x c10 */
  0,  0,  0,249,  2,  0,  0, 78, 50, 69, 70, 65, 83, 54, 49,  0,   /* 0x c20 */
  0,  0,  0,  0,  0,  0,  0,  0,  7,  3,  0,  0, 78, 50, 69, 68,   /* 0x c30 */
 69, 67, 49, 48,  0,  0,  0,  0,  0, 78, 50, 69, 70, 65, 83, 54,   /* 0x c40 */
 49,  0,  7,  3,  0,  0,  0,  0,  0,  0, 29,  3,  0,  0, 78, 50,   /* 0x c50 */
 69, 68, 69, 67, 49, 48,  0,  0,  0,  0,  0, 78, 50, 69, 68, 69,   /* 0x c60 */
 67, 54, 48,  0, 29,  3,  0,  0, 78, 82, 86, 50, 69, 69, 78, 68,   /* 0x c70 */
  0, 29,  3,  0,  0, 67, 65, 76, 76, 84, 82, 48, 48,  0, 29,  3,   /* 0x c80 */
  0,  0, 67, 84, 67, 76, 69, 86, 69, 49,  0, 43,  3,  0,  0,  0,   /* 0x c90 */
  0,  0,  0, 48,  3,  0,  0, 67, 65, 76, 76, 84, 82, 48, 48,  0,   /* 0x ca0 */
  5,  0,  0,  0, 67, 65, 76, 76, 84, 82, 48, 49,  0, 48,  3,  0,   /* 0x cb0 */
  0, 67, 84, 68, 85, 77, 77, 89, 49,  0, 53,  3,  0,  0, 67, 84,   /* 0x cc0 */
 66, 83, 72, 82, 48, 49,  0, 53,  3,  0,  0, 67, 84, 66, 82, 79,   /* 0x cd0 */
 82, 48, 49,  0, 57,  3,  0,  0, 67, 84, 66, 83, 87, 65, 48, 49,   /* 0x ce0 */
  0, 59,  3,  0,  0, 67, 65, 76, 76, 84, 82, 48, 50,  0, 64,  3,   /* 0x cf0 */
  0,  0,  0,  0,  0,  0, 78,  3,  0,  0, 67, 65, 76, 76, 84, 82,   /* 0x d00 */
 48, 48,  0, 10,  0,  0,  0, 67, 65, 76, 76, 84, 82, 49, 48,  0,   /* 0x d10 */
 78,  3,  0,  0, 67, 65, 76, 76, 84, 82, 69, 56,  0, 83,  3,  0,   /* 0x d20 */
  0, 67, 65, 76, 76, 84, 82, 69, 57,  0, 85,  3,  0,  0, 67, 65,   /* 0x d30 */
 76, 76, 84, 82, 49, 49,  0, 87,  3,  0,  0,  0,  0,  0,  0, 91,   /* 0x d40 */
  3,  0,  0, 67, 65, 76, 76, 84, 82, 49, 51,  0,  5,  0,  0,  0,   /* 0x d50 */
 67, 84, 67, 76, 69, 86, 69, 50,  0, 91,  3,  0,  0,  0,  0,  0,   /* 0x d60 */
  0, 96,  3,  0,  0, 67, 65, 76, 76, 84, 82, 49, 49,  0,  0,  0,   /* 0x d70 */
  0,  0, 67, 65, 76, 76, 84, 82, 49, 50,  0, 96,  3,  0,  0, 67,   /* 0x d80 */
 84, 68, 85, 77, 77, 89, 50,  0, 98,  3,  0,  0, 67, 84, 66, 83,   /* 0x d90 */
 72, 82, 49, 49,  0, 98,  3,  0,  0, 67, 84, 66, 82, 79, 82, 49,   /* 0x da0 */
 49,  0,102,  3,  0,  0, 67, 84, 66, 83, 87, 65, 49, 49,  0,104,   /* 0x db0 */
  3,  0,  0, 67, 65, 76, 76, 84, 82, 49, 51,  0,109,  3,  0,  0,   /* 0x dc0 */
  0,  0,  0,  0,114,  3,  0,  0, 67, 65, 76, 76, 84, 82, 49, 48,   /* 0x dd0 */
  0,  5,  0,  0,  0, 67, 84, 84, 72, 69, 69, 78, 68,  0,114,  3,   /* 0x de0 */
  0,  0, 76, 69, 88, 69, 67, 48, 49, 53,  0,114,  3,  0,  0, 76,   /* 0x df0 */
 69, 88, 69, 67, 49, 49, 48,  0,146,  3,  0,  0, 76, 69, 88, 69,   /* 0x e00 */
 67, 49, 48, 48,  0,152,  3,  0,  0, 76, 88, 85, 78, 70, 48, 48,   /* 0x e10 */
 48,  0,153,  3,  0,  0,  0,  0,  0,  0,155,  3,  0,  0, 76, 88,   /* 0x e20 */
 85, 78, 70, 48, 49, 48,  0,  5,  0,  0,  0, 76, 88, 85, 78, 70,   /* 0x e30 */
 48, 48, 50,  0,155,  3,  0,  0, 77, 82, 85, 66, 89, 84, 69, 48,   /* 0x e40 */
  0,160,  3,  0,  0, 76, 88, 77, 82, 85, 48, 48, 53,  0,162,  3,   /* 0x e50 */
  0,  0, 76, 88, 77, 82, 85, 48, 48, 54,  0,167,  3,  0,  0, 76,   /* 0x e60 */
 88, 77, 82, 85, 48, 48, 55,  0,174,  3,  0,  0, 76, 88, 85, 78,   /* 0x e70 */
 70, 48, 48, 56,  0,181,  3,  0,  0, 76, 88, 85, 78, 70, 48, 49,   /* 0x e80 */
 48,  0,185,  3,  0,  0,  0,  0,  0,  0,190,  3,  0,  0, 76, 88,   /* 0x e90 */
 85, 78, 70, 48, 52, 50,  0,  0,  0,  0,  0, 76, 88, 74, 67, 67,   /* 0x ea0 */
 48, 49, 48,  0,190,  3,  0,  0, 76, 88, 77, 82, 85, 48, 52, 53,   /* 0x eb0 */
  0,193,  3,  0,  0, 76, 88, 77, 82, 85, 48, 52, 54,  0,196,  3,   /* 0x ec0 */
  0,  0, 76, 88, 74, 67, 67, 48, 50, 48,  0,198,  3,  0,  0,  0,   /* 0x ed0 */
  0,  0,  0,200,  3,  0,  0, 76, 88, 85, 78, 70, 48, 51, 52,  0,   /* 0x ee0 */
  0,  0,  0,  0, 76, 88, 74, 67, 67, 48, 50, 49,  0,200,  3,  0,   /* 0x ef0 */
  0,  0,  0,  0,  0,205,  3,  0,  0, 76, 88, 85, 78, 70, 48, 51,   /* 0x f00 */
 52,  0,  0,  0,  0,  0, 76, 88, 74, 67, 67, 48, 50, 51,  0,205,   /* 0x f10 */
  3,  0,  0, 76, 88, 85, 78, 70, 48, 51, 55,  0,212,  3,  0,  0,   /* 0x f20 */
 76, 88, 85, 78, 70, 51, 56, 54,  0,214,  3,  0,  0, 76, 88, 85,   /* 0x f30 */
 78, 70, 51, 56, 55,  0,215,  3,  0,  0, 76, 88, 85, 78, 70, 51,   /* 0x f40 */
 56, 56,  0,224,  3,  0,  0,  0,  0,  0,  0,227,  3,  0,  0, 76,   /* 0x f50 */
 88, 85, 78, 70, 48, 52, 48,  0,  0,  0,  0,  0, 76, 88, 85, 78,   /* 0x f60 */
 70, 52, 56, 54,  0,227,  3,  0,  0, 76, 88, 85, 78, 70, 52, 56,   /* 0x f70 */
 55,  0,231,  3,  0,  0,  0,  0,  0,  0,233,  3,  0,  0, 76, 88,   /* 0x f80 */
 85, 78, 70, 48, 52, 48,  0,  0,  0,  0,  0, 76, 88, 77, 82, 85,   /* 0x f90 */
 48, 54, 53,  0,233,  3,  0,  0,  0,  0,  0,  0,237,  3,  0,  0,   /* 0x fa0 */
 76, 88, 77, 82, 85, 48, 55, 48,  0,  5,  0,  0,  0, 77, 82, 85,   /* 0x fb0 */
 66, 89, 84, 69, 51,  0,237,  3,  0,  0, 77, 82, 85, 65, 82, 66,   /* 0x fc0 */
 51, 48,  0,239,  3,  0,  0, 77, 82, 85, 66, 73, 84, 83, 51,  0,   /* 0x fd0 */
240,  3,  0,  0, 77, 82, 85, 65, 82, 66, 52, 48,  0,242,  3,  0,   /* 0x fe0 */
  0, 76, 88, 77, 82, 85, 48, 55, 48,  0,246,  3,  0,  0,  0,  0,   /* 0x ff0 */
  0,  0,251,  3,  0,  0, 76, 88, 85, 78, 70, 48, 52, 48,  0,  0,   /* 0x1000 */
  0,  0,  0, 77, 82, 85, 66, 89, 84, 69, 52,  0,254,  3,  0,  0,   /* 0x1010 */
 77, 82, 85, 66, 73, 84, 83, 52,  0,  1,  4,  0,  0, 77, 82, 85,   /* 0x1020 */
 65, 82, 66, 53, 48,  0,  3,  4,  0,  0, 76, 88, 77, 82, 85, 48,   /* 0x1030 */
 56, 48,  0,  9,  4,  0,  0, 77, 82, 85, 66, 89, 84, 69, 53,  0,   /* 0x1040 */
 12,  4,  0,  0, 77, 82, 85, 65, 82, 66, 54, 48,  0, 14,  4,  0,   /* 0x1050 */
  0, 77, 82, 85, 66, 73, 84, 83, 53,  0, 15,  4,  0,  0, 77, 82,   /* 0x1060 */
 85, 65, 82, 66, 55, 48,  0, 17,  4,  0,  0, 76, 88, 77, 82, 85,   /* 0x1070 */
 48, 57, 48,  0, 21,  4,  0,  0,  0,  0,  0,  0, 28,  4,  0,  0,   /* 0x1080 */
 76, 88, 77, 82, 85, 49, 48, 48,  0, 10,  0,  0,  0, 77, 82, 85,   /* 0x1090 */
 66, 89, 84, 69, 54,  0, 32,  4,  0,  0, 77, 82, 85, 65, 82, 66,   /* 0x10a0 */
 56, 48,  0, 34,  4,  0,  0, 77, 82, 85, 66, 73, 84, 83, 54,  0,   /* 0x10b0 */
 35,  4,  0,  0, 77, 82, 85, 65, 82, 66, 57, 48,  0, 37,  4,  0,   /* 0x10c0 */
  0, 76, 88, 77, 82, 85, 49, 48, 48,  0, 41,  4,  0,  0, 76, 88,   /* 0x10d0 */
 85, 78, 70, 48, 52, 48,  0, 57,  4,  0,  0, 76, 88, 77, 82, 85,   /* 0x10e0 */
 49, 49, 48,  0, 62,  4,  0,  0, 76, 88, 77, 82, 85, 49, 49, 49,   /* 0x10f0 */
  0, 65,  4,  0,  0, 76, 88, 85, 78, 70, 48, 52, 49,  0, 67,  4,   /* 0x1100 */
  0,  0,  0,  0,  0,  0, 74,  4,  0,  0, 76, 88, 85, 78, 70, 48,   /* 0x1110 */
 51, 52,  0,  0,  0,  0,  0, 76, 88, 85, 78, 70, 48, 52, 50,  0,   /* 0x1120 */
 74,  4,  0,  0, 76, 69, 88, 69, 67, 48, 49, 54,  0, 74,  4,  0,   /* 0x1130 */
  0,  0,  0,  0,  0, 76,  4,  0,  0, 76, 88, 85, 78, 70, 48, 52,   /* 0x1140 */
 50,  0,  0,  0,  0,  0, 76, 88, 77, 82, 85, 48, 49, 48,  0, 76,   /* 0x1150 */
  4,  0,  0, 76, 88, 74, 77, 80, 65, 48, 48,  0, 77,  4,  0,  0,   /* 0x1160 */
 76, 88, 67, 65, 76, 76, 66, 48,  0, 79,  4,  0,  0, 76, 88, 85,   /* 0x1170 */
 78, 70, 48, 50, 49,  0, 81,  4,  0,  0, 76, 88, 77, 82, 85, 48,   /* 0x1180 */
 50, 50,  0, 87,  4,  0,  0, 76, 88, 74, 77, 80, 65, 48, 49,  0,   /* 0x1190 */
 90,  4,  0,  0, 76, 88, 67, 65, 76, 76, 66, 49,  0, 92,  4,  0,   /* 0x11a0 */
  0, 77, 82, 85, 66, 73, 84, 83, 49,  0, 94,  4,  0,  0, 76, 88,   /* 0x11b0 */
 77, 82, 85, 48, 51, 48,  0, 95,  4,  0,  0, 77, 82, 85, 66, 89,   /* 0x11c0 */
 84, 69, 49,  0, 97,  4,  0,  0, 77, 82, 85, 65, 82, 66, 49, 48,   /* 0x11d0 */
  0, 99,  4,  0,  0, 76, 88, 77, 82, 85, 48, 52, 48,  0,100,  4,   /* 0x11e0 */
  0,  0,  0,  0,  0,  0,102,  4,  0,  0, 76, 88, 77, 82, 85, 48,   /* 0x11f0 */
 51, 48,  0,  0,  0,  0,  0, 76, 88, 85, 78, 70, 48, 51, 48,  0,   /* 0x1200 */
102,  4,  0,  0, 76, 88, 74, 67, 67, 48, 48, 48,  0,108,  4,  0,   /* 0x1210 */
  0,  0,  0,  0,  0,116,  4,  0,  0, 76, 88, 74, 67, 67, 48, 49,   /* 0x1220 */
 48,  0,  0,  0,  0,  0, 76, 88, 67, 74, 48, 77, 82, 85,  0,116,   /* 0x1230 */
  4,  0,  0, 76, 88, 67, 74, 49, 77, 82, 85,  0,118,  4,  0,  0,   /* 0x1240 */
 76, 88, 67, 65, 76, 74, 77, 80,  0,121,  4,  0,  0, 76, 88, 67,   /* 0x1250 */
 65, 76, 76, 48, 48,  0,124,  4,  0,  0,  0,  0,  0,  0,126,  4,   /* 0x1260 */
  0,  0, 76, 88, 85, 78, 70, 48, 51, 55,  0,  0,  0,  0,  0, 76,   /* 0x1270 */
 88, 67, 65, 76, 76, 48, 49,  0,126,  4,  0,  0, 76, 88, 67, 74,   /* 0x1280 */
 50, 77, 82, 85,  0,129,  4,  0,  0,  0,  0,  0,  0,131,  4,  0,   /* 0x1290 */
  0, 76, 88, 85, 78, 70, 48, 51, 55,  0,  0,  0,  0,  0, 76, 88,   /* 0x12a0 */
 67, 74, 52, 77, 82, 85,  0,131,  4,  0,  0,  0,  0,  0,  0,133,   /* 0x12b0 */
  4,  0,  0, 76, 88, 85, 78, 70, 48, 51, 52,  0,  0,  0,  0,  0,   /* 0x12c0 */
 76, 88, 67, 74, 54, 77, 82, 85,  0,133,  4,  0,  0,  0,  0,  0,   /* 0x12d0 */
  0,135,  4,  0,  0, 76, 88, 67, 74, 56, 77, 82, 85,  0,  1,  0,   /* 0x12e0 */
  0,  0, 76, 88, 67, 74, 55, 77, 82, 85,  0,135,  4,  0,  0,  0,   /* 0x12f0 */
  0,  0,  0,137,  4,  0,  0, 76, 88, 67, 74, 56, 77, 82, 85,  0,   /* 0x1300 */
  1,  0,  0,  0, 76, 88, 67, 74, 56, 77, 82, 85,  0,137,  4,  0,   /* 0x1310 */
  0,  0,  0,  0,  0,140,  4,  0,  0, 76, 88, 85, 78, 70, 48, 51,   /* 0x1320 */
 55,  0,  0,  0,  0,  0, 76, 88, 85, 78, 70, 48, 51, 52,  0,140,   /* 0x1330 */
  4,  0,  0,  0,  0,  0,  0,145,  4,  0,  0, 76, 88, 85, 78, 70,   /* 0x1340 */
 48, 51, 48,  0,  0,  0,  0,  0, 76, 88, 77, 82, 85, 48, 53, 53,   /* 0x1350 */
  0,145,  4,  0,  0, 77, 82, 85, 66, 89, 84, 69, 50,  0,147,  4,   /* 0x1360 */
  0,  0, 77, 82, 85, 66, 73, 84, 83, 50,  0,152,  4,  0,  0, 77,   /* 0x1370 */
 82, 85, 65, 82, 66, 50, 48,  0,157,  4,  0,  0, 76, 88, 77, 82,   /* 0x1380 */
 85, 48, 53, 55,  0,162,  4,  0,  0, 76, 88, 77, 82, 85, 48, 53,   /* 0x1390 */
 56,  0,168,  4,  0,  0, 76, 88, 85, 78, 70, 48, 51, 53,  0,169,   /* 0x13a0 */
  4,  0,  0, 67, 75, 76, 76, 84, 82, 48, 48,  0,175,  4,  0,  0,   /* 0x13b0 */
  0,  0,  0,  0,179,  4,  0,  0, 67, 75, 76, 76, 84, 82, 50, 48,   /* 0x13c0 */
  0, 30,  0,  0,  0, 67, 75, 76, 76, 84, 82, 49, 48,  0,184,  4,   /* 0x13d0 */
  0,  0,  0,  0,  0,  0,198,  4,  0,  0, 67, 75, 76, 76, 84, 82,   /* 0x13e0 */
 50, 48,  0,  6,  0,  0,  0, 67, 75, 76, 76, 84, 82, 50, 48,  0,   /* 0x13f0 */
198,  4,  0,  0,  0,  0,  0,  0,204,  4,  0,  0, 67, 75, 76, 76,   /* 0x1400 */
 84, 82, 52, 48,  0,  0,  0,  0,  0,  0,  0,  0,  0,208,  4,  0,   /* 0x1410 */
  0, 67, 75, 76, 76, 84, 82, 52, 48,  0,  0,  0,  0,  0, 67, 75,   /* 0x1420 */
 76, 76, 84, 82, 51, 48,  0,231,  4,  0,  0,  0,  0,  0,  0,238,   /* 0x1430 */
  4,  0,  0, 67, 75, 76, 76, 84, 82, 49, 48,  0, 14,  0,  0,  0,   /* 0x1440 */
 67, 75, 76, 76, 84, 82, 52, 48,  0,238,  4,  0,  0,  0,  0,  0,   /* 0x1450 */
  0,243,  4,  0,  0, 67, 75, 76, 76, 84, 82, 48, 48,  0,  4,  0,   /* 0x1460 */
  0,  0, 76, 69, 88, 69, 67, 48, 49, 55,  0,243,  4,  0,  0, 76,   /* 0x1470 */
 69, 88, 69, 67, 48, 50, 48,  0,245,  4,  0,  0, 88, 84, 72, 69,   /* 0x1480 */
 69, 78, 68, 88,  0,251,  4,  0,  0,255,255,255,255,251,  4        /* 0x1490 */
};
