/* powerpc-linux.elf-entry.h
   created from powerpc-linux.elf-entry.bin, 8867 (0x22a3) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2011 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2011 Laszlo Molnar
   Copyright (C) 2000-2011 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ml1050@users.sourceforge.net>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_POWERPC_LINUX_ELF_ENTRY_SIZE    8867
#define STUB_POWERPC_LINUX_ELF_ENTRY_ADLER32 0x771bfcd3
#define STUB_POWERPC_LINUX_ELF_ENTRY_CRC32   0x9654df78

unsigned char stub_powerpc_linux_elf_entry[8867] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  2,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   0,  1,  0, 20,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0, 25, 36,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,
/* 0x0030 */   0, 24,  0, 21, 72,  0,  0,129,124,  0, 41,236,125,168,  2,166,
/* 0x0040 */  40,  7,  0,  8, 64,130,  1, 60,144,166,  0,  0,124,132, 26, 20,
/* 0x0050 */  60,  0,128,  0, 61, 32,128,  0, 56, 99,255,255, 56,165,255,255,
/* 0x0060 */  57, 64,255,255, 72,  0,  1, 12, 57, 32,  0,  1,125, 41, 28, 44,
/* 0x0070 */  56, 99,  0,  4,124,  9,  0, 64,125, 41, 72, 20, 97, 41,  0,  1,
/* 0x0080 */  78,128,  0, 32,141,  3,  0,  1,157,  5,  0,  1,124,  9,  0, 64,
/* 0x0090 */ 125, 41, 74, 20, 65,162,255,213, 65,129,255,236, 56,224,  0,  1,
/* 0x00a0 */  72,  0,  0, 20, 56,231,255,255,125, 41, 72, 21, 65,162,255,189,
/* 0x00b0 */ 124,231, 57, 20,125, 41, 72, 21, 65,162,255,177,124,231, 57, 20,
/* 0x00c0 */ 124,  9,  0, 64,125, 41, 74, 20, 65,162,255,161, 65,160,255,216,
/* 0x00d0 */  57,  0,  0,  0, 52,231,255,253, 84,231, 64, 46, 65,128,  0, 32,
/* 0x00e0 */ 140, 67,  0,  1,124,234, 16,249,125, 74, 14,112, 65,130,  0,  0,
/* 0x00f0 */ 112, 66,  0,  1, 65,162,  0, 80, 72,  0,  0, 20,124,  9,  0, 64,
/* 0x0100 */ 125, 41, 74, 20, 65,162,255,101, 65,161,  0, 60, 57,  0,  0,  1,
/* 0x0110 */ 124,  9,  0, 64,125, 41, 74, 20, 65,162,255, 81, 65,161,  0, 40,
/* 0x0120 */ 125, 41, 72, 21, 65,162,255, 69,125,  8, 65, 20,124,  9,  0, 64,
/* 0x0130 */ 125, 41, 74, 20, 65,162,255, 53, 65,160,255,232, 57,  8,  0,  2,
/* 0x0140 */  72,  0,  0, 16,125, 41, 72, 21, 65,162,255, 33,125,  8, 65, 20,
/* 0x0150 */  32,234,250,255, 57,  8,  0,  2,125,  8,  1,148,124,234, 42, 20,
/* 0x0160 */ 125,  9,  3,166,141,  7,  0,  1,157,  5,  0,  1, 66,  0,255,248,
/* 0x0170 */  56,224,  1,  0,124,  7, 41,236,124,  7, 26, 44, 75,255,255, 16,
/* 0x0180 */ 124,  0, 41,236,125,168,  2,166, 40,  7,  0,  5, 64,130,  1, 32,
/* 0x0190 */ 144,166,  0,  0,124,132, 26, 20, 60,  0,128,  0, 61, 32,128,  0,
/* 0x01a0 */  56, 99,255,255, 56,165,255,255, 57, 64,255,255, 72,  0,  0,240,
/* 0x01b0 */  57, 32,  0,  1,125, 41, 28, 44, 56, 99,  0,  4,124,  9,  0, 64,
/* 0x01c0 */ 125, 41, 72, 20, 97, 41,  0,  1, 78,128,  0, 32,141,  3,  0,  1,
/* 0x01d0 */ 157,  5,  0,  1,124,  9,  0, 64,125, 41, 74, 20, 65,162,255,213,
/* 0x01e0 */  65,129,255,236, 56,224,  0,  1, 72,  0,  0, 20, 56,231,255,255,
/* 0x01f0 */ 125, 41, 72, 21, 65,162,255,189,124,231, 57, 21,125, 41, 72, 21,
/* 0x0200 */  65,162,255,177,124,231, 57, 21,124,  9,  0, 64,125, 41, 74, 20,
/* 0x0210 */  65,162,255,161, 65,160,255,216, 57,  0,  0,  0, 52,231,255,253,
/* 0x0220 */  84,231, 64, 46, 65,128,  0, 24,140, 67,  0,  1,124,234, 16,249,
/* 0x0230 */ 125, 74, 14,112, 65,130,  0,  0, 72,  0,  0, 12,125, 41, 72, 21,
/* 0x0240 */  65,162,255,113,125,  8, 65, 21,125, 41, 72, 21, 65,162,255,101,
/* 0x0250 */ 125,  8, 65, 21, 64,130,  0, 40, 57,  0,  0,  1,125, 41, 72, 21,
/* 0x0260 */  65,162,255, 81,125,  8, 65, 21,124,  9,  0, 64,125, 41, 74, 20,
/* 0x0270 */  65,162,255, 65, 65,160,255,232, 57,  8,  0,  2, 32,234,250,255,
/* 0x0280 */  57,  8,  0,  1,125,  8,  1,148,124,234, 42, 20,125,  9,  3,166,
/* 0x0290 */ 141,  7,  0,  1,157,  5,  0,  1, 66,  0,255,248, 56,224,  1,  0,
/* 0x02a0 */ 124,  7, 41,236,124,  7, 26, 44, 75,255,255, 44,124,  0, 41,236,
/* 0x02b0 */ 125,168,  2,166, 40,  7,  0,  2, 64,130,  0,228,144,166,  0,  0,
/* 0x02c0 */ 124,132, 26, 20, 60,  0,128,  0, 61, 32,128,  0, 56, 99,255,255,
/* 0x02d0 */  56,165,255,255, 57, 64,255,255, 72,  0,  0,180,124,  9,  0, 64,
/* 0x02e0 */ 125, 41, 72, 20, 76,162,  0, 32, 57, 32,  0,  1,125, 41, 28, 44,
/* 0x02f0 */  56, 99,  0,  4,124,  9,  0, 64,125, 41, 73, 20, 78,128,  0, 32,
/* 0x0300 */ 141,  3,  0,  1,157,  5,  0,  1, 75,255,255,213, 65,129,255,244,
/* 0x0310 */  56,224,  0,  1, 75,255,255,201,124,231, 57, 21, 75,255,255,193,
/* 0x0320 */  65,160,255,244, 52,231,255,253, 57,  0,  0,  0, 65,128,  0, 20,
/* 0x0330 */ 140, 67,  0,  1, 84,231, 64, 46,124,234, 16,249, 65,130,  0,  0,
/* 0x0340 */  75,255,255,157,125,  8, 65, 21, 75,255,255,149,125,  8, 65, 21,
/* 0x0350 */  56,224,  0,  1, 64,130,  0, 28, 56,224,  0,  3, 57,  0,  0,  1,
/* 0x0360 */  75,255,255,125,125,  8, 65, 21, 75,255,255,117, 65,160,255,244,
/* 0x0370 */  32, 74,242,255,125,  8, 57, 20,124,234, 42, 20,125,  9,  3,166,
/* 0x0380 */ 141,  7,  0,  1,157,  5,  0,  1, 66,  0,255,248, 56,224,  1,  0,
/* 0x0390 */ 124,  7, 41,236,124,  7, 26, 44, 75,255,255,112, 40,  7,  0, 14,
/* 0x03a0 */  64,130,  0, 32,124,  8,  2,166,124,201, 51,120,129,  6,  0,  0,
/* 0x03b0 */ 124,167, 43,120, 56,164,255,254, 56,131,  0,  2,144,  1,  0,  8,
/* 0x03c0 */ 136,  3,  0,  0, 84, 11,232,254, 84,  2,  7,126, 56, 96,250,  0,
/* 0x03d0 */ 124, 99, 88, 48, 56, 99,241,124,124, 38, 11,120,124, 33, 26, 20,
/* 0x03e0 */  84, 33,  0, 52, 56,  0,  0,  0,124,195, 51,120,144,  9,  0,  0,
/* 0x03f0 */ 148,  3,255,252,124,  1, 24, 64, 65,128,255,248,144,193,  0,  0,
/* 0x0400 */ 136,  4,255,255,144,225,  0,  8, 56,193,  0, 16,145, 33,  0, 12,
/* 0x0410 */  56, 97,  0, 20, 84, 11,225, 62, 84,  0,  7, 62,152, 67,  0,  2,
/* 0x0420 */ 153, 99,  0,  1,152,  3,  0,  0,124,  8,  2,166,148, 33,255,160,
/* 0x0430 */ 189,193,  0, 24,144,  1,  0,100, 59, 32,  0,  0,137, 67,  0,  2,
/* 0x0440 */ 137, 99,  0,  1,138, 67,  0,  0,147, 38,  0,  0,147, 41,  0,  0,
/* 0x0450 */ 136,  3,  0,  1,125, 40,  3,166,124, 18,  2, 20, 57, 32,  3,  0,
/* 0x0460 */ 125, 41,  0, 48, 56,  9,  7, 54,127,153,  0, 64, 57, 32,  0,  1,
/* 0x0470 */ 125, 43, 88, 48,125, 41, 80, 48, 57, 41,255,255, 57,107,255,255,
/* 0x0480 */ 145, 33,  0,  8,124,206, 51,120,124,147, 35,120,124,245, 59,120,
/* 0x0490 */ 125, 20, 67,120,145, 97,  0, 12, 59,  3,  0,  4, 59,224,  0,  0,
/* 0x04a0 */  58,224,  0,  0, 59, 64,  0,  1, 58, 32,  0,  1, 58,  0,  0,  1,
/* 0x04b0 */  57,224,  0,  1, 57, 32,  0,  0, 64,156,  0, 28,124,  9,  3,166,
/* 0x04c0 */  57, 96,  4,  0, 85, 32,  8, 60,125,120,  3, 46, 57, 41,  0,  1,
/* 0x04d0 */  66,  0,255,244,127,179, 42, 20,126,108,155,120, 56,160,  0,  0,
/* 0x04e0 */  57,  0,255,255, 57, 96,  0,  0,127,140,232,  0, 57,107,  0,  1,
/* 0x04f0 */  47, 11,  0,  4, 84,169, 64, 46, 65,158,  8,156,136, 12,  0,  0,
/* 0x0500 */  57,140,  0,  1,125, 37,  3,120, 64,153,255,224,127,153,160, 64,
/* 0x0510 */  64,156,  8,100, 62,192,  0,255, 98,214,255,255,128,  1,  0,  8,
/* 0x0520 */ 127,136,176, 64,127, 35,  0, 56, 86,224, 32, 54,124,  0, 26, 20,
/* 0x0530 */  84,  6,  8, 60, 65,157,  0, 32,127,140,232,  0, 65,158,  8, 88,
/* 0x0540 */ 137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46,
/* 0x0550 */  57,140,  0,  1,124,230,194, 46, 85,  0,170,254,125, 64, 57,214,
/* 0x0560 */ 127,133, 80, 64, 64,156,  1,172,128,  1,  0, 12, 47,151,  0,  6,
/* 0x0570 */ 127, 41,  0, 56, 32, 18,  0,  8,127,224,  6, 48,125, 41,144, 48,
/* 0x0580 */ 125, 41,  2, 20, 29, 41,  6,  0, 32,  7,  8,  0,124,  0, 46,112,
/* 0x0590 */ 124,  7,  2, 20,125, 56, 74, 20,124,  6,195, 46,125, 72, 83,120,
/* 0x05a0 */  56,201, 14,108, 56, 96,  0,  1, 64,157,  0,180,124, 26,200, 80,
/* 0x05b0 */  63, 96,  0,255,127,245,  0,174, 99,123,255,255, 87,255,  8, 60,
/* 0x05c0 */  87,252,  5,238,127,136,216, 64, 87,128,  8, 60, 84,100,  8, 60,
/* 0x05d0 */ 124,  6,  2, 20,127, 12,232,  0, 84,169, 64, 46,124,224, 34, 20,
/* 0x05e0 */  65,157,  0, 24, 65,154,  7,176,136, 12,  0,  0, 85,  8, 64, 46,
/* 0x05f0 */  57,140,  0,  1,125, 37,  3,120,161,103,  2,  0, 85,  0,170,254,
/* 0x0600 */ 125, 64, 89,214, 32, 11,  8,  0,127,133, 80, 64,124,  0, 46,112,
/* 0x0610 */  85,105,217,126,124, 11,  2, 20, 47, 28,  0,  0,125,105, 88, 80,
/* 0x0620 */ 124,131, 35,120,125, 10, 64, 80, 64,156,  0, 20,176,  7,  2,  0,
/* 0x0630 */ 125, 72, 83,120, 65,186,  0, 24, 72,  0,  0, 28,177,103,  2,  0,
/* 0x0640 */ 124,170, 40, 80, 56,100,  0,  1, 65,154,  0, 12, 47,131,  0,255,
/* 0x0650 */  64,157,255,108, 47,131,  0,255, 65,157,  0,132, 63,224,  0,255,
/* 0x0660 */  99,255,255,255,127,136,248, 64, 84,103,  8, 60,127, 12,232,  0,
/* 0x0670 */  84,169, 64, 46,124,227, 59,120, 65,157,  0, 24, 65,154,  7, 24,
/* 0x0680 */ 136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,
/* 0x0690 */ 125,102, 58, 46, 85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,
/* 0x06a0 */ 127,133, 80, 64,124,  0, 46,112, 85,105,217,126,124, 11,  2, 20,
/* 0x06b0 */ 125, 10, 64, 80,125,105, 88, 80, 64,156,  0, 16,125, 72, 83,120,
/* 0x06c0 */ 124,  6, 59, 46, 72,  0,  0, 16,124,170, 40, 80,125,102, 59, 46,
/* 0x06d0 */  56,103,  0,  1, 47,131,  0,255, 64,157,255,140, 47,151,  0,  3,
/* 0x06e0 */  84,127,  6, 62,127,249,169,174, 59, 57,  0,  1, 65,157,  0, 12,
/* 0x06f0 */  58,224,  0,  0, 72,  0,  6,120, 47,151,  0,  9, 65,157,  0, 12,
/* 0x0700 */  58,247,255,253, 72,  0,  6,104, 58,247,255,250, 72,  0,  6, 96,
/* 0x0710 */ 125, 10, 64, 80,127,136,176, 64, 84,224,217,126,124,  0, 56, 80,
/* 0x0720 */  86,233,  8, 60,124,  6,195, 46,124,170, 40, 80,124,248, 74, 20,
/* 0x0730 */  65,157,  0, 32,127,140,232,  0, 65,158,  6, 92,137, 44,  0,  0,
/* 0x0740 */  84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x0750 */ 161,103,  1,128, 85,  0,170,254,125, 64, 89,214,127,133, 80, 64,
/* 0x0760 */  64,156,  0, 64, 32, 11,  8,  0, 47,151,  0,  6,124,  0, 46,112,
/* 0x0770 */ 124, 11,  2, 20,176,  7,  1,128,126, 15,131,120,125, 72, 83,120,
/* 0x0780 */ 126, 48,139,120, 56,  0,  0,  0,127, 81,211,120, 64,157,  0,  8,
/* 0x0790 */  56,  0,  0,  3,124, 23,  3,120, 56,216,  6,100, 72,  0,  2, 24,
/* 0x07a0 */ 125, 10, 64, 80,127,136,176, 64, 85, 96,217,126,124,  0, 88, 80,
/* 0x07b0 */ 124,170, 40, 80,176,  7,  1,128, 65,157,  0, 32,127,140,232,  0,
/* 0x07c0 */  65,158,  5,212,137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120,
/* 0x07d0 */  85,  8, 64, 46, 57,140,  0,  1,161,103,  1,152, 85,  0,170,254,
/* 0x07e0 */ 125, 64, 89,214,127,133, 80, 64, 64,156,  0,188, 32, 11,  8,  0,
/* 0x07f0 */ 127,138,176, 64,124,  0, 46,112, 86,233, 40, 52,124, 11,  2, 20,
/* 0x0800 */ 125, 56, 74, 20, 84,107,  8, 60,176,  7,  1,152,125, 72, 83,120,
/* 0x0810 */ 124,233, 90, 20, 65,157,  0, 32,127,140,232,  0, 65,158,  5,120,
/* 0x0820 */ 137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120, 85, 72, 64, 46,
/* 0x0830 */  57,140,  0,  1,161,103,  1,224, 85,  0,170,254,125, 64, 89,214,
/* 0x0840 */ 127,133, 80, 64, 64,156,  0, 72, 32, 11,  8,  0, 47,153,  0,  0,
/* 0x0850 */ 124,  0, 46,112,124, 11,  2, 20,176,  7,  1,224,125, 72, 83,120,
/* 0x0860 */  65,158,  5, 52, 47,151,  0,  6, 57, 32,  0,  9, 64,157,  0,  8,
/* 0x0870 */  57, 32,  0, 11,124, 26,200, 80,127,245,  0,174,125, 55, 75,120,
/* 0x0880 */ 127,249,169,174, 59, 57,  0,  1, 72,  0,  4,228, 85, 96,217,126,
/* 0x0890 */ 124,  0, 88, 80,124,170, 40, 80,125, 10, 64, 80,176,  7,  1,224,
/* 0x08a0 */  72,  0,  0,252,125, 10, 64, 80,127,136,176, 64, 85, 96,217,126,
/* 0x08b0 */ 124,  0, 88, 80,124,170, 40, 80,176,  7,  1,152, 65,157,  0, 32,
/* 0x08c0 */ 127,140,232,  0, 65,158,  4,208,137, 44,  0,  0, 84,160, 64, 46,
/* 0x08d0 */ 124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,161,103,  1,176,
/* 0x08e0 */  85,  0,170,254,125, 64, 89,214,127,133, 80, 64, 64,156,  0, 32,
/* 0x08f0 */  32, 11,  8,  0,124,  0, 46,112,124, 11,  2, 20,125, 72, 83,120,
/* 0x0900 */ 126, 41,139,120,176,  7,  1,176, 72,  0,  0,140,125, 10, 64, 80,
/* 0x0910 */ 127,136,176, 64, 85, 96,217,126,124,  0, 88, 80,124,170, 40, 80,
/* 0x0920 */ 176,  7,  1,176, 65,157,  0, 32,127,140,232,  0, 65,158,  4,104,
/* 0x0930 */ 137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46,
/* 0x0940 */  57,140,  0,  1,161,103,  1,200, 85,  0,170,254,125, 64, 89,214,
/* 0x0950 */ 127,133, 80, 64, 64,156,  0, 32, 32, 11,  8,  0,124,  0, 46,112,
/* 0x0960 */ 124, 11,  2, 20,125, 72, 83,120,126,  9,131,120,176,  7,  1,200,
/* 0x0970 */  72,  0,  0, 32, 85, 96,217,126,124,  0, 88, 80,125,233,123,120,
/* 0x0980 */ 176,  7,  1,200,124,170, 40, 80,125, 10, 64, 80,126, 15,131,120,
/* 0x0990 */ 126, 48,139,120,127, 81,211,120,125, 58, 75,120, 47,151,  0,  6,
/* 0x09a0 */  56,  0,  0,  8, 64,157,  0,  8, 56,  0,  0, 11,124, 23,  3,120,
/* 0x09b0 */  56,216, 10,104,127,136,176, 64, 65,157,  0, 32,127,140,232,  0,
/* 0x09c0 */  65,158,  3,212,137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120,
/* 0x09d0 */  85,  8, 64, 46, 57,140,  0,  1,161,102,  0,  0, 85,  0,170,254,
/* 0x09e0 */ 125, 64, 89,214,127,133, 80, 64, 64,156,  0, 48, 32, 11,  8,  0,
/* 0x09f0 */  84,105, 32, 54,125, 38, 74, 20,124,  0, 46,112,124, 11,  2, 20,
/* 0x0a00 */ 125, 72, 83,120, 56,137,  0,  4, 59,128,  0,  0, 59, 96,  0,  3,
/* 0x0a10 */ 176,  6,  0,  0, 72,  0,  0,156,125, 10, 64, 80,127,136,176, 64,
/* 0x0a20 */  85, 96,217,126,124,  0, 88, 80,124,170, 40, 80,176,  6,  0,  0,
/* 0x0a30 */  65,157,  0, 32,127,140,232,  0, 65,158,  3, 92,137, 44,  0,  0,
/* 0x0a40 */  84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x0a50 */ 161,102,  0,  2, 85,  0,170,254,125, 64, 89,214,127,133, 80, 64,
/* 0x0a60 */  64,156,  0, 48, 32, 11,  8,  0, 84,105, 32, 54,125, 38, 74, 20,
/* 0x0a70 */ 124,  0, 46,112,124, 11,  2, 20,125, 72, 83,120, 56,137,  1,  4,
/* 0x0a80 */  59,128,  0,  8, 59, 96,  0,  3,176,  6,  0,  2, 72,  0,  0, 36,
/* 0x0a90 */  85, 96,217,126,124,  0, 88, 80,124,170, 40, 80,176,  6,  0,  2,
/* 0x0aa0 */ 125, 10, 64, 80, 56,134,  2,  4, 59,128,  0, 16, 59, 96,  0,  8,
/* 0x0ab0 */ 127,105,  3,166, 63,224,  0,255, 99,255,255,255, 56, 96,  0,  1,
/* 0x0ac0 */ 127,136,248, 64, 84,103,  8, 60,127, 12,232,  0, 84,169, 64, 46,
/* 0x0ad0 */ 124,227, 59,120, 65,157,  0, 24, 65,154,  2,188,136, 12,  0,  0,
/* 0x0ae0 */  85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,125,100, 58, 46,
/* 0x0af0 */  85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,127,133, 80, 64,
/* 0x0b00 */ 124,  0, 46,112, 85,105,217,126,124, 11,  2, 20,125, 10, 64, 80,
/* 0x0b10 */ 125,105, 88, 80, 64,156,  0, 16,125, 72, 83,120,124,  4, 59, 46,
/* 0x0b20 */  72,  0,  0, 16,124,170, 40, 80, 56,103,  0,  1,125,100, 59, 46,
/* 0x0b30 */  66,  0,255,144, 56,  0,  0,  1, 47,151,  0,  3,124,  0,216, 48,
/* 0x0b40 */ 124, 96, 24, 80,124, 99,226, 20, 65,157,  1,232, 47,131,  0,  3,
/* 0x0b50 */  58,247,  0,  7,124,105, 27,120, 64,157,  0,  8, 57, 32,  0,  3,
/* 0x0b60 */  85, 41, 56, 48,125, 56, 74, 20, 56,201,  3, 96, 57, 32,  0,  6,
/* 0x0b70 */ 125, 41,  3,166, 63,224,  0,255, 99,255,255,255, 56,128,  0,  1,
/* 0x0b80 */ 127,136,248, 64, 84,135,  8, 60,127, 12,232,  0, 84,169, 64, 46,
/* 0x0b90 */ 124,228, 59,120, 65,157,  0, 24, 65,154,  1,252,136, 12,  0,  0,
/* 0x0ba0 */  85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,125,102, 58, 46,
/* 0x0bb0 */  85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,127,133, 80, 64,
/* 0x0bc0 */ 124,  0, 46,112, 85,105,217,126,124, 11,  2, 20,125, 10, 64, 80,
/* 0x0bd0 */ 125,105, 88, 80, 64,156,  0, 16,125, 72, 83,120,124,  6, 59, 46,
/* 0x0be0 */  72,  0,  0, 16,124,170, 40, 80, 56,135,  0,  1,125,102, 59, 46,
/* 0x0bf0 */  66,  0,255,144, 56,132,255,192, 47,132,  0,  3,124,154, 35,120,
/* 0x0c00 */  64,157,  1, 40, 47,132,  0, 13,124,137, 14,112, 84,128,  7,254,
/* 0x0c10 */  57,105,255,255, 96, 26,  0,  2,125,105,  3,166, 65,157,  0, 32,
/* 0x0c20 */ 127, 90, 88, 48, 87, 73,  8, 60,125, 56, 74, 20, 84,128,  8, 60,
/* 0x0c30 */ 125, 32, 72, 80, 56,201,  5, 94, 72,  0,  0,100, 57, 41,255,251,
/* 0x0c40 */ 125, 41,  3,166, 61, 96,  0,255, 97,107,255,255,127,136, 88, 64,
/* 0x0c50 */ 127, 12,232,  0, 84,169, 64, 46, 87, 90,  8, 60, 65,157,  0, 24,
/* 0x0c60 */  65,154,  1, 52,136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x0c70 */ 125, 37,  3,120, 85,  8,248,126,127,133, 64, 64, 65,156,  0, 12,
/* 0x0c80 */ 124,168, 40, 80, 99, 90,  0,  1, 66,  0,255,196, 56,  0,  0,  4,
/* 0x0c90 */ 124,  9,  3,166, 87, 90, 32, 54, 56,216,  6, 68, 60,128,  0,255,
/* 0x0ca0 */  96,132,255,255, 59,128,  0,  1, 59,224,  0,  1,127,136, 32, 64,
/* 0x0cb0 */  87,231,  8, 60,127, 12,232,  0, 84,169, 64, 46,124,255, 59,120,
/* 0x0cc0 */  65,157,  0, 24, 65,154,  0,208,136, 12,  0,  0, 85,  8, 64, 46,
/* 0x0cd0 */  57,140,  0,  1,125, 37,  3,120,125,102, 58, 46, 85,  0,170,254,
/* 0x0ce0 */ 125, 64, 89,214, 32, 11,  8,  0,127,133, 80, 64,124,  0, 46,112,
/* 0x0cf0 */  85,105,217,126,124, 11,  2, 20,125, 10, 64, 80,125,105, 88, 80,
/* 0x0d00 */  64,156,  0, 16,125, 72, 83,120,124,  6, 59, 46, 72,  0,  0, 20,
/* 0x0d10 */ 124,170, 40, 80, 59,231,  0,  1,125,102, 59, 46,127, 90,227,120,
/* 0x0d20 */  87,156,  8, 60, 66,  0,255,136, 55, 90,  0,  1, 65,130,  0, 72,
/* 0x0d30 */ 127,154,200, 64, 56, 99,  0,  2, 65,157,  0, 92,124, 26,200, 80,
/* 0x0d40 */ 127,245,  0,174, 56, 99,255,255,127,249,169,174, 59, 57,  0,  1,
/* 0x0d50 */  49, 99,255,255,125, 43, 25, 16,124, 20,200, 16,124,  0,  1, 16,
/* 0x0d60 */ 124,  0,  0,208,125, 43,  0, 57, 64,130,255,212,127,153,160, 64,
/* 0x0d70 */  65,156,247,172, 60,  0,  0,255, 96,  0,255,255,127,136,  0, 64,
/* 0x0d80 */  65,157,  0, 32,127,140,232,  0, 56, 96,  0,  1, 65,158,  0, 40,
/* 0x0d90 */  72,  0,  0, 12, 56, 96,  0,  1, 72,  0,  0, 28, 57,140,  0,  1,
/* 0x0da0 */ 125, 40,  2,166,124, 19, 96, 80,144, 14,  0,  0, 56, 96,  0,  0,
/* 0x0db0 */ 147, 41,  0,  0,128,  1,  0,100,185,193,  0, 24,124,  8,  3,166,
/* 0x0dc0 */  56, 33,  0, 96,124,  8,  2,166,148, 33,255,160,189,193,  0, 24,
/* 0x0dd0 */ 144,  1,  0,100, 59, 32,  0,  0,137, 67,  0,  2,137, 99,  0,  1,
/* 0x0de0 */ 138, 67,  0,  0,147, 38,  0,  0,147, 41,  0,  0,136,  3,  0,  1,
/* 0x0df0 */ 125, 40,  3,166,124, 18,  2, 20, 57, 32,  3,  0,125, 41,  0, 48,
/* 0x0e00 */  56,  9,  7, 54,127,153,  0, 64, 57, 32,  0,  1,125, 43, 88, 48,
/* 0x0e10 */ 125, 41, 80, 48, 57, 41,255,255, 57,107,255,255,145, 33,  0,  8,
/* 0x0e20 */ 124,206, 51,120,124,147, 35,120,124,245, 59,120,125, 20, 67,120,
/* 0x0e30 */ 145, 97,  0, 12, 59,  3,  0,  4, 59,224,  0,  0, 58,224,  0,  0,
/* 0x0e40 */  59, 64,  0,  1, 58, 32,  0,  1, 58,  0,  0,  1, 57,224,  0,  1,
/* 0x0e50 */  57, 32,  0,  0, 64,156,  0, 28,124,  9,  3,166, 57, 96,  4,  0,
/* 0x0e60 */  85, 32,  8, 60,125,120,  3, 46, 57, 41,  0,  1, 66,  0,255,244,
/* 0x0e70 */ 127,179, 42, 20,126,108,155,120, 56,160,  0,  0, 57,  0,255,255,
/* 0x0e80 */  57, 96,  0,  0,127,140,232,  0, 57,107,  0,  1, 47, 11,  0,  4,
/* 0x0e90 */  84,169, 64, 46, 65,158,  8,156,136, 12,  0,  0, 57,140,  0,  1,
/* 0x0ea0 */ 125, 37,  3,120, 64,153,255,224,127,153,160, 64, 64,156,  8,100,
/* 0x0eb0 */  62,192,  0,255, 98,214,255,255,128,  1,  0,  8,127,136,176, 64,
/* 0x0ec0 */ 127, 35,  0, 56, 86,224, 32, 54,124,  0, 26, 20, 84,  6,  8, 60,
/* 0x0ed0 */  65,157,  0, 32,127,140,232,  0, 65,158,  8, 88,137, 44,  0,  0,
/* 0x0ee0 */  84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x0ef0 */ 124,230,194, 46, 85,  0,170,254,125, 64, 57,214,127,133, 80, 64,
/* 0x0f00 */  64,156,  1,172,128,  1,  0, 12, 47,151,  0,  6,127, 41,  0, 56,
/* 0x0f10 */  32, 18,  0,  8,127,224,  6, 48,125, 41,144, 48,125, 41,  2, 20,
/* 0x0f20 */  29, 41,  6,  0, 32,  7,  8,  0,124,  0, 46,112,124,  7,  2, 20,
/* 0x0f30 */ 125, 56, 74, 20,124,  6,195, 46,125, 72, 83,120, 56,201, 14,108,
/* 0x0f40 */  56, 96,  0,  1, 64,157,  0,180,124, 26,200, 80, 63, 96,  0,255,
/* 0x0f50 */ 127,245,  0,174, 99,123,255,255, 87,255,  8, 60, 87,252,  5,238,
/* 0x0f60 */ 127,136,216, 64, 87,128,  8, 60, 84,100,  8, 60,124,  6,  2, 20,
/* 0x0f70 */ 127, 12,232,  0, 84,169, 64, 46,124,224, 34, 20, 65,157,  0, 24,
/* 0x0f80 */  65,154,  7,176,136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x0f90 */ 125, 37,  3,120,161,103,  2,  0, 85,  0,170,254,125, 64, 89,214,
/* 0x0fa0 */  32, 11,  8,  0,127,133, 80, 64,124,  0, 46,112, 85,105,217,126,
/* 0x0fb0 */ 124, 11,  2, 20, 47, 28,  0,  0,125,105, 88, 80,124,131, 35,120,
/* 0x0fc0 */ 125, 10, 64, 80, 64,156,  0, 20,176,  7,  2,  0,125, 72, 83,120,
/* 0x0fd0 */  65,186,  0, 24, 72,  0,  0, 28,177,103,  2,  0,124,170, 40, 80,
/* 0x0fe0 */  56,100,  0,  1, 65,154,  0, 12, 47,131,  0,255, 64,157,255,108,
/* 0x0ff0 */  47,131,  0,255, 65,157,  0,132, 63,224,  0,255, 99,255,255,255,
/* 0x1000 */ 127,136,248, 64, 84,103,  8, 60,127, 12,232,  0, 84,169, 64, 46,
/* 0x1010 */ 124,227, 59,120, 65,157,  0, 24, 65,154,  7, 24,136, 12,  0,  0,
/* 0x1020 */  85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,125,102, 58, 46,
/* 0x1030 */  85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,127,133, 80, 64,
/* 0x1040 */ 124,  0, 46,112, 85,105,217,126,124, 11,  2, 20,125, 10, 64, 80,
/* 0x1050 */ 125,105, 88, 80, 64,156,  0, 16,125, 72, 83,120,124,  6, 59, 46,
/* 0x1060 */  72,  0,  0, 16,124,170, 40, 80,125,102, 59, 46, 56,103,  0,  1,
/* 0x1070 */  47,131,  0,255, 64,157,255,140, 47,151,  0,  3, 84,127,  6, 62,
/* 0x1080 */ 127,249,169,174, 59, 57,  0,  1, 65,157,  0, 12, 58,224,  0,  0,
/* 0x1090 */  72,  0,  6,120, 47,151,  0,  9, 65,157,  0, 12, 58,247,255,253,
/* 0x10a0 */  72,  0,  6,104, 58,247,255,250, 72,  0,  6, 96,125, 10, 64, 80,
/* 0x10b0 */ 127,136,176, 64, 84,224,217,126,124,  0, 56, 80, 86,233,  8, 60,
/* 0x10c0 */ 124,  6,195, 46,124,170, 40, 80,124,248, 74, 20, 65,157,  0, 32,
/* 0x10d0 */ 127,140,232,  0, 65,158,  6, 92,137, 44,  0,  0, 84,160, 64, 46,
/* 0x10e0 */ 124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,161,103,  1,128,
/* 0x10f0 */  85,  0,170,254,125, 64, 89,214,127,133, 80, 64, 64,156,  0, 64,
/* 0x1100 */  32, 11,  8,  0, 47,151,  0,  6,124,  0, 46,112,124, 11,  2, 20,
/* 0x1110 */ 176,  7,  1,128,126, 15,131,120,125, 72, 83,120,126, 48,139,120,
/* 0x1120 */  56,  0,  0,  0,127, 81,211,120, 64,157,  0,  8, 56,  0,  0,  3,
/* 0x1130 */ 124, 23,  3,120, 56,216,  6,100, 72,  0,  2, 24,125, 10, 64, 80,
/* 0x1140 */ 127,136,176, 64, 85, 96,217,126,124,  0, 88, 80,124,170, 40, 80,
/* 0x1150 */ 176,  7,  1,128, 65,157,  0, 32,127,140,232,  0, 65,158,  5,212,
/* 0x1160 */ 137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46,
/* 0x1170 */  57,140,  0,  1,161,103,  1,152, 85,  0,170,254,125, 64, 89,214,
/* 0x1180 */ 127,133, 80, 64, 64,156,  0,188, 32, 11,  8,  0,127,138,176, 64,
/* 0x1190 */ 124,  0, 46,112, 86,233, 40, 52,124, 11,  2, 20,125, 56, 74, 20,
/* 0x11a0 */  84,107,  8, 60,176,  7,  1,152,125, 72, 83,120,124,233, 90, 20,
/* 0x11b0 */  65,157,  0, 32,127,140,232,  0, 65,158,  5,120,137, 44,  0,  0,
/* 0x11c0 */  84,160, 64, 46,124,  5, 75,120, 85, 72, 64, 46, 57,140,  0,  1,
/* 0x11d0 */ 161,103,  1,224, 85,  0,170,254,125, 64, 89,214,127,133, 80, 64,
/* 0x11e0 */  64,156,  0, 72, 32, 11,  8,  0, 47,153,  0,  0,124,  0, 46,112,
/* 0x11f0 */ 124, 11,  2, 20,176,  7,  1,224,125, 72, 83,120, 65,158,  5, 52,
/* 0x1200 */  47,151,  0,  6, 57, 32,  0,  9, 64,157,  0,  8, 57, 32,  0, 11,
/* 0x1210 */ 124, 26,200, 80,127,245,  0,174,125, 55, 75,120,127,249,169,174,
/* 0x1220 */  59, 57,  0,  1, 72,  0,  4,228, 85, 96,217,126,124,  0, 88, 80,
/* 0x1230 */ 124,170, 40, 80,125, 10, 64, 80,176,  7,  1,224, 72,  0,  0,252,
/* 0x1240 */ 125, 10, 64, 80,127,136,176, 64, 85, 96,217,126,124,  0, 88, 80,
/* 0x1250 */ 124,170, 40, 80,176,  7,  1,152, 65,157,  0, 32,127,140,232,  0,
/* 0x1260 */  65,158,  4,208,137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120,
/* 0x1270 */  85,  8, 64, 46, 57,140,  0,  1,161,103,  1,176, 85,  0,170,254,
/* 0x1280 */ 125, 64, 89,214,127,133, 80, 64, 64,156,  0, 32, 32, 11,  8,  0,
/* 0x1290 */ 124,  0, 46,112,124, 11,  2, 20,125, 72, 83,120,126, 41,139,120,
/* 0x12a0 */ 176,  7,  1,176, 72,  0,  0,140,125, 10, 64, 80,127,136,176, 64,
/* 0x12b0 */  85, 96,217,126,124,  0, 88, 80,124,170, 40, 80,176,  7,  1,176,
/* 0x12c0 */  65,157,  0, 32,127,140,232,  0, 65,158,  4,104,137, 44,  0,  0,
/* 0x12d0 */  84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x12e0 */ 161,103,  1,200, 85,  0,170,254,125, 64, 89,214,127,133, 80, 64,
/* 0x12f0 */  64,156,  0, 32, 32, 11,  8,  0,124,  0, 46,112,124, 11,  2, 20,
/* 0x1300 */ 125, 72, 83,120,126,  9,131,120,176,  7,  1,200, 72,  0,  0, 32,
/* 0x1310 */  85, 96,217,126,124,  0, 88, 80,125,233,123,120,176,  7,  1,200,
/* 0x1320 */ 124,170, 40, 80,125, 10, 64, 80,126, 15,131,120,126, 48,139,120,
/* 0x1330 */ 127, 81,211,120,125, 58, 75,120, 47,151,  0,  6, 56,  0,  0,  8,
/* 0x1340 */  64,157,  0,  8, 56,  0,  0, 11,124, 23,  3,120, 56,216, 10,104,
/* 0x1350 */ 127,136,176, 64, 65,157,  0, 32,127,140,232,  0, 65,158,  3,212,
/* 0x1360 */ 137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46,
/* 0x1370 */  57,140,  0,  1,161,102,  0,  0, 85,  0,170,254,125, 64, 89,214,
/* 0x1380 */ 127,133, 80, 64, 64,156,  0, 48, 32, 11,  8,  0, 84,105, 32, 54,
/* 0x1390 */ 125, 38, 74, 20,124,  0, 46,112,124, 11,  2, 20,125, 72, 83,120,
/* 0x13a0 */  56,137,  0,  4, 59,128,  0,  0, 59, 96,  0,  3,176,  6,  0,  0,
/* 0x13b0 */  72,  0,  0,156,125, 10, 64, 80,127,136,176, 64, 85, 96,217,126,
/* 0x13c0 */ 124,  0, 88, 80,124,170, 40, 80,176,  6,  0,  0, 65,157,  0, 32,
/* 0x13d0 */ 127,140,232,  0, 65,158,  3, 92,137, 44,  0,  0, 84,160, 64, 46,
/* 0x13e0 */ 124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,161,102,  0,  2,
/* 0x13f0 */  85,  0,170,254,125, 64, 89,214,127,133, 80, 64, 64,156,  0, 48,
/* 0x1400 */  32, 11,  8,  0, 84,105, 32, 54,125, 38, 74, 20,124,  0, 46,112,
/* 0x1410 */ 124, 11,  2, 20,125, 72, 83,120, 56,137,  1,  4, 59,128,  0,  8,
/* 0x1420 */  59, 96,  0,  3,176,  6,  0,  2, 72,  0,  0, 36, 85, 96,217,126,
/* 0x1430 */ 124,  0, 88, 80,124,170, 40, 80,176,  6,  0,  2,125, 10, 64, 80,
/* 0x1440 */  56,134,  2,  4, 59,128,  0, 16, 59, 96,  0,  8,127,105,  3,166,
/* 0x1450 */  63,224,  0,255, 99,255,255,255, 56, 96,  0,  1,127,136,248, 64,
/* 0x1460 */  84,103,  8, 60,127, 12,232,  0, 84,169, 64, 46,124,227, 59,120,
/* 0x1470 */  65,157,  0, 24, 65,154,  2,188,136, 12,  0,  0, 85,  8, 64, 46,
/* 0x1480 */  57,140,  0,  1,125, 37,  3,120,125,100, 58, 46, 85,  0,170,254,
/* 0x1490 */ 125, 64, 89,214, 32, 11,  8,  0,127,133, 80, 64,124,  0, 46,112,
/* 0x14a0 */  85,105,217,126,124, 11,  2, 20,125, 10, 64, 80,125,105, 88, 80,
/* 0x14b0 */  64,156,  0, 16,125, 72, 83,120,124,  4, 59, 46, 72,  0,  0, 16,
/* 0x14c0 */ 124,170, 40, 80, 56,103,  0,  1,125,100, 59, 46, 66,  0,255,144,
/* 0x14d0 */  56,  0,  0,  1, 47,151,  0,  3,124,  0,216, 48,124, 96, 24, 80,
/* 0x14e0 */ 124, 99,226, 20, 65,157,  1,232, 47,131,  0,  3, 58,247,  0,  7,
/* 0x14f0 */ 124,105, 27,120, 64,157,  0,  8, 57, 32,  0,  3, 85, 41, 56, 48,
/* 0x1500 */ 125, 56, 74, 20, 56,201,  3, 96, 57, 32,  0,  6,125, 41,  3,166,
/* 0x1510 */  63,224,  0,255, 99,255,255,255, 56,128,  0,  1,127,136,248, 64,
/* 0x1520 */  84,135,  8, 60,127, 12,232,  0, 84,169, 64, 46,124,228, 59,120,
/* 0x1530 */  65,157,  0, 24, 65,154,  1,252,136, 12,  0,  0, 85,  8, 64, 46,
/* 0x1540 */  57,140,  0,  1,125, 37,  3,120,125,102, 58, 46, 85,  0,170,254,
/* 0x1550 */ 125, 64, 89,214, 32, 11,  8,  0,127,133, 80, 64,124,  0, 46,112,
/* 0x1560 */  85,105,217,126,124, 11,  2, 20,125, 10, 64, 80,125,105, 88, 80,
/* 0x1570 */  64,156,  0, 16,125, 72, 83,120,124,  6, 59, 46, 72,  0,  0, 16,
/* 0x1580 */ 124,170, 40, 80, 56,135,  0,  1,125,102, 59, 46, 66,  0,255,144,
/* 0x1590 */  56,132,255,192, 47,132,  0,  3,124,154, 35,120, 64,157,  1, 40,
/* 0x15a0 */  47,132,  0, 13,124,137, 14,112, 84,128,  7,254, 57,105,255,255,
/* 0x15b0 */  96, 26,  0,  2,125,105,  3,166, 65,157,  0, 32,127, 90, 88, 48,
/* 0x15c0 */  87, 73,  8, 60,125, 56, 74, 20, 84,128,  8, 60,125, 32, 72, 80,
/* 0x15d0 */  56,201,  5, 94, 72,  0,  0,100, 57, 41,255,251,125, 41,  3,166,
/* 0x15e0 */  61, 96,  0,255, 97,107,255,255,127,136, 88, 64,127, 12,232,  0,
/* 0x15f0 */  84,169, 64, 46, 87, 90,  8, 60, 65,157,  0, 24, 65,154,  1, 52,
/* 0x1600 */ 136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,
/* 0x1610 */  85,  8,248,126,127,133, 64, 64, 65,156,  0, 12,124,168, 40, 80,
/* 0x1620 */  99, 90,  0,  1, 66,  0,255,196, 56,  0,  0,  4,124,  9,  3,166,
/* 0x1630 */  87, 90, 32, 54, 56,216,  6, 68, 60,128,  0,255, 96,132,255,255,
/* 0x1640 */  59,128,  0,  1, 59,224,  0,  1,127,136, 32, 64, 87,231,  8, 60,
/* 0x1650 */ 127, 12,232,  0, 84,169, 64, 46,124,255, 59,120, 65,157,  0, 24,
/* 0x1660 */  65,154,  0,208,136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x1670 */ 125, 37,  3,120,125,102, 58, 46, 85,  0,170,254,125, 64, 89,214,
/* 0x1680 */  32, 11,  8,  0,127,133, 80, 64,124,  0, 46,112, 85,105,217,126,
/* 0x1690 */ 124, 11,  2, 20,125, 10, 64, 80,125,105, 88, 80, 64,156,  0, 16,
/* 0x16a0 */ 125, 72, 83,120,124,  6, 59, 46, 72,  0,  0, 20,124,170, 40, 80,
/* 0x16b0 */  59,231,  0,  1,125,102, 59, 46,127, 90,227,120, 87,156,  8, 60,
/* 0x16c0 */  66,  0,255,136, 55, 90,  0,  1, 65,130,  0, 72,127,154,200, 64,
/* 0x16d0 */  56, 99,  0,  2, 65,157,  0, 92,124, 26,200, 80,127,245,  0,174,
/* 0x16e0 */  56, 99,255,255,127,249,169,174, 59, 57,  0,  1, 49, 99,255,255,
/* 0x16f0 */ 125, 43, 25, 16,124, 20,200, 16,124,  0,  1, 16,124,  0,  0,208,
/* 0x1700 */ 125, 43,  0, 57, 64,130,255,212,127,153,160, 64, 65,156,247,172,
/* 0x1710 */  60,  0,  0,255, 96,  0,255,255,127,136,  0, 64, 65,157,  0, 32,
/* 0x1720 */ 127,140,232,  0, 56, 96,  0,  1, 65,158,  0, 40, 72,  0,  0, 12,
/* 0x1730 */  56, 96,  0,  1, 72,  0,  0, 28, 57,140,  0,  1,125, 40,  2,166,
/* 0x1740 */ 124, 19, 96, 80,144, 14,  0,  0, 56, 96,  0,  0,147, 41,  0,  0,
/* 0x1750 */ 128,  1,  0,100,185,193,  0, 24,124,  8,  3,166, 56, 33,  0, 96,
/* 0x1760 */ 128,161,  0, 12,128,225,  0,  8,128,165,  0,  0,128, 33,  0,  0,
/* 0x1770 */ 124,165, 58, 20,128,  1,  0,  8, 56,165,255,255,124,  8,  3,166,
/* 0x1780 */ 128,230,  0,  0,125,168,  3,166,124,100, 24, 80,124,135, 40, 80,
/* 0x1790 */  56, 99,  0,  1, 56,132,  0,  1,144,134,  0,  0, 96,231,  0, 31,
/* 0x17a0 */ 124,  0, 56,108,124,  7, 40, 64,124,  0, 63,172, 56,231,  0, 32,
/* 0x17b0 */  65,128,255,240,124,  0,  4,172, 76,  0,  1, 44, 78,128,  0, 32,
/* 0x17c0 */  72,  0,  0,  1, 80, 82, 79, 84, 95, 69, 88, 69, 67,124, 80, 82,
/* 0x17d0 */  79, 84, 95, 87, 82, 73, 84, 69, 32,102, 97,105,108,101,100, 46,
/* 0x17e0 */  10,  0, 56,160,  0, 30,124,136,  2,166, 56, 96,  0,  2, 56,  0,
/* 0x17f0 */   0,  4, 68,  0,  0,  2, 56, 96,  0,127, 56,  0,  0,  1, 68,  0,
/* 0x1800 */   0,  2,127,200,  2,166, 57,  0,  0,  0, 56,224,255,255,128,126,
/* 0x1810 */   0,  4, 56,192,  0, 50, 56,160,  0,  7, 56,128, 16,  0,124, 99,
/* 0x1820 */ 242, 20, 56,  0,  0, 90, 56, 99, 16, 11, 84, 99,  0, 38, 68,  0,
/* 0x1830 */   0,  2, 65,131,  0,  0,127,233,  3,166,128, 30,  0,  0,136,254,
/* 0x1840 */   0,  8, 56,193,  0,124,144,  1,  0,124,124,101, 27,120,124,104,
/* 0x1850 */   3,166,128,158,  0,  4, 56,126,  0, 12, 56, 33,255,232, 78,128,
/* 0x1860 */   4, 32,148, 33,255,128,188, 65,  0,  4,127,232,  2,166, 75,255,
/* 0x1870 */ 255,149,102,105,108,101, 32,102,111,114,109, 97,116, 32,101,108,
/* 0x1880 */ 102, 51, 50, 45,112,111,119,101,114,112, 99, 10, 10, 83,101, 99,
/* 0x1890 */ 116,105,111,110,115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32,
/* 0x18a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32,
/* 0x18b0 */  32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65,
/* 0x18c0 */  32, 32, 32, 32, 32, 32, 32, 70,105,108,101, 32,111,102,102, 32,
/* 0x18d0 */  32, 65,108,103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48,
/* 0x18e0 */  32, 69, 76, 70, 77, 65, 73, 78, 88, 32, 32, 32, 32, 32, 32, 48,
/* 0x18f0 */  48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1900 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1910 */  48, 48, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1920 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,
/* 0x1930 */  65, 68, 79, 78, 76, 89, 10, 32, 32, 49, 32, 78, 82, 86, 95, 72,
/* 0x1940 */  69, 65, 68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1950 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1960 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 51, 56, 32,
/* 0x1970 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x1980 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 50, 32, 78, 82,
/* 0x1990 */  86, 50, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x19a0 */  48, 49, 52, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x19b0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x19c0 */  51, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x19d0 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x19e0 */  78, 76, 89, 10, 32, 32, 51, 32, 78, 82, 86, 50, 68, 32, 32, 32,
/* 0x19f0 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 49, 50, 99, 32, 32,
/* 0x1a00 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1a10 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 56, 48, 32, 32, 50, 42,
/* 0x1a20 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x1a30 */  76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32,
/* 0x1a40 */  52, 32, 78, 82, 86, 50, 66, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1a50 */  48, 48, 48, 48, 48, 48,102, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1a60 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1a70 */  48, 48, 48, 50, 97, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1a80 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x1a90 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 53, 32, 76, 90, 77, 65,
/* 0x1aa0 */  95, 69, 76, 70, 48, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1ab0 */  56, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1ac0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 57, 99,
/* 0x1ad0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x1ae0 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x1af0 */  89, 10, 32, 32, 54, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x1b00 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 57, 57, 99, 32, 32, 48, 48,
/* 0x1b10 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1b20 */  32, 32, 48, 48, 48, 48, 48, 52, 50, 56, 32, 32, 50, 42, 42, 48,
/* 0x1b30 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,
/* 0x1b40 */  79, 78, 76, 89, 10, 32, 32, 55, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x1b50 */  67, 50, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 57, 57, 99, 32,
/* 0x1b60 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1b70 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48,100, 99, 52, 32, 32, 50,
/* 0x1b80 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x1b90 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 56, 32, 76, 90, 77, 65,
/* 0x1ba0 */  95, 68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1bb0 */  50, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1bc0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 55, 54, 48,
/* 0x1bd0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x1be0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 57, 32, 78,
/* 0x1bf0 */  82, 86, 95, 84, 65, 73, 76, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x1c00 */  48, 48, 48, 49, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1c10 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,
/* 0x1c20 */  55, 56, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x1c30 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49,
/* 0x1c40 */  48, 32, 67, 70, 76, 85, 83, 72, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1c50 */  48, 48, 48, 48, 48, 48, 50, 52, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1c60 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1c70 */  48, 48, 49, 55, 57, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1c80 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x1c90 */  10, 32, 49, 49, 32, 69, 76, 70, 77, 65, 73, 78, 89, 32, 32, 32,
/* 0x1ca0 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 50, 50, 32, 32, 48, 48, 48,
/* 0x1cb0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1cc0 */  32, 48, 48, 48, 48, 49, 55, 99, 48, 32, 32, 50, 42, 42, 48, 32,
/* 0x1cd0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x1ce0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 50, 32, 69,
/* 0x1cf0 */  76, 70, 77, 65, 73, 78, 90, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x1d00 */  48, 48, 48, 57, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1d10 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,
/* 0x1d20 */  55,101, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x1d30 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x1d40 */  79, 78, 76, 89, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76,
/* 0x1d50 */  69, 58, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x1d60 */  32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,  9, 48,
/* 0x1d70 */  48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x1d80 */  51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x1d90 */  32,100, 32, 32, 78, 82, 86, 95, 84, 65, 73, 76,  9, 48, 48, 48,
/* 0x1da0 */  48, 48, 48, 48, 48, 32, 78, 82, 86, 95, 84, 65, 73, 76, 10, 48,
/* 0x1db0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x1dc0 */  69, 76, 70, 77, 65, 73, 78, 89,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x1dd0 */  48, 32, 69, 76, 70, 77, 65, 73, 78, 89, 10, 48, 48, 48, 48, 48,
/* 0x1de0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 76, 70, 77,
/* 0x1df0 */  65, 73, 78, 90,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 69, 76,
/* 0x1e00 */  70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1e10 */ 108, 32, 32, 32, 32,100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88,
/* 0x1e20 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 69, 76, 70, 77, 65, 73,
/* 0x1e30 */  78, 88, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x1e40 */  32,100, 32, 32, 78, 82, 86, 95, 72, 69, 65, 68,  9, 48, 48, 48,
/* 0x1e50 */  48, 48, 48, 48, 48, 32, 78, 82, 86, 95, 72, 69, 65, 68, 10, 48,
/* 0x1e60 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x1e70 */  78, 82, 86, 50, 69,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78,
/* 0x1e80 */  82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x1e90 */  32, 32, 32,100, 32, 32, 78, 82, 86, 50, 68,  9, 48, 48, 48, 48,
/* 0x1ea0 */  48, 48, 48, 48, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48,
/* 0x1eb0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50,
/* 0x1ec0 */  66,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 66,
/* 0x1ed0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x1ee0 */  32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,  9, 48, 48, 48,
/* 0x1ef0 */  48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,
/* 0x1f00 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x1f10 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,  9, 48, 48, 48,
/* 0x1f20 */  48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x1f30 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x1f40 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,  9, 48, 48, 48,
/* 0x1f50 */  48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x1f60 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x1f70 */  32, 32, 67, 70, 76, 85, 83, 72,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x1f80 */  48, 32, 67, 70, 76, 85, 83, 72, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x1f90 */  48, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x1fa0 */  78, 88,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 95,115,116, 97,
/* 0x1fb0 */ 114,116, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x1fc0 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69, 76, 70, 77,
/* 0x1fd0 */  65, 73, 78, 88, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x1fe0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1ff0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2000 */  32, 82, 95, 80, 80, 67, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32,
/* 0x2010 */  32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 43, 48,120, 48, 48,
/* 0x2020 */  48, 48, 48, 48, 56, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x2030 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x2040 */  78, 82, 86, 50, 69, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x2050 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2060 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 98,
/* 0x2070 */  52, 32, 82, 95, 80, 80, 67, 95, 82, 69, 76, 49, 52, 32, 32, 32,
/* 0x2080 */  32, 32, 32, 32, 78, 82, 86, 95, 84, 65, 73, 76, 10, 10, 82, 69,
/* 0x2090 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x20a0 */  32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 68, 93, 58, 10, 79, 70,
/* 0x20b0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x20c0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x20d0 */  48, 48, 48, 48, 48, 98, 52, 32, 82, 95, 80, 80, 67, 95, 82, 69,
/* 0x20e0 */  76, 49, 52, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 95, 84, 65,
/* 0x20f0 */  73, 76, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x2100 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50,
/* 0x2110 */  66, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x2120 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x2130 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 57, 48, 32, 82, 95,
/* 0x2140 */  80, 80, 67, 95, 82, 69, 76, 49, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2150 */  78, 82, 86, 95, 84, 65, 73, 76, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x2160 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x2170 */  32, 91, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 93, 58, 10, 79,
/* 0x2180 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x2190 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x21a0 */  48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 80, 80, 67, 95, 82,
/* 0x21b0 */  69, 76, 49, 52, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x21c0 */  68, 69, 67, 51, 48, 43, 48,120, 48, 48, 48, 48, 48, 48, 50, 48,
/* 0x21d0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x21e0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69, 76, 70, 77, 65, 73,
/* 0x21f0 */  78, 89, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x2200 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2210 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 82,
/* 0x2220 */  95, 80, 80, 67, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2230 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 10, 82, 69, 76, 79, 67,
/* 0x2240 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x2250 */  82, 32, 91, 69, 76, 70, 77, 65, 73, 78, 90, 93, 58, 10, 79, 70,
/* 0x2260 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x2270 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x2280 */  48, 48, 48, 48, 48, 53, 48, 32, 82, 95, 80, 80, 67, 95, 82, 69,
/* 0x2290 */  76, 49, 52, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x22a0 */  78, 89, 10
};
