
/*
 * GLX Server Extension
 * Copyright (C) 1996  Steven G. Parker  (sparker@cs.utah.edu)
 * Copyright (C) 1998, 1999  Terence Ripperda (ripperda@sgi.com)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * STEPHEN PARKER, TERENCE RIPPERDA, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR 
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef BUFFER_MACROS_H
#define BUFFER_MACROS_H 1

#include "GL/gl.h"
#include "GL/glx.h"
#include "GL/GLXproto.h"
#include "glxcommon.h"


/** some forward declarations for glx.c **/
/** other .c files use these and I want to reduce compiler warnings **/
void GLXRenderFlush();
void GLXLargeRenderFlush();

#define __GLX_FLUSH			\
   if (GLCurrent->isRenderLargeReq) {	\
      GLXLargeRenderFlush();		\
   } else {				\
      GLXRenderFlush();			\
   }


/* new buffer insertion macros */
#define __GLX_PUT_uint(p, d)			\
   *(GLuint *) p = (GLuint) d; p += sizeof(GLuint);

#define __GLX_PUT_int(p, d)			\
   *(GLint *) p = (GLint) d; p += sizeof(GLint);

#define __GLX_PUT_enum(p, d)			\
   *(GLenum *) p = (GLenum) d; p += sizeof(GLenum);

#define __GLX_PUT_float(p, d)			\
   *(GLfloat *) p = (GLfloat) d; p += sizeof(GLfloat);

#define __GLX_PUT_bitfield(p, d)		\
   *(GLbitfield *) p = (GLbitfield) d; p += sizeof(GLbitfield);

#define __GLX_PUT_double(p, d)			\
   *(GLdouble *) p = (GLdouble) d; p += sizeof(GLdouble);

#define __GLX_PUT_ushort(p, d)			\
   *(GLushort *) p = (GLushort) d; p += sizeof(GLushort);

#define __GLX_PUT_short(p, d)			\
   *(GLshort *) p = (GLshort) d; p += sizeof(GLshort);

#define __GLX_PUT_sizei(p, d)			\
   *(GLsizei *) p = (GLsizei) d; p += sizeof(GLsizei);

#define __GLX_PUT_boolean(p, d)			\
   *(GLboolean *) p = (GLboolean) d; p += sizeof(GLboolean);

#define __GLX_PUT_ubyte(p, d)			\
   *(GLubyte *) p = (GLubyte) d; p += sizeof(GLubyte);

#define __GLX_PUT_byte(p, d)			\
   *(GLbyte *) p = (GLbyte) d; p += sizeof(GLbyte);


#define __GLX_PUT_PIXEL_DATA_ARGUMENTS				\
    __GLX_PUT_byte(buffer, GLCurrent->Unpack.SwapBytes);	\
    __GLX_PUT_byte(buffer, GLCurrent->Unpack.LsbFirst);	\
    __GLX_PUT_short(buffer, 0);					\
    __GLX_PUT_uint(buffer, DEFAULT_UNPACK_ROW_LENGTH);		\
    __GLX_PUT_uint(buffer, DEFAULT_UNPACK_SKIP_ROWS);		\
    __GLX_PUT_uint(buffer, DEFAULT_UNPACK_SKIP_PIXELS);		\
    __GLX_PUT_uint(buffer, GLCurrent->Unpack.Alignment);


#define __GLX_PUT_buffer(dest, src, width, height, format, type, size)	\
   {									\
      if (size) {							\
         if (GLCurrent->need_unpacking) {				\
            if (type == GL_BITMAP) {					\
               PUT_unpacked_bitmap( dest, src, width, height);		\
            } else {							\
               PUT_unpacked_buffer( dest, src, width, height, format, type);\
            }								\
         } else {							\
            PUT_buffer( dest, src, size);				\
         }								\
      }									\
   }


/** XXX need check for packed_buffer & bitmaps **/
#define __GLX_GET_BUFFER(buffer, length, width, height, format, type)	\
   {									\
      char* p=(char*)malloc(length);					\
      _XRead(dpy, p, length);						\
      GET_packed_buffer((char *)buffer, (const unsigned char *) p, 	\
                        width, height, format, type);			\
      free(p);								\
   }



#define __GLX_GET_RENDER_BUFFER(buff_ptr, opcode, request_size, extra_size) \
   {									    \
      /* best check for large render vs. render? */			    \
      if (extra_size) {							    \
         /* large request */						    \
         buff_ptr = GET_render_large_buffer(request_size, extra_size,	    \
                                                 opcode, 1);		    \
      } else {								    \
         /* render request (or proxy?) */				    \
         if (GLCurrent->isRenderLargeReq) {				    \
            printf("REPORT ME: LARGE RENDER in GET_RENDER_BUFFER!!!\n");    \
            GLCurrent->bufferP = buff_ptr;				    \
            GLXLargeRenderFlush();					    \
            GLCurrent->bufferP = GLCurrent->bufferStart;		    \
         } else								    \
         if ( (GLCurrent->bufferP + request_size) > 			    \
               GLCurrent->bufferRenderEnd) {   				    \
            /* Flush it out... */					    \
            GLXRenderFlush();						    \
            GLCurrent->bufferP = GLCurrent->bufferStart;		    \
         }								    \
         buff_ptr = GLCurrent->bufferP;					    \
         GLCurrent->bufferP += request_size;				    \
         __GLX_PUT_short(buff_ptr, request_size);			    \
         __GLX_PUT_short(buff_ptr, opcode);				    \
      }									    \
   }

/** Macros for putting data in a true large render request **/

#define __GLX_DECLARE_LARGE_VARIABLES					\
   int highwater_mark = 0;						\
   int bytes_to_send = 0;						\
   int stride_bytes = 0;						\
   GLboolean is_large = GL_FALSE;

#define __GLX_START_LARGE_RENDER(stride_in_bytes)			\
   is_large = GLCurrent->isRenderLargeReq; 				\
   if (is_large) {							\
      stride_bytes = stride_in_bytes;					\
      highwater_mark = GLCurrent->largeReqMaxDataLen - stride_bytes;	\
      GLXLargeRenderFlush();						\
      dest = GLCurrent->bufferStart;					\
   }

#define __GLX_CHECK_LARGE_RENDER					\
   if (is_large) {							\
      bytes_to_send += stride_bytes; 					\
      if (bytes_to_send >= highwater_mark) { 				\
         /** time to flush a large request **/				\
         GLCurrent->largeReqDataLen = bytes_to_send;			\
         GLXLargeRenderFlush();						\
         bytes_to_send = 0;						\
         dest = GLCurrent->bufferStart;					\
      }									\
   }

#define __GLX_END_LARGE_RENDER						\
   if (is_large) {							\
      GLCurrent->largeReqDataLen = bytes_to_send;			\
      GLXLargeRenderFlush();						\
      GLCurrent->isRenderLargeReq = GL_FALSE;				\
   }

#endif
