/* $XFree86: xc/programs/Xserver/hw/xfree86/vga256/drivers/mga/mga.h,v 3.8.2.9 1998/12/27 13:10:16 dawes Exp $ */
/*
 * MGA Millennium (MGA2064W) functions
 *
 * Copyright 1996 The XFree86 Project, Inc.
 *
 * Authors
 *		Dirk Hohndel
 *			hohndel@XFree86.Org
 *		David Dawes
 *			dawes@XFree86.Org
 */

#ifndef MGA_H
#define MGA_H

#if defined(__alpha__)
#define mb() __asm__ __volatile__("mb": : :"memory")
#define INREG8(addr) xf86ReadSparse8(GLXSYM(MGAMMIOBase), (addr))
#define INREG16(addr) xf86ReadSparse16(GLXSYM(MGAMMIOBase), (addr))
#define INREG(addr) xf86ReadSparse32(GLXSYM(MGAMMIOBase), (addr))
#define OUTREG8(addr,val) do { xf86WriteSparse8((val),GLXSYM(MGAMMIOBase),(addr)); \
				mb();} while(0)
#define OUTREG16(addr,val) do { xf86WriteSparse16((val),GLXSYM(MGAMMIOBase),(addr)); \
				mb();} while(0)
#define OUTREG(addr, val) do { xf86WriteSparse32((val),GLXSYM(MGAMMIOBase),(addr)); \
				mb();} while(0)
#else /* __alpha__ */

#define INREG8(addr) *(volatile CARD8 *)(GLXSYM(MGAMMIOBase) + (addr))
#define INREG16(addr) *(volatile CARD16 *)(GLXSYM(MGAMMIOBase) + (addr))
#define INREG(addr) *(volatile CARD32 *)(GLXSYM(MGAMMIOBase) + (addr))
#define OUTREG8(addr, val) *(volatile CARD8 *)(GLXSYM(MGAMMIOBase) + (addr)) = (val)
#define OUTREG16(addr, val) *(volatile CARD16 *)(GLXSYM(MGAMMIOBase) + (addr)) = (val)
#define OUTREG(addr, val) *(volatile CARD32 *)(GLXSYM(MGAMMIOBase) + (addr)) = (val)
#endif /* __alpha__ */


#define MGA_IS_2164(chip) (((chip) == PCI_CHIP_MGA2164) || \
			   ((chip) == PCI_CHIP_MGA2164_AGP))
#define MGA_IS_G100(chip) (((chip) == PCI_CHIP_MGAG100) || \
			   ((chip) == PCI_CHIP_MGAG100_PCI))
#define MGA_IS_G200(chip) (((chip) == PCI_CHIP_MGAG200) || \
			   ((chip) == PCI_CHIP_MGAG200_PCI))

#define MGA_IS_G400(chip) ((chip) == PCI_CHIP_MGAG400)

#define MGA_IS_GCLASS(chip) (MGA_IS_G100(chip) || MGA_IS_G200(chip))

struct mga_ramdac {
    Bool	isHwCursor;
    int		CursorMaxWidth;
    int 	CursorMaxHeight;
    int		CursorFlags;
    void	(*LoadCursorImage)();
    void	(*ShowCursor)();
    void	(*HideCursor)();
    void	(*SetCursorPosition)();
    void	(*SetCursorColors)();
    long	maxPixelClock;
    long	MemoryClock;
};




#endif
