/*
 * GLX Hardware Device Driver for Matrox G200/G400
 * warp engine interface
 * Copyright (c) 1999 Ralph Giles
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * MATROX GRAPHICS INC., OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR 
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * some structures based on Warp Setup Engine DDK,
 * (c) 1999 Matrox Graphics Inc.
 * 
 */

#ifndef MGA_WARP_H
#define MGA_WARP_H


#include "mesaglx/types.h"	/* for base datatypes */


/* warp microcode routines are in the separate warp.h */

/* Public functions */
int mgaWarpInit(void);
void mgaWarpUpdateState(GLcontext *ctx);
void mgaWarpStartPrimitives( void );
void mgaWarpFinishPrimitives( void );
unsigned int mgaWarpPipeSize(void);


/* common datatypes for the mga warp engines */

/* 
 *  color type for the vertex data
 *  we probably want to use an internal datatype here?
 */
typedef struct mga_warp_color_t {
  GLubyte	blue;
  GLubyte       green;
  GLubyte       red;
  GLubyte       alpha;
} mga_warp_color;


/* 
 *  vertex type used for the single-warp g200
 */
typedef struct mga_warp_vertex_t {
  GLfloat		x,y,z;	        /* coordinates in screen space*/
  GLfloat 		rhw;	        /* reciprocal homogeneous w */
  mga_warp_color	color;		/* vertex color */
  mga_warp_color	specular;	/* specular color, alpha is fog */
  GLfloat		tu0,tv0;	/* texture coordinates */
} mga_warp_vertex1;

/*
 *  vertex type used for the dual-warp g400
 */
typedef struct mga_warp_vertex2_t {
  GLfloat		x,y,z;	        /* coordinates in screen space*/
  GLfloat 		rhw;	        /* reciprocal homogeneous w */
  mga_warp_color	color;		/* vertex color */
  mga_warp_color	specular;	/* specular color, alpha is fog */
  GLfloat		tu0,tv0;	/* texture coordinates */
  GLfloat		tu1,tv1;	/* same for second stage */
} mga_warp_vertex2;

#define MGA_WARP_TGZ     0
#define MGA_WARP_TGZA    (MGA_ALPHA_BIT)
#define MGA_WARP_TGZAF   (MGA_FOG_BIT|MGA_ALPHA_BIT)
#define MGA_WARP_TGZF    (MGA_FOG_BIT)
#define MGA_WARP_TGZS    (MGA_SPEC_BIT)
#define MGA_WARP_TGZSA   (MGA_SPEC_BIT|MGA_ALPHA_BIT)
#define MGA_WARP_TGZSAF  (MGA_SPEC_BIT|MGA_ALPHA_BIT|MGA_FOG_BIT)
#define MGA_WARP_TGZSF   (MGA_SPEC_BIT|MGA_FOG_BIT)

#define MGA_WARP_T2GZ    (MGA_TEX1_BIT)
#define MGA_WARP_T2GZA   (MGA_TEX1_BIT|MGA_ALPHA_BIT)
#define MGA_WARP_T2GZAF  (MGA_TEX1_BIT|MGA_ALPHA_BIT|MGA_FOG_BIT)
#define MGA_WARP_T2GZF   (MGA_TEX1_BIT|MGA_FOG_BIT)
#define MGA_WARP_T2GZS   (MGA_TEX1_BIT|MGA_SPEC_BIT)
#define MGA_WARP_T2GZSA  (MGA_TEX1_BIT|MGA_SPEC_BIT|MGA_ALPHA_BIT)
#define MGA_WARP_T2GZSAF (MGA_TEX1_BIT|MGA_SPEC_BIT|MGA_ALPHA_BIT|MGA_FOG_BIT)
#define MGA_WARP_T2GZSF  (MGA_TEX1_BIT|MGA_SPEC_BIT|MGA_FOG_BIT)

#endif /*MGA_WARP_H*/
