/*
 * GLX Hardware Device Driver for S3 Savage3D and probably Savage/MX and
 * Savage/IX
 * Copyright (C) 2000 Dominik Behr
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * WITTAWAT YAMWONG, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Based on S3 Virge driver by Jim Duchek <jimduchek@ou.edu>
 *
 * Dominik Behr <behr@promail.pl>
 * thanks to Raja Koduri and Tim Roberts   
 */

#ifndef __s3savhw_h
#define __s3savhw_h


#include "hwtypes.h"

/* 
 FIXME

 those typedefs probably need some tweaking
 becasuse i assume CPU is little endian
*/

typedef struct S3SAVRGBAtag {
 hwUI8 bB;
 hwUI8 bG;
 hwUI8 bR;
 hwUI8 bA;
} S3SAVRGBA, *PS3SAVRGBA;

#define S3SAVBGRA(r,g,b,a) (((hwUI32)r << 16) | ((hwUI32)g << 8) | ((hwUI32) b) | ((hwUI32)a << 24))

typedef union S3SAVCOLORtag {
 hwUI32 u;
 S3SAVRGBA st;
} S3SAVCOLOR, *PS3SAVCOLOR;

typedef struct S3SAVVERTEXtag {
  float fX;
  float fY;
  float fZ;
  float fW;
  S3SAVCOLOR stDiffuse;
  S3SAVCOLOR stSpecularFog;
  float fU;
  float fV;
} S3SAVVERTEX, *PS3SAVVERTEX;

typedef struct S3SAVTEXPALADDRtag {
 hwUI32 uReserved:3;
 hwUI32 uPaletteDataAddress:29; // qword aligned address of palette
} S3SAVTEXPALADDR, *PS3SAVTEXPALADDR;

typedef struct S3SAVCOLORKEYtag {
 hwUI32 uTextureTransparentColor:16;
 hwUI32 uReserved:16;
} S3SAVCOLORKEY, *PS3SAVCOLORKEY;

typedef struct S3SAVTEXADDRtag {
 hwUI32 uTL:1; // Texture Location 0 - framebuffer 1 - sysmem
 hwUI32 uTMT:1; // Texture Memory Type 0 - pci mem 1 - agp mem
 hwUI32 uReserved:1;
 hwUI32 uTextureDataAddress:29; // qword aligned address of texture
} S3SAVTEXADDR, *PS3SAVTEXADDR;

typedef struct S3SAVTEXDESCtag {
 hwUI32 uTexWidth:4;
 hwUI32 uReserved1:4;
 hwUI32 uTexHeight:4;
 hwUI32 uReserved2:4;
 hwUI32 uTexelFmt:3; // Texel Format, look below
 hwUI32 uTPS:2; // Texture Palette Size
                // 00 - 64 entries
                // 01 - 128 entries
                // 10 - 192 entries
                // 11 - 256 entries
 hwUI32 uReserved3:10;
 hwUI32 uLTP:1; // Load Texture Palette 0 - no effect, 1 - load new palette
} S3SAVTEXDESC, *PS3SAVTEXDESC;

#define S3SAVTEXFMT_S3TC              0
#define S3SAVTEXFMT_PALETTE_RGB565    1
#define S3SAVTEXFMT_PALETTE_ARGB1555  2
#define S3SAVTEXFMT_ARGB8888          3
#define S3SAVTEXFMT_ARGB1555          4
#define S3SAVTEXFMT_ARGB4444          5
#define S3SAVTEXFMT_RGB565            6
#define S3SAVTEXFMT_PALETTE_ARGB4444  7


typedef struct S3SAVTEXCTRLtag {
 hwUI32 uFiltMode:2;
 hwUI32 uEM:1; // Enable MipMapping
 hwUI32 uMipLevelBias:9; // Mipmap Level Bias
 hwUI32 uTUW:1; // Texture U Wrap Enable
 hwUI32 uTVW:1; // Texture V Wrap Enable
 hwUI32 uTAM:2; // Texture Address Model look below
 hwUI32 uETM:1; // Enable Texture Mapping
 hwUI32 uDFA:1; // D Fraction For Alpha 0 - normal, 1 - use d for blending (for trilinear simulation i suppose)
 hwUI32 uReserved1:1;
 hwUI32 uCCA:1; // Color Compare Alpha Blend Control 
                // 0 -  reduce dest alpha to 0 or 1
                // 1 - blend with destination
 hwUI32 uETT:1; // Enable Texture Transparency
 hwUI32 uReserved2:11;
} S3SAVTEXCTRL, *PS3SAVTEXCTRL;

#define S3SAVTAM_WRAP      0
#define S3SAVTAM_CLAMP     1
#define S3SAVTAM_MIRROR    2


typedef struct S3SAVTRIFLAGStag {
 hwUI32 uY01:1;
 hwUI32 uY12:1;
 hwUI32 uY20:1;
 hwUI32 uU01:1;
 hwUI32 uU12:1;
 hwUI32 uU20:1;
 hwUI32 uV01:1;
 hwUI32 uV12:1;
 hwUI32 uV20:1;
 hwUI32 uCE:1; // Cull Enable
 hwUI32 uVO:1; // Vertex Orientation 0 - clockwise
 hwUI32 uLNT:1; // Load New Texture 1 - load it
 hwUI32 uLNP:1; // Load New Texture Palette 1 - load it
 hwUI32 uDS:1; // D setup enable 0 - no d setup, 1 - de setup enabled
 hwUI32 uReserved:17;
 hwUI32 uTCK:1;
} S3SAVTRIFLAGS, *PS3SAVTRIFLAGS;

typedef struct S3SAVYCOORDtag {
 hwUI32 uYBottom:10;
 hwUI32 uYMiddle:10;
 hwUI32 uYTop:10;
 hwUI32 uReserved:2;
} S3SAVYCOORD, *PS3SAVYCOORD;

typedef struct S3SAVFOGCTRLtag {
 hwUI32 uB:8;
 hwUI32 uG:8;
 hwUI32 uR:8;
 hwUI32 uFogZStart:3; // fog table starts at 1 - 2^n
 hwUI32 uReserved1:1;
 hwUI32 uFE:1; // Fog Enable
 hwUI32 uFM:1; // Fog Mode 0 - table, 1 - vertex fog
 hwUI32 uReserved2:2; 
} S3SAVFOGCTRL, *PS3SAVFOGCTRL;

typedef struct S3SAVDRAWCTRLtag {
 hwUI32 uED:1; // Enable Dithering
 hwUI32 uUVO:1; // UV Offset Enable (add 0.5 to u and v 
 hwUI32 uBCM:2; // Backface Cull Mode
                // 00 - reserved
                // 01 - disable culling
                // 10 - cull clockwise
                // 11 - cull counterclockwise
 hwUI32 uTVC:1; // vertex counter reset 1 - reset it
 hwUI32 uSM:1; // Shade Mode 0 - gouraud, 1 - flat (color at vertex 0)
 hwUI32 uESS:1; // Enable Specular
 hwUI32 uDABM:3; // Destination Alpha Blend Mode look below 
 hwUI32 uSABM:3; // Source Alpha Blend Mode look below
 hwUI32 uReserved1:1;
 hwUI32 uATC:3; // Alpha Test Compare look below
 hwUI32 uEAT:1; // Enable Alpha Test
 hwUI32 uAlphaRef:8; // Alpha Reference Value 
 hwUI32 uTBC:3; // Texture Blending Control (look below)
 hwUI32 uFDW:1; // Flush Destination Writes 
 hwUI32 uFZW:1; // Flush Z Writes
 hwUI32 uIM:1; // Interpolaton Mode 1 - linear color and fog interpolation
} S3SAVDRAWCTRL, *PS3SAVDRAWCTRL;

#define S3SAVDABM_ZERO                     0
#define S3SAVDABM_ONE                      1
#define S3SAVDABM_SOURCE_COLOR             2
#define S3SAVDABM_ONE_MINUS_SOURCE_COLOR   3
#define S3SAVDABM_SOURCE_ALPHA             4
#define S3SAVDABM_ONE_MINUS_SOURCE_ALPHA   5
#define S3SAVDABM_6                        6
#define S3SAVDABM_7                        7

#define S3SAVSABM_ZERO                     0
#define S3SAVSABM_ONE                      1
#define S3SAVSABM_DEST_COLOR               2
#define S3SAVSABM_ONE_MINUS_DEST_COLOR     3
#define S3SAVSABM_SOURCE_ALPHA             4
#define S3SAVSABM_ONE_MINUS_SOURCE_ALPHA   5
#define S3SAVSABM_6                        6
#define S3SAVSABM_7                        7

#define S3SAVATC_NEVER                     0
#define S3SAVATC_LESS                      1
#define S3SAVATC_EQUAL                     2
#define S3SAVATC_LEQUAL                    3
#define S3SAVATC_GREATER                   4
#define S3SAVATC_NOTEQUAL                  5
#define S3SAVATC_GEQUAL                    6
#define S3SAVATC_ALWAYS                    7

#define S3SAVTBC_DECAL                     0
#define S3SAVTBC_MODULATE                  1
#define S3SAVTBC_DECALALPHA                2
#define S3SAVTBC_MODULATEALPHA             3
#define S3SAVTBC_4                         4
#define S3SAVTBC_5                         5
#define S3SAVTBC_COPY                      6
#define S3SAVTBC_7                         7


typedef struct S3SAVZBCTRLtag {
 hwUI32 uZBComp:3; // Z Buffer Compare mode look below
 hwUI32 uEDU:1; // Enable Draw Buffer Update
 hwUI32 uEZU:1; // Enable Z Buffer Update
 hwUI32 uEZ:1; // Enable Z Buffer
 hwUI32 uReserved1:2;
 hwUI32 uZExponentOffset:8;
 hwUI32 uZW:1; // 1 - z writes after alpha test, 0 - z read/writes before texture reads
 hwUI32 uReserved2:15;
} S3SAVZBCTRL, *PS3SAVZBCTRL;

#define S3SAVZBC_NEVER                     0
#define S3SAVZBC_LESS                      1
#define S3SAVZBC_EQUAL                     2
#define S3SAVZBC_LEQUAL                    3
#define S3SAVZBC_GREATER                   4
#define S3SAVZBC_NOTEQUAL                  5
#define S3SAVZBC_GEQUAL                    6
#define S3SAVZBC_ALWAYS                    7

typedef struct S3SAVZBADDRtag {
 hwUI32 uZBufferOffset:13; // 2k aligned z buffer address 11 bits zeroed
 hwUI32 uReserved1:12; // 
 hwUI32 uZBufferWidth:6; // z buffer width in tiles
 hwUI32 uZBufferDepth:1; // 0 - 16 bit z buffer, 1 - 24 bit z buffer
} S3SAVZBADDR, *PS3SAVZBADDR;

typedef struct S3SAVDESTCTRLtag {
 hwUI32 uDWT:7; // Destination Width in Tiles
 hwUI32 uReserved1:1;
 hwUI32 uDestOffset:13; // Destination Offset, 2k-aligned
 hwUI32 uReserved2:7;
 hwUI32 uDPF:2; // Destination Pixel Format look below
 hwUI32 uReserved3:2;
} S3SAVDESTCTRL, *PS3SAVDESTCTRL;

#define S3SAVDPF_RGB565        0
#define S3SAVDPF_1             1
#define S3SAVDPF_XRGB888       2
#define S3SAVDPF_3             3

// Scissors Start
typedef struct S3SAVSCSTARTtag {
 hwUI32 uXStart:11;
 hwUI32 uReserved1:5;
 hwUI32 uYStart:11;
 hwUI32 uReserved2:5;
} S3SAVSCSTART, *PS3SAVSCSTART;

typedef struct S3SAVSCENDtag {
 hwUI32 uXEnd:11;
 hwUI32 uReserved1:5;
 hwUI32 uYEnd:11;
 hwUI32 uReserved2:5;
} S3SAVSCEND, *PS3SAVSCEND;

typedef struct S3SAVZWATERtag {
 hwUI32 uZReadLow:6;
 hwUI32 uReserved1:2;
 hwUI32 uZReadHigh:6;
 hwUI32 uReserved2:2;
 hwUI32 uZWriteLow:6;
 hwUI32 uReserved3:2;
 hwUI32 uZWriteHigh:6;
 hwUI32 uReserved4:2;
} S3SAVZWATER, *PS3SAVZWATER;

typedef struct S3SAVDWATERtag {
 hwUI32 uDestReadLow:6;
 hwUI32 uDestReadHigh:6;
 hwUI32 uDestWriteLow:6;
 hwUI32 uDestWriteHight:6;
 hwUI32 uTexReadWM:4;
 hwUI32 uReserved1:2;
 hwUI32 uPFL:2; // Pixel FIFO len 00 - 240, 01 - 180, 10 - 120, 11 - 60
} S3SAVDWATER, *PS3SAVDWATER;

//typedef struct S3SAV tag {
//} S3SAV, *PS3SAV;


/* S3 Savage3D 3D registers
   start at PCI address + 0x1048500 
   
  we have to add 0x48500 to MmioBase we got from x server S3VPRIV structure   

*/

#define S3SAV_3DREGS 0x48500
#define S3SAV_STATUS0 0x48C00
#define S3SAV_BCI (1L << 17) // bci idle
#define S3SAV_3DI (1L << 18) // 3d engine idle
#define S3SAV_2DI (1L << 19) // 2d engine idle
#define S3SAV_MCI (1L << 20) // motion compensation processor idle
#define S3SAV_VSI (1L << 21) // video scaling engine idle
#define S3SAV_MEI (1L << 22) // master engine idle
#define S3SAV_STATUS1      0x48C04
#define S3SAV_STATUS2      0x48C08
#define S3SAV_STATUS_ADDR  0x48C0C
#define S3SAV_BUFFER_TRESH 0x48C10

#define S3SAV_TILEDAPERTURE0 0x48C40
#define S3SAV_TILEDAPERTURE1 0x48C44
#define S3SAV_TILEDAPERTURE2 0x48C48
#define S3SAV_TILEDAPERTURE3 0x48C4C
#define S3SAV_TILEDAPERTURE4 0x48C50
#define S3SAV_TILEDAPERTURE5 0x48C54

#define S3SAV_COB 0x48C14

#define S3SAV_GBD1 0x8168
#define S3SAV_GBD2 0x816C
#define S3SAV_PBD1 0x8170
#define S3SAV_PBD2 0x8174
#define S3SAV_SBD1 0x8178
#define S3SAV_SBD2 0x817C

/* lowest 11 bits of buffer address should be 0
   that is buffer should be 2k aligned */
#define S3SAV_BUFFERALIGN 11 


typedef struct S3SAVREGStag {
// 00
 volatile S3SAVVERTEX stVertex0;
// 20
 volatile S3SAVVERTEX stVertex1;
// 40
 volatile S3SAVVERTEX stVertex2;
// 60 
 volatile S3SAVTEXPALADDR stTEXPALADDR;
// 64
 volatile S3SAVCOLORKEY stCOLORKEY;
// 68
 volatile S3SAVTEXADDR stTEXADDR;
// 6C
 volatile S3SAVTEXDESC stTEXDESC;
// 70
 volatile S3SAVTEXCTRL stTEXCTRL;
// 74
 volatile S3SAVTRIFLAGS stTRIFLAGS;
// 78
 volatile S3SAVYCOORD stYCOORD;
// 7C
 volatile hwUI32 uReserved;
// 80
 volatile hwUI8 aFogTable[64];
// C0
 volatile S3SAVFOGCTRL stFOGCTRL;
// C4
 volatile S3SAVDRAWCTRL stDRAWCTRL;
// C8 
 volatile S3SAVZBCTRL stZBCTRL;
// CC
 volatile S3SAVZBADDR stZBADDR;
// D0
 volatile S3SAVDESTCTRL stDESTCTRL;
// D4
 volatile S3SAVSCSTART stSCSTART;
// D8
 volatile S3SAVSCEND stSCEND;
// DC
 volatile S3SAVZWATER stZWATER;
// E0
 volatile S3SAVDWATER stDWATER;

} S3SAVREGS, *PS3SAVREGS;

// 8}CMD|8}count|16}skipflags
#define BCI_CMD_TRILIST   0x80000000L
#define BCI_CMD_TRISTRIP  0x82000000L
#define BCI_CMD_TRIFAN    0x84000000L
#define BCI_CMD_QUADLIST  0x86000000L
// or this one with previous commands if this vertex list 
// is continuation of previous one
#define BCI_CMD_CONTINUE  0x01000000L
// set any register that has bci index 8}CMD|8}count|16}index
#define BCI_CMD_SETREG    0x96000000L
// update shadow status 8}CMD|24}tag 
#define BCI_CMD_UPDSHADOW 0x98000000L

#define BCI_CMD_WAIT       0xC0000000L 
#define BCI_WAIT_3D_IDLE   0x00010000L
#define BCI_WAIT_2D_IDLE   0x00020000L
#define BCI_WAIT_PAGEFLIP  0x01000000L
#define BCI_WAIT_SCANLINE  0x02000000L

#define BCI_SKIP_Z        0x01
#define BCI_SKIP_W        0x02
#define BCI_SKIP_DIFFUSE  0x04
#define BCI_SKIP_SPECULAR 0x08
#define BCI_SKIP_U        0x10
#define BCI_SKIP_V        0x20

/* definition of BCI register indices */
#define BCI_VERTEX0		0x00    
#define BCI_VERTEX1    		0x08
#define BCI_VERTEX2             0x10
#define BCI_TEXPALADDR          0x18
#define BCI_COLORKEY            0x19
#define BCI_TEXADDR             0x1A
#define BCI_TEXDESC             0x1B
#define BCI_TEXCTRL             0x1C
#define BCI_FOGTABLE            0x20
#define BCI_FOGCTRL             0x30
#define BCI_DRAWCTRL            0x31
#define BCI_ZBCTRL              0x32
#define BCI_ZBADDR              0x33
#define BCI_DESTCTRL            0x34
#define BCI_SCSTART             0x35
#define BCI_SCEND               0x36
#define BCI_ZWATER              0x37 
#define BCI_DWATER              0x38

/* 2D regs */
#define BCI_GBD1                0xE0
#define BCI_GBD2                0xE1
#define BCI_PBD1                0xE2
#define BCI_PBD2                0xE3
#define BCI_SBD1                0xE4
#define BCI_SBD2                0xE5

#endif /* __s3savhw_h */
