/*
 * GLX Hardware Device Driver for S3 Savage3D and probably Savage/MX and
 * Savage/IX
 * Copyright (C) 2000 Dominik Behr
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * WITTAWAT YAMWONG, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Based on S3 Virge driver by Jim Duchek <jimduchek@ou.edu>
 *
 * Dominik Behr <behr@promail.pl>
 * thanks to Raja Koduri and Tim Roberts   
 */

#include <stdlib.h>

#include "context.h"
#include "depth.h"
#include "macros.h"
#include "texstate.h"
#include "triangle.h"
#include "vb.h"
#include "types.h"

#include "xsmesaP.h"
#include "glx_log.h"
#include "mesaglx/context.h"
#include "mesaglx/matrix.h"
#include "mesaglx/types.h"

#define GC XXGC
#include "gcstruct.h"
#include "pixmapstr.h"
#include "servermd.h" /* PixmapBytePad */
#include "scrnintstr.h"
#include "regionstr.h"
#include "windowstr.h"
#undef GC

#include "s3savglx.h"
#include "glx_symbols.h"

/*
 * performanceBoxes
 * Draw some small boxesin the corner of the buffer
 * based on some performance information
 */
/*******************************************************************************

*******************************************************************************/

void 
s3savPerformanceBoxes( int is_direct )
{
 return;
}

void
s3savBlit(unsigned int uDstX,
          unsigned int uDstY,
	  unsigned int uSrcOffset,
	  unsigned int uSrcStride, // in pixels
	  unsigned int uSrcBPP,
	  unsigned int uSrcX,
	  unsigned int uSrcY,
	  unsigned int uWidth,
	  unsigned int uHeight)
{
 hwUI32 uPBD1, uPBD2;
 hwUI32 uCmd, uDstXY, uSrcXY, uWH;

 #ifdef EVENT_TRACE
 s3savFIFOWait(1);
 fprintf(stderr, "[s3sav] BLIT event %04X\n", s3savInsertEvent());
 #endif
 
 s3savFIFOWait(4+4+2);
 BCIRST;
 BCIWR(BCI_CMD_WAIT | BCI_WAIT_3D_IDLE);
 
 uPBD1 = uSrcOffset;
 uPBD2 = uSrcStride | (uSrcBPP << 16) /*| 0x10000000*/ /* BW disable */;
 // tiled buffer
 if (uSrcBPP > 16)
    uPBD2 |= 0x03000000; // 32 bit tile format
 else
    uPBD2 |= 0x02000000; // 16 bit tile format
 
 BCISETREG(BCI_PBD1, uPBD1);
 BCISETREG(BCI_PBD2, uPBD2);

 uCmd = 0x48000000 | 0x01000000 | 0x02000000
      | 0x00CC0000 // ROP copy
      | 0x00000000 // dest GBD
      | 0x00000080 // src PBD color
      ;
 uDstXY = uDstX | (uDstY << 16);
 uSrcXY = uSrcX | (uSrcY << 16);
 uWH = uWidth | (uHeight << 16);
 BCIWR(uCmd);
 BCIWR(uSrcXY);
 BCIWR(uDstXY);
 BCIWR(uWH);
 
 #ifdef FORCE_SHADOW_UPDATE
 s3savUpdateShadow();
 #endif
}	  
	  
/*******************************************************************************

*******************************************************************************/
void
s3savDoSwap(PS3SAVSURFACE pBuf,
            DrawablePtr pDraw)
{
 RegionPtr pClip;
 BoxPtr pBoxes;
 unsigned int nBoxes;

 stS3Sav.pSHM->uFrames++;
 pClip = &((WindowPtr)pDraw)->clipList;
 nBoxes = REGION_NUM_RECTS(pClip);
 if (!nBoxes)
    return; // no part of window is visible
 pBoxes = REGION_RECTS(pClip);
 
 while (nBoxes--)
       {
        s3savBlit(pBoxes->x1,
                  pBoxes->y1,
        	  pBuf->pMemBlock->ofs,
	          pBuf->nStride / pBuf->nBPP,
	          pBuf->nBPP * 8,
	          pBoxes->x1 - pDraw->x,
	          pBoxes->y1 - pDraw->y,
 	          pBoxes->x2 - pBoxes->x1,
	          pBoxes->y2 - pBoxes->y1);
        pBoxes++;
       }
}
	    
/*
 * Copy the back buffer to the front buffer.  If there's no back buffer
 * this is a no-op.  Only called in indirect contexts.
 */
/*******************************************************************************

*******************************************************************************/
void 
s3savGLXSwapBuffers(XSMesaBuffer b) 
{
 PS3SAVBUFFER pBuf;
 DrawablePtr pDraw;
 
 #ifdef TRACE
 fprintf(stderr, "[s3sav] s3savGLXSwapBuffers(%08X)\n",
         b);
 #endif	 
 if (!b->backimage)
    return;
 pBuf = (PS3SAVBUFFER)b->backimage->devPriv;
 if (!pBuf->stBackBuffer.pMemBlock)
    return;

 pDraw = (DrawablePtr)b->frontbuffer;
 if (pDraw->type != DRAWABLE_WINDOW)
    {
     // aww crap
     return;
    }
 if (__glx_is_server)
    s3savDoSwap(&(pBuf->stBackBuffer), pDraw);    
 else
    s3savDirectClientSwapBuffers(b);
        
 stS3Sav.uChangedFlags = 0xFFFFFFFF;       
 //usleep(1000000);
 /* 
 s3savBlit(pDraw->x,
           pDraw->y,
	   pBuf->stBackBuffer.pMemBlock->ofs,
	   pBuf->stBackBuffer.nStride / pBuf->stBackBuffer.nBPP,
	   pBuf->stBackBuffer.nBPP * 8,
	   0,
	   0,
	   pBuf->stBackBuffer.nWidth,
	   pBuf->stBackBuffer.nHeight);
 */	 
 #ifdef TRACE
 fprintf(stderr, "[s3sav] s3savGLXSwapBuffers(%08X) OK\n",
         b);
 #endif	   
 return;	   
 /* software blit ... */
 /* Use backimage's dimension (not buffer's) */
 ValidateGC( b->frontbuffer, b->cleargc );
 (*b->cleargc->ops->PutImage)((DrawablePtr)b->frontbuffer,
	                      b->cleargc,
			      b->frontbuffer->depth,
		              0, 
		              0,
			      b->backimage->width,
			      b->backimage->height,
			      0, 
			      ZPixmap, 
			      b->backimage->data);

}

