
/*
 * GLX Server Extension
 * Copyright (C) 1996  Steven G. Parker  (sparker@cs.utah.edu)
 * Copyright (C) 1998, 1999 Terence Ripperda (ripperda@sgi.com)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * STEVEN PARKER, TERENCE RIPPERDA, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR 
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef GLX_RENDER_H
#define GLX_RENDER_H 1

#include "GL/gl.h"
#include "GL/GLXproto.h"
#include "X.h"

typedef int (*GLXRenderFunc)(int length, char* data);
int GLXDecodeInvalid(int length, char* data);
extern GLXRenderFunc GLX_render_funcs[];
extern GLXRenderFunc GLX_render_funcs_swapped[];

#define GET_float(p) (*(GLfloat*)(p))
#define GET_bitfield(p) (*(GLbitfield*)(p))
#define GET_enum(p) (*(GLenum*)(p))
#if defined(__i386) || defined(__x86__) || defined(__i386__) || defined(__alpha__)
#define GET_double(p) (*(GLdouble*)(p))
#else
//#define GET_double(p) FIX_THIS!	(WHY??? alignment? --jdc)
#define GET_double(p) (*(GLdouble*)(p))
#endif
#define GET_uint(p) (*(GLuint*)(p))
#define GET_int(p) (*(GLint*)(p))
#define GET_boolean(p) (*(GLboolean*)(p))
#define GET_short(p) (*(GLshort*)(p))
#define GET_ushort(p) (*(GLushort*)(p))
#define GET_byte(p) (*(GLbyte*)(p))
#define GET_ubyte(p) (*(GLubyte*)(p))

/* byte swap a 64 bit value */
#define swapd(x, n) { \
		 n = ((char *) (x))[0];\
		 ((char *) (x))[0] = ((char *) (x))[7];\
		 ((char *) (x))[7] = n;\
		 n = ((char *) (x))[1];\
		 ((char *) (x))[1] = ((char *) (x))[6];\
		 ((char *) (x))[6] = n;\
		 n = ((char *) (x))[2];\
		 ((char *) (x))[2] = ((char *) (x))[5];\
		 ((char *) (x))[5] = n;\
		 n = ((char *) (x))[3];\
		 ((char *) (x))[3] = ((char *) (x))[4];\
		 ((char *) (x))[4] = n; }

#endif
