/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#include "support.h"
#include "interface.h"
#include "gtk_main.h"
#include "visu_object.h"
#include "visu_pickMesure.h"

#include "gtk_move.h"
#include "gtk_pick.h"
#include "gtk_interactive.h"
#include "gtk_renderingWindowWidget.h"
#include "renderingBackend/visu_windowInterface.h"
#include "openGLFunctions/interactive.h"
#include "extraGtkFunctions/gtk_numericalEntryWidget.h"

/* Callbacks. */
static void onNewData(GObject *obj, VisuData *dataObj, gpointer bool);
static void onDataReady(GObject *obj, VisuData *dataObj, gpointer bool);
static void refreshMoveAxesValues(VisuData *obj, OpenGLView *view, gpointer data);
static void onMovePositionChanged(NumericalEntry *entry,
				  double oldValue, gpointer data);
static void onMoveToOriginalClicked(GtkButton *button, gpointer data);
static void onRemoveNodeClicked(GtkButton *button, gpointer user_data);
static void onAddNodeClicked(GtkButton *button, gpointer user_data);
static void onMoveMethod(GtkToggleButton *toggle, gpointer data);

/* Pick informations hook */
static int movedNode = -1;
static float moveNodeOrigin[3];
#define GTK_MOVE_NO_NODE         _("<i>none</i>")
#define GTK_MOVE_NO_REGION       _("<i>unset</i>")

/* Widgets */
static GtkWidget *notebookAction;
static GtkWidget *observeWindow;
static GtkWidget *entryMoveXYZ[3];
static GtkWidget *entryAddXYZ[3];
static GtkWidget *comboElements;
static GtkListStore *listElements;
static GtkWidget *labelMoveId, *labelNMoves;
static GtkWidget *radioMovePick, *radioMoveRegion;
enum
  {
    COLUMN_NAME,             /* The label shown */
    COLUMN_POINTER_TO_DATA,  /* Pointer to the VisuElement. */
    N_COLUMNS
  };
static GtkWidget *labelOriginX, *labelOriginY, *labelOriginZ;
static GtkWidget *labelScreenHorizontal, *labelScreenVertical;


/********************/
/* Public routines. */
/********************/
void gtkMoveBuild_interface(GtkMain *main)
{
  GtkWidget *wd;
  GtkCellRenderer *renderer;
  RenderingWindow *window;
  VisuData *data;
  GtkTreeIter iter;
  VisuDataIter dataIter;

  window = visuRenderingWindowGet_current();
  g_return_if_fail(window);
  data = renderingWindowGet_visuData(window);
  g_return_if_fail(data);

  observeWindow = main->interactiveDialog;

  notebookAction = lookup_widget(main->interactiveDialog, "notebookAction");

  labelMoveId = lookup_widget(main->interactiveDialog, "labelMoveId");
  gtk_label_set_markup(GTK_LABEL(labelMoveId), GTK_MOVE_NO_NODE);

  labelNMoves = lookup_widget(main->interactiveDialog, "labelNMoves");
  gtk_label_set_markup(GTK_LABEL(labelNMoves), GTK_MOVE_NO_REGION);

  radioMovePick = lookup_widget(main->interactiveDialog, "radioMovePick");
  gtk_widget_set_name(radioMovePick, "message_radio");
  radioMoveRegion = lookup_widget(main->interactiveDialog, "radioMoveRegion");
  gtk_widget_set_name(radioMoveRegion, "message_radio");

  labelOriginX = lookup_widget(main->interactiveDialog, "labelOriginalX");
  labelOriginY = lookup_widget(main->interactiveDialog, "labelOriginalY");
  labelOriginZ = lookup_widget(main->interactiveDialog, "labelOriginalZ");

  labelScreenHorizontal = lookup_widget(main->interactiveDialog, "labelHorizontalAxe");
  labelScreenVertical   = lookup_widget(main->interactiveDialog, "labelVerticalAxe");
  g_signal_connect(G_OBJECT(data), "OpenGLThetaPhiOmega",
		   G_CALLBACK(refreshMoveAxesValues), (gpointer)0);

  wd = lookup_widget(main->interactiveDialog, "tableMovePick");
  entryMoveXYZ[0] = numericalEntry_new(0.);
  gtk_entry_set_width_chars(GTK_ENTRY(entryMoveXYZ[0]), 6);
  gtk_table_attach(GTK_TABLE(wd), entryMoveXYZ[0], 1, 2, 2, 3,
		   GTK_SHRINK, GTK_SHRINK, 0, 0);
  gtk_widget_show(entryMoveXYZ[0]);
  entryMoveXYZ[1] = numericalEntry_new(0.);
  gtk_entry_set_width_chars(GTK_ENTRY(entryMoveXYZ[1]), 6);
  gtk_table_attach(GTK_TABLE(wd), entryMoveXYZ[1], 2, 3, 2, 3,
		   GTK_SHRINK, GTK_SHRINK, 0, 0);
  gtk_widget_show(entryMoveXYZ[1]);
  entryMoveXYZ[2] = numericalEntry_new(0.);
  gtk_entry_set_width_chars(GTK_ENTRY(entryMoveXYZ[2]), 6);
  gtk_table_attach(GTK_TABLE(wd), entryMoveXYZ[2], 3, 4, 2, 3,
		   GTK_SHRINK, GTK_SHRINK, 0, 0);
  gtk_widget_show(entryMoveXYZ[2]);

  /* The add line. */
  wd = lookup_widget(main->interactiveDialog, "hboxAddNode");
  entryAddXYZ[0] = numericalEntry_new(0.);
  gtk_entry_set_width_chars(GTK_ENTRY(entryAddXYZ[0]), 6);
  gtk_box_pack_start(GTK_BOX(wd), entryAddXYZ[0], FALSE, FALSE, 0);
  entryAddXYZ[1] = numericalEntry_new(0.);
  gtk_entry_set_width_chars(GTK_ENTRY(entryAddXYZ[1]), 6);
  gtk_box_pack_start(GTK_BOX(wd), entryAddXYZ[1], FALSE, FALSE, 0);
  entryAddXYZ[2] = numericalEntry_new(0.);
  gtk_entry_set_width_chars(GTK_ENTRY(entryAddXYZ[2]), 6);
  gtk_box_pack_start(GTK_BOX(wd), entryAddXYZ[2], FALSE, FALSE, 0);
  /* We create the structure that store the VisuElements */
  listElements = gtk_list_store_new(N_COLUMNS, G_TYPE_STRING, G_TYPE_POINTER);
  comboElements = gtk_combo_box_new_with_model(GTK_TREE_MODEL(listElements));
  renderer = gtk_cell_renderer_text_new();
  gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(comboElements), renderer, FALSE);
  gtk_cell_layout_add_attribute(GTK_CELL_LAYOUT(comboElements),
				renderer, "text", COLUMN_NAME);
  gtk_box_pack_start(GTK_BOX(wd), comboElements, FALSE, FALSE, 0);
  gtk_box_reorder_child(GTK_BOX(wd), comboElements, 0);
  gtk_widget_show_all(wd);
  /* We populate the combobox. */
  visuDataIter_new(data, &dataIter);
  for(visuDataIter_start(data, &dataIter); dataIter.element;
      visuDataIter_nextElement(data, &dataIter))
    {
      gtk_list_store_append(listElements, &iter);
      gtk_list_store_set(listElements, &iter,
			 COLUMN_NAME, dataIter.element->name,
			 COLUMN_POINTER_TO_DATA, dataIter.element,
			 -1);
    }
  gtk_combo_box_set_active(GTK_COMBO_BOX(comboElements), 0);

  g_signal_connect(G_OBJECT(visu), "dataReadyForRendering",
		   G_CALLBACK(onDataReady), (gpointer)0);
  g_signal_connect(G_OBJECT(visu), "dataNew",
		   G_CALLBACK(onNewData), (gpointer)0);

  g_signal_connect(G_OBJECT(entryMoveXYZ[0]), "value-changed",
		   G_CALLBACK(onMovePositionChanged), GINT_TO_POINTER(0));
  g_signal_connect(G_OBJECT(entryMoveXYZ[1]), "value-changed",
		   G_CALLBACK(onMovePositionChanged), GINT_TO_POINTER(1));
  g_signal_connect(G_OBJECT(entryMoveXYZ[2]), "value-changed",
		   G_CALLBACK(onMovePositionChanged), GINT_TO_POINTER(2));
  wd = lookup_widget(main->interactiveDialog, "buttonMoveOriginal");
  g_signal_connect(G_OBJECT(wd), "clicked",
		   G_CALLBACK(onMoveToOriginalClicked), (gpointer)0);
  wd = lookup_widget(main->interactiveDialog, "buttonRemoveNode");
  g_signal_connect(G_OBJECT(wd), "clicked",
		   G_CALLBACK(onRemoveNodeClicked), (gpointer)0);
  wd = lookup_widget(main->interactiveDialog, "buttonAddNode");
  g_signal_connect(G_OBJECT(wd), "clicked",
		   G_CALLBACK(onAddNodeClicked), (gpointer)0);
  wd = lookup_widget(main->interactiveDialog, "radioMovePick");
  g_signal_connect(G_OBJECT(wd), "toggled",
		   G_CALLBACK(onMoveMethod), GINT_TO_POINTER(0));
  wd = lookup_widget(main->interactiveDialog, "radioMoveRegion");
  g_signal_connect(G_OBJECT(wd), "toggled",
		   G_CALLBACK(onMoveMethod), GINT_TO_POINTER(1));
}


static void setLabelsOrigin(GList *nodes)
{
  gchar numero[256];
  VisuNode *node;

  if (nodes && !nodes->next)
    {
      node = (VisuNode*)nodes->data;
      sprintf(numero, _("node %d"), node->number + 1);
      gtk_label_set_markup(GTK_LABEL(labelMoveId), numero);
      gtk_label_set_markup(GTK_LABEL(labelNMoves), GTK_MOVE_NO_REGION);
      /* Set the origin position values. */
      moveNodeOrigin[0] = node->xyz[0];
      moveNodeOrigin[1] = node->xyz[1];
      moveNodeOrigin[2] = node->xyz[2];
      sprintf(numero, "%5.2f", moveNodeOrigin[0]);
      gtk_label_set_text(GTK_LABEL(labelOriginX), numero);
      sprintf(numero, "%5.2f", moveNodeOrigin[1]);
      gtk_label_set_text(GTK_LABEL(labelOriginY), numero);
      sprintf(numero, "%5.2f", moveNodeOrigin[2]);
      gtk_label_set_text(GTK_LABEL(labelOriginZ), numero);
      numericalEntrySet_value(NUMERICAL_ENTRY(entryMoveXYZ[0]), node->xyz[0]);
      numericalEntrySet_value(NUMERICAL_ENTRY(entryMoveXYZ[1]), node->xyz[1]);
      numericalEntrySet_value(NUMERICAL_ENTRY(entryMoveXYZ[2]), node->xyz[2]);
    }
  else if (nodes)
    {
      gtk_label_set_markup(GTK_LABEL(labelMoveId), GTK_MOVE_NO_NODE);
      sprintf(numero, _("%d node(s)"), g_list_length(nodes));
      gtk_label_set_markup(GTK_LABEL(labelNMoves), numero);
      numero[0] = '\0';
      gtk_label_set_text(GTK_LABEL(labelOriginX), numero);
      gtk_label_set_text(GTK_LABEL(labelOriginY), numero);
      gtk_label_set_text(GTK_LABEL(labelOriginZ), numero);
    }
  else
    {
      gtk_label_set_markup(GTK_LABEL(labelMoveId), GTK_MOVE_NO_NODE);
      gtk_label_set_markup(GTK_LABEL(labelNMoves), GTK_MOVE_NO_REGION);
      numero[0] = '\0';
      gtk_label_set_text(GTK_LABEL(labelOriginX), numero);
      gtk_label_set_text(GTK_LABEL(labelOriginY), numero);
      gtk_label_set_text(GTK_LABEL(labelOriginZ), numero);
      numericalEntrySet_value(NUMERICAL_ENTRY(entryMoveXYZ[0]), 0.);
      numericalEntrySet_value(NUMERICAL_ENTRY(entryMoveXYZ[1]), 0.);
      numericalEntrySet_value(NUMERICAL_ENTRY(entryMoveXYZ[2]), 0.);
    }
}
static void updateLabelsPosition(GList *nodes, float drag[3])
{
  VisuNode *node;
  double val;

  /* Modify the entry labels. */
  if (nodes && !nodes->next)
    {
      node = (VisuNode*)nodes->data;
      numericalEntrySet_value(NUMERICAL_ENTRY(entryMoveXYZ[0]), node->xyz[0]);
      numericalEntrySet_value(NUMERICAL_ENTRY(entryMoveXYZ[1]), node->xyz[1]);
      numericalEntrySet_value(NUMERICAL_ENTRY(entryMoveXYZ[2]), node->xyz[2]);
    }
  else if (nodes)
    {
      val = numericalEntryGet_value(NUMERICAL_ENTRY(entryMoveXYZ[0]));
      numericalEntrySet_value(NUMERICAL_ENTRY(entryMoveXYZ[0]), val + drag[0]);
      val = numericalEntryGet_value(NUMERICAL_ENTRY(entryMoveXYZ[1]));
      numericalEntrySet_value(NUMERICAL_ENTRY(entryMoveXYZ[1]), val + drag[1]);
      val = numericalEntryGet_value(NUMERICAL_ENTRY(entryMoveXYZ[2]));
      numericalEntrySet_value(NUMERICAL_ENTRY(entryMoveXYZ[2]), val + drag[2]);
    }
  else
    {
      numericalEntrySet_value(NUMERICAL_ENTRY(entryMoveXYZ[0]), 0.);
      numericalEntrySet_value(NUMERICAL_ENTRY(entryMoveXYZ[1]), 0.);
      numericalEntrySet_value(NUMERICAL_ENTRY(entryMoveXYZ[2]), 0.);
    }
}

void gtkMoveUpdate_informations(PickMesure *pickMesure)
{
  PickMesureType type;
  VisuInteractive *inter;
  GList *nodes, *lst, *tmpLst;
  float *drag;
  VisuNode *node;
  VisuData *data;

  if (!pickMesureGet_newsAvailable(pickMesure, &type))
    return;

  DBG_fprintf(stderr, "Gtk Move: callback on move action.\n");

  nodes = (GList*)0;
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radioMovePick)))
    {
      node = pickMesureGet_selectedNode(pickMesure);
      if (!node)
	return;
      nodes = g_list_append(nodes, (gpointer)node);
      movedNode = node->number;
    }
  else
    {
      data = renderingWindowGet_visuData(RENDERING_WINDOW(currentRenderingWindow));
      g_return_if_fail(data);

      movedNode = -1;
      tmpLst = lst = gtkPickGet_nodeSelection();
      while(tmpLst)
	{
	  node = visuDataGet_nodeFromNumber(data, GPOINTER_TO_INT(tmpLst->data));
	  if (node)
	    nodes = g_list_prepend(nodes, (gpointer)node);
	  tmpLst = g_list_next(tmpLst);
	}
      g_list_free(lst);

      if (!nodes)
	return;
    }
  inter = (VisuInteractive*)g_object_get_data(G_OBJECT(observeWindow),
					      "visuInteractive_data");
  switch (type)
    {
    case PICK_DRAG_START:
      openGLInteractiveStart_move(inter, nodes);
      setLabelsOrigin(nodes);
      break;
    case PICK_DRAG_STOP:
      openGLInteractiveStop_move(inter, nodes);
      break;
    case PICK_DRAG_MOVE:
      drag = pickMesureGet_drag(pickMesure);
      openGLInteractiveMove(inter, nodes, drag);
      updateLabelsPosition(nodes, drag);
      break;
    default:
      g_error("Not a drag action!");
    }
  g_list_free(nodes);
}

/****************/
/* Private part */
/****************/

static void onNewData(GObject *obj _U_, VisuData *dataObj, gpointer data _U_)
{
  g_signal_connect(G_OBJECT(dataObj), "OpenGLThetaPhiOmega",
		   G_CALLBACK(refreshMoveAxesValues), (gpointer)0);
}

static void onDataReady(GObject *obj _U_, VisuData *dataObj, gpointer data _U_)
{
  GtkTreeIter iter;
  VisuDataIter dataIter;

  if (dataObj)
    {
      DBG_fprintf(stderr, "Gtk Move: caught 'dataReadyForRendering' signal,"
		  " setting the element combo.\n");
      /* We update the element combo if necessary. */
      if (!visuDataGet_changeElementFlag(dataObj))
	{
	  gtk_list_store_clear(listElements);
	  visuDataIter_new(dataObj, &dataIter);
	  for(visuDataIter_start(dataObj, &dataIter); dataIter.element;
	      visuDataIter_nextElement(dataObj, &dataIter))
	    {
	      gtk_list_store_append(listElements, &iter);
	      gtk_list_store_set(listElements, &iter,
				 COLUMN_NAME, dataIter.element->name,
				 COLUMN_POINTER_TO_DATA, dataIter.element,
				 -1);
	    }
	  gtk_combo_box_set_active(GTK_COMBO_BOX(comboElements), 0);
	}
    }
  else
    {
      gtk_list_store_clear(listElements);
    }
}

static void refreshMoveAxesValues(VisuData *obj _U_, OpenGLView *view, gpointer data)
{
  gint id;
  float x[3], y[3];
  char tmpChr[20];

  id = gtk_notebook_get_current_page(GTK_NOTEBOOK(notebookAction));
  DBG_fprintf(stderr, "Gtk Observe/pick: refresh screen basis set.\n");
  DBG_fprintf(stderr, " | %d %d\n", id + 1, action_move);
  if (id + 1 == action_move || GPOINTER_TO_INT(data))
    {
      OpenGLViewGet_screenAxes(view, x, y);
      sprintf(tmpChr, "(%4.2f;%4.2f;%4.2f)", x[0], x[1], x[2]);
      gtk_label_set_text(GTK_LABEL(labelScreenHorizontal), tmpChr);
      sprintf(tmpChr, "(%4.2f;%4.2f;%4.2f)", y[0], y[1], y[2]);
      gtk_label_set_text(GTK_LABEL(labelScreenVertical), tmpChr);
    }
}
static void onMoveMethod(GtkToggleButton *toggle, gpointer data _U_)
{
  if (!gtk_toggle_button_get_active(toggle))
    return;

  numericalEntrySet_value(NUMERICAL_ENTRY(entryMoveXYZ[0]), 0.);
  numericalEntrySet_value(NUMERICAL_ENTRY(entryMoveXYZ[1]), 0.);
  numericalEntrySet_value(NUMERICAL_ENTRY(entryMoveXYZ[2]), 0.);
}
static void onMovePositionChanged(NumericalEntry *entry, double oldValue,
				  gpointer data)
{
  float *valOfNode;
  VisuData *dataObj;
  VisuNode *node;
  GList *lst, *tmpLst;

  g_return_if_fail(GPOINTER_TO_INT(data) >= 0 && GPOINTER_TO_INT(data) < 3);

  /* We are not typing. */
  if (!gtk_widget_is_focus(GTK_WIDGET(entry)))
    return;

  dataObj = renderingWindowGet_visuData
    (RENDERING_WINDOW(visuRenderingWindowGet_current()));

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radioMovePick)))
    {
      if (movedNode < 0)
	return;

      node = visuDataGet_nodeFromNumber(dataObj, movedNode);
      g_return_if_fail(node);

      valOfNode = node->xyz + GPOINTER_TO_INT(data);
  
      if (*valOfNode == (float)numericalEntryGet_value(entry))
	return;

      *valOfNode = (float)numericalEntryGet_value(entry);
      visuData_createNodes(dataObj, dataObj->fromIntToVisuElement[node->posElement]);
      visuDataEmit_nodePositionChanged(dataObj);
    }
  else
    {
      tmpLst = lst = gtkPickGet_nodeSelection();
      while(tmpLst)
	{
	  node = visuDataGet_nodeFromNumber(dataObj, GPOINTER_TO_INT(tmpLst->data));
	  if (node)
	    node->xyz[GPOINTER_TO_INT(data)] +=
	      numericalEntryGet_value(entry) - oldValue;
	  tmpLst = g_list_next(tmpLst);
	}
      g_list_free(lst);

      visuData_createAllNodes(dataObj);

    }

  g_idle_add(visuObjectRedraw, (gpointer)0);
}
static void onMoveToOriginalClicked(GtkButton *button _U_, gpointer data _U_)
{
  VisuData *dataObj;
  VisuNode *node;
  float trans[3];
  GList *lst, *tmpLst;

  dataObj = renderingWindowGet_visuData
    (RENDERING_WINDOW(visuRenderingWindowGet_current()));

  /* We are not typing. */
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radioMovePick)))
    {
      if (movedNode < 0)
	return;

      node = visuDataGet_nodeFromNumber(dataObj, movedNode);
      g_return_if_fail(node);

      node->xyz[0] = moveNodeOrigin[0];
      node->xyz[1] = moveNodeOrigin[1];
      node->xyz[2] = moveNodeOrigin[2];
      visuData_createNodes(dataObj, dataObj->fromIntToVisuElement[node->posElement]);

      numericalEntrySet_value(NUMERICAL_ENTRY(entryMoveXYZ[0]), moveNodeOrigin[0]);
      numericalEntrySet_value(NUMERICAL_ENTRY(entryMoveXYZ[1]), moveNodeOrigin[1]);
      numericalEntrySet_value(NUMERICAL_ENTRY(entryMoveXYZ[2]), moveNodeOrigin[2]);
    }
  else
    {
      trans[0] = (float)numericalEntryGet_value(NUMERICAL_ENTRY(entryMoveXYZ[0]));
      trans[1] = (float)numericalEntryGet_value(NUMERICAL_ENTRY(entryMoveXYZ[1]));
      trans[2] = (float)numericalEntryGet_value(NUMERICAL_ENTRY(entryMoveXYZ[2]));

      tmpLst = lst = gtkPickGet_nodeSelection();
      while(tmpLst)
	{
	  node = visuDataGet_nodeFromNumber(dataObj, GPOINTER_TO_INT(tmpLst->data));
	  if (node)
	    {
	      node->xyz[0] -= trans[0];
	      node->xyz[1] -= trans[1];
	      node->xyz[2] -= trans[2];
	    }
	  tmpLst = g_list_next(tmpLst);
	}
      g_list_free(lst);

      visuData_createAllNodes(dataObj);

      numericalEntrySet_value(NUMERICAL_ENTRY(entryMoveXYZ[0]), 0.);
      numericalEntrySet_value(NUMERICAL_ENTRY(entryMoveXYZ[1]), 0.);
      numericalEntrySet_value(NUMERICAL_ENTRY(entryMoveXYZ[2]), 0.);
    }
  visuDataEmit_nodePositionChanged(dataObj);

  g_signal_emit (visu, VISU_GET_CLASS (visu)->OpenGLAskForReDraw_signal_id,
		 0 , NULL);
}
static void onRemoveNodeClicked(GtkButton *button _U_, gpointer user_data _U_)
{
  int *nodes;
  VisuData *dataObj;
  VisuNode *node;
  int iEle, i;
  GList *lst, *tmpLst;

  DBG_fprintf(stderr, "Gtk Observe/pick: remove the selected node %d.\n", movedNode);
  
  dataObj = renderingWindowGet_visuData
    (RENDERING_WINDOW(visuRenderingWindowGet_current()));

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radioMovePick)))
    {
      if (movedNode < 0)
	return;

      node = visuDataGet_nodeFromNumber(dataObj, movedNode);
      if (!node)
	return;
      iEle = node->posElement;

      nodes = g_malloc(sizeof(int) * 2);
      nodes[0] = movedNode;
      nodes[1] = -1;
      visuDataRemove_nodes(dataObj, nodes);
      g_free(nodes);

      /* Copy the coordinates to the add entries. */
      for (i = 0; i < 3; i++)
	numericalEntrySet_value(NUMERICAL_ENTRY(entryAddXYZ[i]),
				numericalEntryGet_value(NUMERICAL_ENTRY(entryMoveXYZ[i])));
      gtk_combo_box_set_active(GTK_COMBO_BOX(comboElements), iEle);

      visuData_createNodes(dataObj, dataObj->fromIntToVisuElement[iEle]);
    }
  else
    {
      tmpLst = lst = gtkPickGet_nodeSelection();
      nodes = g_malloc(sizeof(int) * (g_list_length(lst) + 1));
      i = 0;
      while(tmpLst)
	{
	  nodes[i] = GPOINTER_TO_INT(tmpLst->data);
	  i += 1;
	  tmpLst = g_list_next(tmpLst);
	}
      g_list_free(lst);
      nodes[i] = -1;
      visuDataRemove_nodes(dataObj, nodes);
      g_free(nodes);

      visuData_createAllNodes(dataObj);
    }
  /* We remove the node as selected one. */
  setLabelsOrigin((GList*)0);

  g_idle_add(visuObjectRedraw, (gpointer)0);
}
static void onAddNodeClicked(GtkButton *button _U_, gpointer user_data _U_)
{
  RenderingWindow *window;
  VisuData *dataObj;
  GtkTreeIter iter;
  gboolean valid;
  VisuElement *element;
  float xyz[3];
  int i;

  window = RENDERING_WINDOW(visuRenderingWindowGet_current());
  g_return_if_fail(window);

  dataObj = renderingWindowGet_visuData(window);

  valid = gtk_combo_box_get_active_iter(GTK_COMBO_BOX(comboElements), &iter);
  g_return_if_fail(valid);

  gtk_tree_model_get(GTK_TREE_MODEL(listElements), &iter,
		     COLUMN_POINTER_TO_DATA, &element,
		     -1);
  for (i = 0; i < 3; i++)
    xyz[i] = (float)numericalEntryGet_value(NUMERICAL_ENTRY(entryAddXYZ[i]));
  visuDataAdd_nodeFromElement(dataObj, element, xyz);

  /* We update all drawings. */
  visuDataEmit_nodePositionChanged(dataObj);
  visuData_createNodes(dataObj, element);
  g_idle_add(visuObjectRedraw, (gpointer)0);
}
